/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.demoUtils.swing;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import jetbrains.datalore.plot.builder.PlotSvgComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH$J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/vis/demoUtils/swing/PlotObjectsDemoWindowBase;", "Ljavax/swing/JFrame;", "title", "", "plotList", "", "Ljetbrains/datalore/plot/builder/PlotSvgComponent;", "maxCol", "", "plotSize", "Ljava/awt/Dimension;", "(Ljava/lang/String;Ljava/util/List;ILjava/awt/Dimension;)V", "rootPanel", "Ljavax/swing/JPanel;", "createPlotComponent", "Ljavax/swing/JComponent;", "plot", "createWindowContent", "", "open", "vis-demo-common"})
public abstract class PlotObjectsDemoWindowBase
extends JFrame {
    @NotNull
    private final List<PlotSvgComponent> plotList;
    private final int maxCol;
    @NotNull
    private final Dimension plotSize;
    @NotNull
    private final JPanel rootPanel;

    public PlotObjectsDemoWindowBase(@NotNull String title, @NotNull List<PlotSvgComponent> plotList, int maxCol, @NotNull Dimension plotSize) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(plotList, (String)"plotList");
        Intrinsics.checkNotNullParameter((Object)plotSize, (String)"plotSize");
        super(title);
        this.plotList = plotList;
        this.maxCol = maxCol;
        this.plotSize = plotSize;
        this.setDefaultCloseOperation(3);
        this.rootPanel = new JPanel();
        this.rootPanel.setLayout(new GridLayout(0, Math.min(this.maxCol, this.plotList.size())));
        this.rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane scrollPane = new JScrollPane(this.rootPanel, 20, 30);
        this.getContentPane().add(scrollPane);
    }

    public final void open() {
        SwingUtilities.invokeLater(() -> PlotObjectsDemoWindowBase.open$lambda$0(this));
    }

    private final void createWindowContent() {
        for (PlotSvgComponent plot : this.plotList) {
            this.rootPanel.add(this.createPlotComponent(plot, this.plotSize));
        }
    }

    @NotNull
    protected abstract JComponent createPlotComponent(@NotNull PlotSvgComponent var1, @NotNull Dimension var2);

    private static final void open$lambda$0(PlotObjectsDemoWindowBase this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.createWindowContent();
        this$0.pack();
        this$0.setLocationRelativeTo(null);
        this$0.setVisible(true);
    }
}

