/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.DoubleProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.IdentityKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=4)
@TestElementMetadata(labelResource="displayName")
public class ConstantThroughputTimer
extends AbstractTestElement
implements Timer,
TestStateListener,
TestBean {
    private static final long serialVersionUID = 4L;
    private static final Logger log = LoggerFactory.getLogger(ConstantThroughputTimer.class);
    private static final double MILLISEC_PER_MIN = 60000.0;
    private static final Mode DEFAULT_CALC_MODE = Mode.ThisThreadOnly;
    public static final String THROUGHPUT = "throughput";
    public static final String CALC_MODE = "calcMode";
    private long previousTime = 0L;
    private static final ThroughputInfo allThreadsInfo = new ThroughputInfo();
    private static final ConcurrentMap<IdentityKey<AbstractThreadGroup>, ThroughputInfo> threadGroupsInfoMap = new ConcurrentHashMap<IdentityKey<AbstractThreadGroup>, ThroughputInfo>();

    public void setThroughput(double throughput) {
        this.setProperty((JMeterProperty)new DoubleProperty(THROUGHPUT, throughput));
    }

    public double getThroughput() {
        return this.getPropertyAsDouble(THROUGHPUT);
    }

    public int getCalcMode() {
        return this.getPropertyAsInt(CALC_MODE, DEFAULT_CALC_MODE.ordinal());
    }

    public void setCalcMode(int mode) {
        Mode resolved = Mode.CACHED_VALUES[mode];
        this.setProperty((JMeterProperty)new IntegerProperty(CALC_MODE, resolved.ordinal()));
    }

    public long delay() {
        long currentTarget;
        long currentTime = System.currentTimeMillis();
        if (currentTime > (currentTarget = this.previousTime + this.calculateDelay())) {
            this.previousTime = currentTime;
            return 0L;
        }
        this.previousTime = currentTarget;
        return currentTarget - currentTime;
    }

    protected long calculateCurrentTarget(long currentTime) {
        return currentTime + this.calculateDelay();
    }

    private long calculateDelay() {
        long delay;
        double msPerRequest = 60000.0 / this.getThroughput();
        switch (this.getMode()) {
            case AllActiveThreads: {
                delay = Math.round((double)JMeterContextService.getNumberOfThreads() * msPerRequest);
                break;
            }
            case AllActiveThreadsInCurrentThreadGroup: {
                delay = Math.round((double)JMeterContextService.getContext().getThreadGroup().getNumberOfThreads() * msPerRequest);
                break;
            }
            case AllActiveThreads_Shared: {
                delay = ConstantThroughputTimer.calculateSharedDelay(allThreadsInfo, Math.round(msPerRequest));
                break;
            }
            case AllActiveThreadsInCurrentThreadGroup_Shared: {
                AbstractThreadGroup group = JMeterContextService.getContext().getThreadGroup();
                IdentityKey key = new IdentityKey((Object)group);
                ThroughputInfo groupInfo = (ThroughputInfo)threadGroupsInfoMap.get(key);
                if (groupInfo == null) {
                    groupInfo = threadGroupsInfoMap.computeIfAbsent((IdentityKey<AbstractThreadGroup>)key, k -> new ThroughputInfo());
                }
                delay = ConstantThroughputTimer.calculateSharedDelay(groupInfo, Math.round(msPerRequest));
                break;
            }
            default: {
                delay = Math.round(msPerRequest);
            }
        }
        return delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long calculateSharedDelay(ThroughputInfo info, long milliSecPerRequest) {
        long calculatedDelay;
        long now = System.currentTimeMillis();
        Object object = info.MUTEX;
        synchronized (object) {
            long nextRequestTime = info.lastScheduledTime + milliSecPerRequest;
            info.lastScheduledTime = Math.max(now, nextRequestTime);
            calculatedDelay = info.lastScheduledTime - now;
        }
        return Math.max(calculatedDelay, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Object object = ConstantThroughputTimer.allThreadsInfo.MUTEX;
        synchronized (object) {
            ConstantThroughputTimer.allThreadsInfo.lastScheduledTime = 0L;
        }
        threadGroupsInfoMap.clear();
        this.previousTime = 0L;
    }

    public String toString() {
        return JMeterUtils.getResString((String)"constant_throughput_timer_memo");
    }

    public void testStarted() {
        log.debug("Test started - reset throughput calculation.");
        this.reset();
    }

    public void setProperty(JMeterProperty property) {
        String pn;
        if (property instanceof StringProperty && (pn = property.getName()).equals(CALC_MODE)) {
            Object objectValue = property.getObjectValue();
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(((Object)((Object)this)).getClass());
                ResourceBundle rb = (ResourceBundle)beanInfo.getBeanDescriptor().getValue("resourceBundle");
                for (Mode e : Mode.CACHED_VALUES) {
                    String propName = ((Enum)e).toString();
                    if (!objectValue.equals(rb.getObject(propName))) continue;
                    int tmpMode = e.ordinal();
                    log.debug("Converted {}={} to mode={} using Locale: {}", new Object[]{pn, objectValue, tmpMode, rb.getLocale()});
                    super.setProperty(pn, tmpMode);
                    return;
                }
                log.warn("Could not convert {}={} using Locale: {}", new Object[]{pn, objectValue, rb.getLocale()});
            }
            catch (IntrospectionException e) {
                log.error("Could not find BeanInfo", (Throwable)e);
            }
        }
        super.setProperty(property);
    }

    public void testEnded() {
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded(String host) {
    }

    Mode getMode() {
        int mode = this.getCalcMode();
        return Mode.CACHED_VALUES[mode];
    }

    void setMode(Mode newMode) {
        this.setCalcMode(newMode.ordinal());
    }

    public static enum Mode {
        ThisThreadOnly("calcMode.1"),
        AllActiveThreads("calcMode.2"),
        AllActiveThreadsInCurrentThreadGroup("calcMode.3"),
        AllActiveThreads_Shared("calcMode.4"),
        AllActiveThreadsInCurrentThreadGroup_Shared("calcMode.5");

        private final String propertyName;
        private static final Mode[] CACHED_VALUES;

        private Mode(String name) {
            this.propertyName = name;
        }

        public String toString() {
            return this.propertyName;
        }

        static {
            CACHED_VALUES = Mode.values();
        }
    }

    private static class ThroughputInfo {
        final Object MUTEX = new Object();
        long lastScheduledTime = 0L;

        private ThroughputInfo() {
        }
    }
}

