/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.awt.LayoutManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.Validate;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JsseSSLManager;
import org.apache.jmeter.util.keystore.JmeterKeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSLManager {
    private static final Logger log = LoggerFactory.getLogger(SSLManager.class);
    private static final String SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String JAVAX_NET_SSL_KEY_STORE = "javax.net.ssl.keyStore";
    private static final String JAVAX_NET_SSL_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String PKCS12 = "pkcs12";
    private static SSLManager manager;
    private static final boolean IS_SSL_SUPPORTED = true;
    private JmeterKeyStore keyStore;
    private KeyStore trustStore = null;
    private volatile boolean truststoreLoaded = false;
    protected volatile String defaultpw = System.getProperty("javax.net.ssl.keyStorePassword");
    private int keystoreAliasStartIndex;
    private int keystoreAliasEndIndex;
    private String clientCertAliasVarName;

    public static synchronized void reset() {
        manager = null;
    }

    public abstract void setContext(HttpURLConnection var1);

    protected void setProvider(Provider provider) {
        if (null != provider) {
            Security.addProvider(provider);
        }
    }

    protected synchronized JmeterKeyStore getKeyStore() {
        if (null == this.keyStore) {
            String fileName = System.getProperty(JAVAX_NET_SSL_KEY_STORE, "");
            String fileType = System.getProperty(JAVAX_NET_SSL_KEY_STORE_TYPE, fileName.toLowerCase(Locale.ENGLISH).endsWith(".p12") ? PKCS12 : "JKS");
            log.info("JmeterKeyStore Location: {} type {}", (Object)fileName, (Object)fileType);
            try {
                this.keyStore = JmeterKeyStore.getInstance(fileType, this.keystoreAliasStartIndex, this.keystoreAliasEndIndex, this.clientCertAliasVarName);
                log.info("KeyStore created OK");
            }
            catch (Exception e) {
                this.keyStore = null;
                throw new IllegalArgumentException("Could not create keystore: " + e.getMessage(), e);
            }
            try {
                if ("NONE".equalsIgnoreCase(fileName)) {
                    this.retryLoadKeys(null, false);
                    log.info("Total of {} aliases loaded OK from PKCS11", (Object)this.keyStore.getAliasCount());
                } else {
                    File initStore = new File(fileName);
                    if (fileName.length() > 0 && initStore.exists()) {
                        this.retryLoadKeys(initStore, true);
                        if (log.isInfoEnabled()) {
                            log.info("Total of {} aliases loaded OK from keystore {}", (Object)this.keyStore.getAliasCount(), (Object)fileName);
                        }
                    } else {
                        log.warn("Keystore file not found, loading empty keystore");
                        this.defaultpw = "";
                        this.keyStore.load(null, "");
                    }
                }
            }
            catch (IOException e) {
                log.error("Can't load keystore '{}'. Wrong password?", (Object)fileName, (Object)e);
            }
            catch (UnrecoverableKeyException e) {
                log.error("Can't recover keys from keystore '{}'", (Object)fileName, (Object)e);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Problem finding the correct algorithm while loading keys from keystore '{}'", (Object)fileName, (Object)e);
            }
            catch (CertificateException e) {
                log.error("Problem with one of the certificates/keys in keystore '{}'", (Object)fileName, (Object)e);
            }
            catch (KeyStoreException e) {
                log.error("Problem loading keystore: {}", (Object)e.getMessage(), (Object)e);
            }
            if (log.isDebugEnabled()) {
                log.debug("JmeterKeyStore type: {}", this.keyStore.getClass());
            }
        }
        return this.keyStore;
    }

    private void retryLoadKeys(File initStore, boolean allowEmptyPassword) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        for (int i = 0; i < 3; ++i) {
            String password = this.getPassword();
            if (!allowEmptyPassword) {
                Validate.notNull((Object)password, (String)"Password for keystore must not be null", (Object[])new Object[0]);
            }
            try {
                if (initStore == null) {
                    this.keyStore.load(null, password);
                } else {
                    try (FileInputStream fis = new FileInputStream(initStore);){
                        this.keyStore.load(fis, password);
                    }
                }
                return;
            }
            catch (IOException e) {
                log.warn("Could not load keystore '{}'. Wrong password for keystore?", (Object)initStore, (Object)e);
                this.defaultpw = null;
                continue;
            }
        }
    }

    private String getPassword() {
        String password = this.defaultpw;
        if (null == password) {
            GuiPackage guiInstance = GuiPackage.getInstance();
            if (guiInstance != null) {
                JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2", "[][fill, grow]"));
                JLabel passwordLabel = new JLabel("Password: ");
                JPasswordField pwf = new JPasswordField(64);
                pwf.setEchoChar('*');
                passwordLabel.setLabelFor(pwf);
                panel.add(passwordLabel);
                panel.add(pwf);
                int choice = JOptionPane.showConfirmDialog(guiInstance.getMainFrame(), panel, JMeterUtils.getResString("ssl_pass_prompt"), 2, -1);
                if (choice == 0) {
                    char[] pwchars = pwf.getPassword();
                    this.defaultpw = new String(pwchars);
                    Arrays.fill(pwchars, '*');
                }
                System.setProperty(KEY_STORE_PASSWORD, this.defaultpw);
                password = this.defaultpw;
            }
        } else {
            log.warn("No password provided, and no GUI present so cannot prompt");
        }
        return password;
    }

    protected KeyStore getTrustStore() {
        block12: {
            if (!this.truststoreLoaded) {
                this.truststoreLoaded = true;
                String fileName = System.getProperty(SSL_TRUST_STORE);
                if (fileName == null) {
                    return null;
                }
                log.info("TrustStore Location: {}", (Object)fileName);
                try {
                    this.trustStore = KeyStore.getInstance("JKS");
                    log.info("TrustStore created OK, Type: JKS");
                }
                catch (Exception e) {
                    this.trustStore = null;
                    throw new RuntimeException("Problem creating truststore: " + e.getMessage(), e);
                }
                try {
                    File initStore = new File(fileName);
                    if (initStore.exists()) {
                        try (FileInputStream fis = new FileInputStream(initStore);){
                            this.trustStore.load(fis, null);
                            log.info("Truststore loaded OK from file");
                            break block12;
                        }
                    }
                    log.warn("Truststore file not found, loading empty truststore");
                    this.trustStore.load(null, null);
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't load TrustStore: " + e.getMessage(), e);
                }
            }
        }
        return this.trustStore;
    }

    protected SSLManager() {
    }

    public static synchronized SSLManager getInstance() {
        if (null == manager) {
            manager = new JsseSSLManager(null);
        }
        return manager;
    }

    public static boolean isSSLSupported() {
        return true;
    }

    public synchronized void configureKeystore(boolean preload, int startIndex, int endIndex, String clientCertAliasVarName) {
        this.keystoreAliasStartIndex = startIndex;
        this.keystoreAliasEndIndex = endIndex;
        this.clientCertAliasVarName = clientCertAliasVarName;
        if (preload) {
            this.keyStore = this.getKeyStore();
        }
    }

    public synchronized void destroyKeystore() {
        this.keyStore = null;
    }
}

