/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.lang.reflect.Field;
import org.apache.jmeter.samplers.SampleSaveConfiguration;

public class SampleSaveConfigurationConverter
extends ReflectionConverter {
    private static final ReflectionProvider rp;
    private static final String TRUE = "true";
    private static final String NODE_FILENAME = "fileName";
    private static final String NODE_HOSTNAME = "hostname";
    private static final String NODE_URL = "url";
    private static final String NODE_BYTES = "bytes";
    private static final String NODE_SENT_BYTES = "sentBytes";
    private static final String NODE_THREAD_COUNT = "threadCounts";
    private static final String NODE_SAMPLE_COUNT = "sampleCount";
    private static final String NODE_IDLE_TIME = "idleTime";
    private static final String NODE_CONNECT_TIME = "connectTime";
    private static final String NODE_DELIMITER = "delimiter";
    private static final String NODE_PRINTMS = "printMilliseconds";

    public SampleSaveConfigurationConverter(Mapper arg0) {
        super((Mapper)new MyWrapper(arg0), rp);
    }

    public static String getVersion() {
        return "$Revision$";
    }

    public boolean canConvert(Class arg0) {
        return SampleSaveConfiguration.class.equals((Object)arg0);
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer, MarshallingContext context) {
        super.marshal(obj, writer, context);
        SampleSaveConfiguration prop = (SampleSaveConfiguration)obj;
        SampleSaveConfigurationConverter.createNode(writer, prop.saveBytes(), NODE_BYTES);
        SampleSaveConfigurationConverter.createNode(writer, prop.saveSentBytes(), NODE_SENT_BYTES);
        SampleSaveConfigurationConverter.createNode(writer, prop.saveUrl(), NODE_URL);
        SampleSaveConfigurationConverter.createNode(writer, prop.saveFileName(), NODE_FILENAME);
        SampleSaveConfigurationConverter.createNode(writer, prop.saveHostname(), NODE_HOSTNAME);
        SampleSaveConfigurationConverter.createNode(writer, prop.saveThreadCounts(), NODE_THREAD_COUNT);
        SampleSaveConfigurationConverter.createNode(writer, prop.saveSampleCount(), NODE_SAMPLE_COUNT);
        SampleSaveConfigurationConverter.createNode(writer, prop.saveIdleTime(), NODE_IDLE_TIME);
        SampleSaveConfigurationConverter.createNode(writer, prop.saveConnectTime(), NODE_CONNECT_TIME);
    }

    private static void createNode(HierarchicalStreamWriter writer, boolean save, String node) {
        if (!save) {
            return;
        }
        writer.startNode(node);
        writer.setValue(TRUE);
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class<SampleSaveConfiguration> thisClass = SampleSaveConfiguration.class;
        Class requiredType = context.getRequiredType();
        if (requiredType != thisClass) {
            throw new IllegalArgumentException("Unexpected class: " + requiredType.getName());
        }
        SampleSaveConfiguration result = new SampleSaveConfiguration(false);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nn = reader.getNodeName();
            if (!"formatter".equals(nn)) {
                String fieldName = this.mapper.realMember(thisClass, nn);
                Field field = this.reflectionProvider.getField(thisClass, fieldName);
                Class<?> type = field.getType();
                Object value = this.unmarshallField(context, result, type, field);
                this.reflectionProvider.writeField((Object)result, nn, value, thisClass);
            }
            reader.moveUp();
        }
        return result;
    }

    static {
        ReflectionProvider tmp;
        try {
            tmp = JVM.newReflectionProvider();
        }
        catch (NullPointerException e) {
            tmp = new PureJavaReflectionProvider();
        }
        rp = tmp;
    }

    static class MyWrapper
    extends MapperWrapper {
        public MyWrapper(Mapper wrapped) {
            super(wrapped);
        }

        public boolean shouldSerializeMember(Class definedIn, String fieldName) {
            if (SampleSaveConfiguration.class != definedIn) {
                return true;
            }
            switch (fieldName) {
                case "bytes": 
                case "sentBytes": 
                case "url": 
                case "fileName": 
                case "hostname": 
                case "threadCounts": 
                case "sampleCount": 
                case "idleTime": 
                case "connectTime": 
                case "delimiter": 
                case "printMilliseconds": {
                    return false;
                }
            }
            return true;
        }
    }
}

