/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.dsl;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.jmeter.dsl.DslPrinterTraverser;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestElementSchema;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.DoubleProperty;
import org.apache.jmeter.testelement.property.FloatProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.testelement.schema.PropertyDescriptor;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.EXPERIMENTAL, since="5.6")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 $2\u00020\u0001:\u0002$%B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0000H\u0002J\b\u0010!\u001a\u00020\u000bH\u0016J\b\u0010\"\u001a\u00020\u000bH\u0016J\b\u0010#\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/apache/jmeter/dsl/DslPrinterTraverser;", "Lorg/apache/jorphan/collections/HashTreeTraverser;", "detailLevel", "Lorg/apache/jmeter/dsl/DslPrinterTraverser$DetailLevel;", "(Lorg/apache/jmeter/dsl/DslPrinterTraverser$DetailLevel;)V", "level", "", "plusPosition", "sw", "Ljava/io/StringWriter;", "addNode", "", "node", "", "subTree", "Lorg/apache/jorphan/collections/HashTree;", "append", "value", "", "", "testElement", "Lorg/apache/jmeter/testelement/TestElement;", "appendElement", "te", "appendLiteral", "literal", "appendProperties", "canSkipTestClass", "", "appendPropertyValue", "property", "Lorg/apache/jmeter/testelement/property/JMeterProperty;", "indent", "processPath", "subtractNode", "toString", "Companion", "DetailLevel", "ApacheJMeter_core"})
@SourceDebugExtension(value={"SMAP\nDslPrinterTraverser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DslPrinterTraverser.kt\norg/apache/jmeter/dsl/DslPrinterTraverser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1#2:244\n*E\n"})
public final class DslPrinterTraverser
implements HashTreeTraverser {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final DetailLevel detailLevel;
    @NotNull
    private final StringWriter sw;
    private int level;
    private int plusPosition;
    @NotNull
    private static final Regex SPECIAL_CHARS = new Regex("[\"\n\r\t\b\\\\$]");

    public DslPrinterTraverser(@NotNull DetailLevel detailLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)detailLevel), (String)"detailLevel");
        this.detailLevel = detailLevel;
        this.sw = new StringWriter();
        this.plusPosition = -1;
    }

    public /* synthetic */ DslPrinterTraverser(DetailLevel detailLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            detailLevel = DetailLevel.NON_DEFAULT;
        }
        this(detailLevel);
    }

    @NotNull
    public String toString() {
        String string = this.sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        return string;
    }

    @NotNull
    public final DslPrinterTraverser append(@NotNull TestElement testElement) {
        Intrinsics.checkNotNullParameter((Object)testElement, (String)"testElement");
        this.addNode(testElement, new HashTree());
        this.subtractNode();
        return this;
    }

    public void addNode(@NotNull Object node, @NotNull HashTree subTree) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)subTree, (String)"subTree");
        StringBuffer stringBuffer = this.sw.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)stringBuffer, (String)"sw.buffer");
        if (((CharSequence)stringBuffer).length() > 0) {
            this.append('\n');
        }
        if ((object = node) instanceof TestElement) {
            this.appendElement((TestElement)node);
        } else if (object instanceof JMeterTreeNode) {
            TestElement testElement = ((JMeterTreeNode)node).getTestElement();
            Intrinsics.checkNotNullExpressionValue((Object)testElement, (String)"node.testElement");
            this.appendElement(testElement);
        }
    }

    private final void appendElement(TestElement te) {
        this.indent();
        this.plusPosition = this.sw.getBuffer().length();
        String string = te.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"te::class.java.name");
        this.append(string).append("::class {\n");
        ++this.level;
        this.appendProperties(te, true);
    }

    public void subtractNode() {
        --this.level;
        StringBuffer stringBuffer = this.sw.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)stringBuffer, (String)"sw.buffer");
        if (StringsKt.endsWith$default((CharSequence)stringBuffer, (CharSequence)" {\n", (boolean)false, (int)2, null)) {
            this.sw.getBuffer().setLength(this.sw.getBuffer().length() - 3);
            this.sw.getBuffer().insert(this.plusPosition, '+');
            this.append("\n");
        } else {
            this.indent().append("}\n");
        }
    }

    public void processPath() {
    }

    private final void appendProperties(TestElement te, boolean canSkipTestClass) {
        PropertyDescriptor prop;
        TestElement emptyTe = (TestElement)te.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        TestElementSchema schema = te.getSchema();
        Map schemaProps = new LinkedHashMap();
        List otherProps = new ArrayList();
        Iterator<JMeterProperty> iterator = te.propertyIterator();
        while (iterator.hasNext()) {
            JMeterProperty jMeterProperty = iterator.next();
            String string = jMeterProperty.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.name");
            if (Intrinsics.areEqual((Object)emptyTe.getPropertyOrNull(string), (Object)jMeterProperty) && this.detailLevel != DetailLevel.ALL) continue;
            prop = schema.getProperties().get(jMeterProperty.getName());
            if (this.detailLevel != DetailLevel.ALL) {
                Object object;
                String stringValue = jMeterProperty.getStringValue();
                if (Intrinsics.areEqual(prop, TestElementSchema.INSTANCE.getTestClass()) && Intrinsics.areEqual((Object)stringValue, (Object)te.getClass().getName()) && canSkipTestClass || jMeterProperty instanceof StringProperty && ((object = (CharSequence)stringValue) == null || object.length() == 0)) continue;
                PropertyDescriptor propertyDescriptor = prop;
                if (Intrinsics.areEqual((Object)stringValue, (Object)(propertyDescriptor != null ? propertyDescriptor.getDefaultValueAsString() : null))) continue;
            }
            if (prop == null) {
                ((Collection)otherProps).add(jMeterProperty);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)jMeterProperty, (String)"property");
            schemaProps.put(prop, jMeterProperty);
        }
        if (!schemaProps.isEmpty()) {
            this.indent().append("props {\n");
            ++this.level;
            for (Map.Entry entry : schemaProps.entrySet()) {
                prop = (PropertyDescriptor)entry.getKey();
                JMeterProperty value = (JMeterProperty)entry.getValue();
                this.indent().append("it[");
                for (String item : schema.getGroupPath(prop)) {
                    this.append(item).append('.');
                }
                this.append(prop.getShortName()).append("] = ");
                this.appendPropertyValue(value);
                this.append('\n');
            }
            --this.level;
            this.indent().append("}\n");
        }
        for (JMeterProperty jMeterProperty : otherProps) {
            boolean usePropertyConstructor;
            if (jMeterProperty instanceof StringProperty && Intrinsics.areEqual((Object)((StringProperty)jMeterProperty).getStringValue(), (Object)"")) continue;
            this.indent().append("setProperty(");
            boolean bl = usePropertyConstructor = jMeterProperty instanceof TestElementProperty || jMeterProperty instanceof MultiProperty;
            if (usePropertyConstructor) {
                String string = jMeterProperty.getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property::class.java.simpleName");
                this.append(string).append('(');
            }
            String string = jMeterProperty.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.name");
            this.appendLiteral(string).append(", ");
            this.appendPropertyValue(jMeterProperty);
            if (usePropertyConstructor) {
                this.append(')');
            }
            this.append(")\n");
        }
    }

    private final DslPrinterTraverser appendPropertyValue(JMeterProperty property) {
        DslPrinterTraverser dslPrinterTraverser;
        block12: {
            JMeterProperty jMeterProperty;
            DslPrinterTraverser $this$appendPropertyValue_u24lambda_u242;
            block16: {
                Object object;
                block17: {
                    block15: {
                        block14: {
                            block13: {
                                block11: {
                                    $this$appendPropertyValue_u24lambda_u242 = dslPrinterTraverser = this;
                                    boolean bl = false;
                                    jMeterProperty = property;
                                    if (!(jMeterProperty instanceof BooleanProperty ? true : jMeterProperty instanceof IntegerProperty)) break block11;
                                    String string = property.getStringValue();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.stringValue");
                                    $this$appendPropertyValue_u24lambda_u242.append(string);
                                    break block12;
                                }
                                if (!(jMeterProperty instanceof DoubleProperty)) break block13;
                                String string = ((DoubleProperty)property).getStringValue();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.stringValue");
                                $this$appendPropertyValue_u24lambda_u242.append(string);
                                break block12;
                            }
                            if (!(jMeterProperty instanceof FloatProperty)) break block14;
                            String string = ((FloatProperty)property).getStringValue();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.stringValue");
                            $this$appendPropertyValue_u24lambda_u242.append(string).append('f');
                            break block12;
                        }
                        if (!(jMeterProperty instanceof LongProperty)) break block15;
                        String string = ((LongProperty)property).getStringValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.stringValue");
                        $this$appendPropertyValue_u24lambda_u242.append(string).append('d');
                        break block12;
                    }
                    if (!(jMeterProperty instanceof StringProperty)) break block16;
                    String string = ((StringProperty)property).getStringValue();
                    object = string;
                    if (object == null) break block17;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stringValue");
                    String it = string;
                    boolean bl = false;
                    DslPrinterTraverser dslPrinterTraverser2 = $this$appendPropertyValue_u24lambda_u242.appendLiteral(it);
                    object = dslPrinterTraverser2;
                    if (dslPrinterTraverser2 != null) break block12;
                }
                DslPrinterTraverser $this$appendPropertyValue_u24lambda_u242_u24lambda_u241 = $this$appendPropertyValue_u24lambda_u242;
                boolean bl = false;
                object = $this$appendPropertyValue_u24lambda_u242_u24lambda_u241.append("null");
                break block12;
            }
            if (jMeterProperty instanceof TestElementProperty) {
                TestElement element = ((TestElementProperty)property).getElement();
                String string = element.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element::class.java.name");
                $this$appendPropertyValue_u24lambda_u242.append(string).append("()").append(".apply {\n");
                ++$this$appendPropertyValue_u24lambda_u242.level;
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                $this$appendPropertyValue_u24lambda_u242.appendProperties(element, false);
                --$this$appendPropertyValue_u24lambda_u242.level;
                StringBuffer stringBuffer = $this$appendPropertyValue_u24lambda_u242.sw.getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)stringBuffer, (String)"sw.buffer");
                if (StringsKt.endsWith$default((CharSequence)stringBuffer, (CharSequence)".apply {\n", (boolean)false, (int)2, null)) {
                    $this$appendPropertyValue_u24lambda_u242.sw.getBuffer().setLength($this$appendPropertyValue_u24lambda_u242.sw.getBuffer().length() - 9);
                } else {
                    $this$appendPropertyValue_u24lambda_u242.indent().append("}");
                }
            } else if (jMeterProperty instanceof CollectionProperty) {
                $this$appendPropertyValue_u24lambda_u242.append("listOf(\n");
                ++$this$appendPropertyValue_u24lambda_u242.level;
                PropertyIterator propertyIterator = ((CollectionProperty)property).iterator();
                Intrinsics.checkNotNullExpressionValue((Object)propertyIterator, (String)"property.iterator()");
                PropertyIterator propertyIterator2 = propertyIterator;
                while (propertyIterator2.hasNext()) {
                    JMeterProperty property1 = propertyIterator2.next();
                    $this$appendPropertyValue_u24lambda_u242.indent();
                    Intrinsics.checkNotNullExpressionValue((Object)property1, (String)"property1");
                    $this$appendPropertyValue_u24lambda_u242.appendPropertyValue(property1);
                    $this$appendPropertyValue_u24lambda_u242.append(",\n");
                }
                --$this$appendPropertyValue_u24lambda_u242.level;
                StringBuffer stringBuffer = $this$appendPropertyValue_u24lambda_u242.sw.getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)stringBuffer, (String)"sw.buffer");
                if (StringsKt.endsWith$default((CharSequence)stringBuffer, (CharSequence)"(\n", (boolean)false, (int)2, null)) {
                    $this$appendPropertyValue_u24lambda_u242.sw.getBuffer().setLength($this$appendPropertyValue_u24lambda_u242.sw.getBuffer().length() - 1);
                    $this$appendPropertyValue_u24lambda_u242.append(")");
                } else {
                    $this$appendPropertyValue_u24lambda_u242.indent().append(")");
                }
            } else {
                DslPrinterTraverser dslPrinterTraverser3 = $this$appendPropertyValue_u24lambda_u242.append("/* unsupported property type " + property.getClass().getSimpleName() + "*/");
                String string = property.getStringValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.stringValue");
                dslPrinterTraverser3.appendLiteral(string);
            }
        }
        return dslPrinterTraverser;
    }

    private final DslPrinterTraverser append(String value) {
        DslPrinterTraverser dslPrinterTraverser;
        DslPrinterTraverser $this$append_u24lambda_u243 = dslPrinterTraverser = this;
        boolean bl = false;
        $this$append_u24lambda_u243.sw.append(value);
        return dslPrinterTraverser;
    }

    private final DslPrinterTraverser append(char value) {
        DslPrinterTraverser dslPrinterTraverser;
        DslPrinterTraverser $this$append_u24lambda_u244 = dslPrinterTraverser = this;
        boolean bl = false;
        $this$append_u24lambda_u244.sw.append(value);
        return dslPrinterTraverser;
    }

    private final DslPrinterTraverser appendLiteral(String literal) {
        DslPrinterTraverser dslPrinterTraverser;
        DslPrinterTraverser $this$appendLiteral_u24lambda_u245 = dslPrinterTraverser = this;
        boolean bl = false;
        $this$appendLiteral_u24lambda_u245.append('\"');
        CharSequence charSequence = literal;
        Regex regex = SPECIAL_CHARS;
        Function1 function1 = appendLiteral.1.1.INSTANCE;
        $this$appendLiteral_u24lambda_u245.append(regex.replace(charSequence, function1));
        $this$appendLiteral_u24lambda_u245.append('\"');
        return dslPrinterTraverser;
    }

    private final DslPrinterTraverser indent() {
        DslPrinterTraverser dslPrinterTraverser;
        DslPrinterTraverser $this$indent_u24lambda_u247 = dslPrinterTraverser = this;
        boolean bl = false;
        int n = $this$indent_u24lambda_u247.level;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl2 = false;
            $this$indent_u24lambda_u247.sw.append("    ");
        }
        return dslPrinterTraverser;
    }

    public DslPrinterTraverser() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/apache/jmeter/dsl/DslPrinterTraverser$Companion;", "", "()V", "SPECIAL_CHARS", "Lkotlin/text/Regex;", "getSPECIAL_CHARS", "()Lkotlin/text/Regex;", "ApacheJMeter_core"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getSPECIAL_CHARS() {
            return SPECIAL_CHARS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/apache/jmeter/dsl/DslPrinterTraverser$DetailLevel;", "", "(Ljava/lang/String;I)V", "ALL", "NON_DEFAULT", "ApacheJMeter_core"})
    public static final class DetailLevel
    extends Enum<DetailLevel> {
        public static final /* enum */ DetailLevel ALL = new DetailLevel();
        public static final /* enum */ DetailLevel NON_DEFAULT = new DetailLevel();
        private static final /* synthetic */ DetailLevel[] $VALUES;

        public static DetailLevel[] values() {
            return (DetailLevel[])$VALUES.clone();
        }

        public static DetailLevel valueOf(String value) {
            return Enum.valueOf(DetailLevel.class, value);
        }

        static {
            $VALUES = detailLevelArray = new DetailLevel[]{DetailLevel.ALL, DetailLevel.NON_DEFAULT};
        }
    }
}

