/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StackTraceHelper {
    private static final String DEFAULT_LINE_SEPARATOR = "\n";
    private static final ICommonsList<String> STACKTRACE_OMIT_UNITTEST = new CommonsArrayList<String>();
    private static final ICommonsList<String> STACKTRACE_OMIT_APPSRV = new CommonsArrayList<String>();
    private static final StackTraceHelper INSTANCE;

    private StackTraceHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean _stopStackTraceListing(@Nonnull String string) {
        if (STACKTRACE_OMIT_UNITTEST.containsAny(string::startsWith)) return true;
        if (!STACKTRACE_OMIT_APPSRV.containsAny(string::startsWith)) return false;
        return true;
    }

    private static boolean _matchesParentStackTrace(@Nonnull StackTraceElement stackTraceElement, @Nullable StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement2 : stackTraceElementArray) {
                if (!stackTraceElement2.equals(stackTraceElement)) continue;
                return true;
            }
        }
        return false;
    }

    private static void _appendSingleStackTraceToString(@Nonnull StringBuilder stringBuilder, @Nonnull StackTraceElement[] stackTraceElementArray, @Nullable StackTraceElement[] stackTraceElementArray2, boolean bl, @Nonnull String string) {
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string2 = stackTraceElement.toString();
            if (bl && StackTraceHelper._stopStackTraceListing(string2) || StackTraceHelper._matchesParentStackTrace(stackTraceElement, stackTraceElementArray2)) {
                int n = stackTraceElementArray.length - i;
                stringBuilder.append("  [").append(n).append(n == 1 ? " element" : " elements").append(" omitted -- ").append(string2).append(']').append(string);
                break;
            }
            stringBuilder.append(i + 1).append(".: ").append(string2).append(string);
        }
    }

    public static void appendStackToString(@Nonnull StringBuilder stringBuilder, @Nonnull StackTraceElement[] stackTraceElementArray) {
        StackTraceHelper.appendStackToString(stringBuilder, stackTraceElementArray, DEFAULT_LINE_SEPARATOR);
    }

    public static void appendStackToString(@Nonnull StringBuilder stringBuilder, @Nonnull StackTraceElement[] stackTraceElementArray, @Nonnull String string) {
        ValueEnforcer.notNull(stringBuilder, "StringBuilder");
        ValueEnforcer.notNull(stackTraceElementArray, "StackTraceElements");
        ValueEnforcer.notNull(string, "LineSeparator");
        StackTraceHelper._appendSingleStackTraceToString(stringBuilder, stackTraceElementArray, null, true, string);
    }

    @Nonnull
    public static String getStackAsString(@Nonnull StackTraceElement[] stackTraceElementArray, boolean bl) {
        return StackTraceHelper.getStackAsString(stackTraceElementArray, bl, DEFAULT_LINE_SEPARATOR);
    }

    @Nonnull
    public static String getStackAsString(@Nonnull StackTraceElement[] stackTraceElementArray, boolean bl, @Nonnull String string) {
        ValueEnforcer.notNull(stackTraceElementArray, "StackTraceElements");
        ValueEnforcer.notNull(string, "LineSeparator");
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceHelper._appendSingleStackTraceToString(stringBuilder, stackTraceElementArray, null, bl, string);
        if (string.length() > 0 && StringHelper.endsWith((CharSequence)stringBuilder, (CharSequence)string)) {
            stringBuilder.delete(stringBuilder.length() - string.length(), stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getStackAsString(@Nonnull StackTraceElement[] stackTraceElementArray) {
        return StackTraceHelper.getStackAsString(stackTraceElementArray, true, DEFAULT_LINE_SEPARATOR);
    }

    @Nonnull
    public static String getStackAsString(@Nonnull Thread thread) {
        return StackTraceHelper.getStackAsString(thread.getStackTrace(), true, DEFAULT_LINE_SEPARATOR);
    }

    @Nonnull
    public static String getStackAsString(@Nonnull Thread thread, boolean bl) {
        return StackTraceHelper.getStackAsString(thread.getStackTrace(), bl, DEFAULT_LINE_SEPARATOR);
    }

    @Nonnull
    public static String getStackAsString(@Nonnull Thread thread, boolean bl, @Nonnull String string) {
        return StackTraceHelper.getStackAsString(thread.getStackTrace(), bl, string);
    }

    @Nonnull
    public static String getCurrentThreadStackAsString() {
        return StackTraceHelper.getStackAsString(Thread.currentThread().getStackTrace(), true, DEFAULT_LINE_SEPARATOR);
    }

    private static StringBuilder _getRecursiveStackAsStringBuilder(@Nonnull Throwable throwable, @Nullable Throwable throwable2, @Nullable StringBuilder stringBuilder, @Nonnegative int n, boolean bl, @Nonnull String string) {
        StringBuilder stringBuilder2 = stringBuilder == null ? new StringBuilder() : stringBuilder;
        stringBuilder2.append(throwable.toString()).append(string);
        StackTraceHelper._appendSingleStackTraceToString(stringBuilder2, throwable.getStackTrace(), throwable2 == null ? null : throwable2.getStackTrace(), bl, string);
        if (throwable.getCause() != null) {
            stringBuilder2.append("==> [").append(n).append("] caused by ");
            StackTraceHelper._getRecursiveStackAsStringBuilder(throwable.getCause(), throwable, stringBuilder2, n + 1, bl, string);
        }
        return stringBuilder2;
    }

    @Nonnull
    public static String getStackAsString(@Nullable Throwable throwable) {
        return StackTraceHelper.getStackAsString(throwable, true, DEFAULT_LINE_SEPARATOR);
    }

    @Nonnull
    public static String getStackAsString(@Nullable Throwable throwable, boolean bl) {
        return StackTraceHelper.getStackAsString(throwable, bl, DEFAULT_LINE_SEPARATOR);
    }

    @Nonnull
    public static String getStackAsString(@Nullable Throwable throwable, boolean bl, @Nonnull String string) {
        ValueEnforcer.notNull(string, "LineSeparator");
        if (throwable == null) {
            return "";
        }
        StringBuilder stringBuilder = StackTraceHelper._getRecursiveStackAsStringBuilder(throwable, null, null, 1, bl, string);
        if (string.length() > 0 && StringHelper.endsWith((CharSequence)stringBuilder, (CharSequence)string)) {
            stringBuilder.delete(stringBuilder.length() - string.length(), stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static boolean containsUnitTestElement(@Nullable Throwable throwable) {
        return throwable != null && StackTraceHelper.containsUnitTestElement(throwable.getStackTrace());
    }

    public static boolean containsUnitTestElement(@Nullable StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                String string = stackTraceElement.toString();
                if (!STACKTRACE_OMIT_UNITTEST.containsAny(string::startsWith)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        STACKTRACE_OMIT_UNITTEST.add("org.testng");
        STACKTRACE_OMIT_UNITTEST.add("org.junit.");
        STACKTRACE_OMIT_UNITTEST.add("junit.framework.");
        STACKTRACE_OMIT_APPSRV.add("org.apache.catalina.core");
        STACKTRACE_OMIT_APPSRV.add("org.mortbay.jetty.");
        STACKTRACE_OMIT_APPSRV.add("org.eclipse.jetty.");
        INSTANCE = new StackTraceHelper();
    }
}

