/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.svgMapper.batik;

import jetbrains.datalore.mapper.core.Mapper;
import jetbrains.datalore.mapper.core.MapperFactory;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgImageElement;
import jetbrains.datalore.vis.svg.SvgImageElementEx;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgTextNode;
import jetbrains.datalore.vis.svg.SvgUtils;
import jetbrains.datalore.vis.svgMapper.awt.RGBEncoderAwt;
import jetbrains.datalore.vis.svgMapper.batik.SvgBatikPeer;
import jetbrains.datalore.vis.svgMapper.batik.SvgElementMapper;
import jetbrains.datalore.vis.svgMapper.batik.SvgTextNodeMapper;
import jetbrains.datalore.vis.svgMapper.batik.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.dom.AbstractDocument;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0006\b\u0001\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/vis/svgMapper/batik/SvgNodeMapperFactory;", "Ljetbrains/datalore/mapper/core/MapperFactory;", "Ljetbrains/datalore/vis/svg/SvgNode;", "Lorg/w3c/dom/Node;", "myDoc", "Lorg/apache/batik/dom/AbstractDocument;", "myPeer", "Ljetbrains/datalore/vis/svgMapper/batik/SvgBatikPeer;", "(Lorg/apache/batik/dom/AbstractDocument;Ljetbrains/datalore/vis/svgMapper/batik/SvgBatikPeer;)V", "createMapper", "Ljetbrains/datalore/mapper/core/Mapper;", "source", "vis-svg-mapper-batik"})
public final class SvgNodeMapperFactory
implements MapperFactory<SvgNode, Node> {
    @NotNull
    private final AbstractDocument myDoc;
    @NotNull
    private final SvgBatikPeer myPeer;

    public SvgNodeMapperFactory(@NotNull AbstractDocument myDoc, @NotNull SvgBatikPeer myPeer) {
        Intrinsics.checkNotNullParameter((Object)myDoc, (String)"myDoc");
        Intrinsics.checkNotNullParameter((Object)myPeer, (String)"myPeer");
        this.myDoc = myDoc;
        this.myPeer = myPeer;
    }

    @NotNull
    public Mapper<? extends SvgNode, ? extends Node> createMapper(@NotNull SvgNode source) {
        Mapper mapper;
        SvgNode svgNode;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SvgNode src = source;
        Node target = Utils.INSTANCE.newBatikNode(src, this.myDoc);
        if (src instanceof SvgImageElementEx) {
            src = (SvgNode)((SvgImageElementEx)src).asImageElement((SvgImageElementEx.RGBEncoder)new RGBEncoderAwt());
        }
        if (src instanceof SvgImageElement) {
            SvgImageElement sourceBatik = new SvgImageElement();
            SvgUtils.INSTANCE.copyAttributes((SvgElement)src, (SvgElement)sourceBatik);
            sourceBatik.setAttribute("style", null);
            src = (SvgNode)sourceBatik;
        }
        if ((svgNode = src) instanceof SvgElement) {
            mapper = new SvgElementMapper<SvgElement, SVGOMElement>((SvgElement)src, (SVGOMElement)target, this.myDoc, this.myPeer);
        } else if (svgNode instanceof SvgTextNode) {
            mapper = new SvgTextNodeMapper((SvgTextNode)src, (Text)target, this.myDoc, this.myPeer);
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported SvgElement: ", (Object)Reflection.getOrCreateKotlinClass(src.getClass()).getSimpleName()));
        }
        return mapper;
    }
}

