/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.Name;
import org.xbill.DNS.Options;

public class Compression {
    private static final int TABLE_SIZE = 17;
    private static final int MAX_POINTER = 16383;
    private Entry[] table;
    private boolean verbose = Options.check("verbosecompression");

    public Compression() {
        this.table = new Entry[17];
    }

    public void add(int pos, Name name) {
        if (pos > 16383) {
            return;
        }
        int row = (name.hashCode() & Integer.MAX_VALUE) % 17;
        Entry entry = new Entry();
        entry.name = name;
        entry.pos = pos;
        entry.next = this.table[row];
        this.table[row] = entry;
        if (this.verbose) {
            System.err.println("Adding " + name + " at " + pos);
        }
    }

    public int get(Name name) {
        int row = (name.hashCode() & Integer.MAX_VALUE) % 17;
        int pos = -1;
        Entry entry = this.table[row];
        while (entry != null) {
            if (entry.name.equals(name)) {
                pos = entry.pos;
            }
            entry = entry.next;
        }
        if (this.verbose) {
            System.err.println("Looking for " + name + ", found " + pos);
        }
        return pos;
    }

    private static class Entry {
        Name name;
        int pos;
        Entry next;

        private Entry() {
        }
    }
}

