/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.server.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.logging.Logger;
import jetbrains.datalore.base.logging.PortableLogging;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.Stat;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.builder.VarBinding;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.data.DataProcessing;
import jetbrains.datalore.plot.builder.data.GroupingContext;
import jetbrains.datalore.plot.builder.data.OrderOptionUtil;
import jetbrains.datalore.plot.builder.sampling.Sampling;
import jetbrains.datalore.plot.builder.tooltip.DataFrameValue;
import jetbrains.datalore.plot.config.FailureHandler;
import jetbrains.datalore.plot.config.GeomProto;
import jetbrains.datalore.plot.config.LayerConfig;
import jetbrains.datalore.plot.config.Option;
import jetbrains.datalore.plot.config.OptionsSelectorKt;
import jetbrains.datalore.plot.config.PlotConfig;
import jetbrains.datalore.plot.config.PlotConfigUtil;
import jetbrains.datalore.plot.server.config.ConfiguredStatContext;
import jetbrains.datalore.plot.server.config.PlotSampling;
import jetbrains.datalore.plot.server.config.transform.PlotConfigServerSideTransforms;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006JN\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\bH\u0002J.\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00100\u00102\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002J\u0016\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\bH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002\u00a8\u0006!"}, d2={"Ljetbrains/datalore/plot/server/config/PlotConfigServerSide;", "Ljetbrains/datalore/plot/config/PlotConfig;", "opts", "", "", "", "(Ljava/util/Map;)V", "createLayerConfig", "Ljetbrains/datalore/plot/config/LayerConfig;", "layerOptions", "sharedData", "Ljetbrains/datalore/plot/base/DataFrame;", "plotMappings", "plotDiscreteAes", "", "plotOrderOptions", "", "Ljetbrains/datalore/plot/builder/data/OrderOptionUtil$OrderOption;", "createSamplingMessage", "samplingExpression", "layerConfig", "createStatMessage", "statInfo", "dataByTileByLayerAfterStat", "layerIndexAndSamplingMessage", "Lkotlin/Function2;", "", "", "dropUnusedDataBeforeEncoding", "layerConfigs", "getStatName", "updatePlotSpec", "Companion", "plot-config-portable"})
public class PlotConfigServerSide
extends PlotConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(PlotConfigServerSide.class));

    public PlotConfigServerSide(@NotNull Map<String, ? extends Object> opts) {
        Intrinsics.checkNotNullParameter(opts, (String)"opts");
        super(opts);
    }

    @Override
    @NotNull
    protected LayerConfig createLayerConfig(@NotNull Map<String, ? extends Object> layerOptions, @NotNull DataFrame sharedData, @NotNull Map<?, ?> plotMappings, @NotNull Set<?> plotDiscreteAes, @NotNull List<OrderOptionUtil.OrderOption> plotOrderOptions) {
        Intrinsics.checkNotNullParameter(layerOptions, (String)"layerOptions");
        Intrinsics.checkNotNullParameter((Object)sharedData, (String)"sharedData");
        Intrinsics.checkNotNullParameter(plotMappings, (String)"plotMappings");
        Intrinsics.checkNotNullParameter(plotDiscreteAes, (String)"plotDiscreteAes");
        Intrinsics.checkNotNullParameter(plotOrderOptions, (String)"plotOrderOptions");
        Object object = layerOptions.get("geom");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String geomName = (String)object;
        GeomKind geomKind = Option.GeomName.INSTANCE.toGeomKind(geomName);
        return new LayerConfig(layerOptions, sharedData, plotMappings, plotDiscreteAes, plotOrderOptions, new GeomProto(geomKind), false);
    }

    private final void updatePlotSpec() {
        HashSet<Integer> layerIndexWhereSamplingOccurred = new HashSet<Integer>();
        List<List<DataFrame>> dataByTileByLayerAfterStat2 = this.dataByTileByLayerAfterStat((Function2<? super Integer, ? super String, Unit>)((Function2)new Function2<Integer, String, Unit>(layerIndexWhereSamplingOccurred, this){
            final /* synthetic */ HashSet<Integer> $layerIndexWhereSamplingOccurred;
            final /* synthetic */ PlotConfigServerSide this$0;
            {
                this.$layerIndexWhereSamplingOccurred = $layerIndexWhereSamplingOccurred;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(int layerIndex, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.$layerIndexWhereSamplingOccurred.add(layerIndex);
                PlotConfigUtil.INSTANCE.addComputationMessage(this.this$0, message);
            }
        }));
        ArrayList<DataFrame> dataByLayerAfterStat = new ArrayList<DataFrame>();
        int n = 0;
        List<LayerConfig> layerConfigs = this.getLayerConfigs();
        int n2 = layerConfigs.size() + -1;
        if (n <= n2) {
            do {
                int layerIndex = n++;
                HashMap layerSerieByVarName = new HashMap();
                for (List<DataFrame> list2 : dataByTileByLayerAfterStat2) {
                    DataFrame tileLayerDataAfterStat = list2.get(layerIndex);
                    Set variables = tileLayerDataAfterStat.variables();
                    if (layerSerieByVarName.isEmpty()) {
                        for (DataFrame.Variable variable : variables) {
                            Map map2 = layerSerieByVarName;
                            String string = variable.getName();
                            Pair pair = new Pair((Object)variable, new ArrayList(tileLayerDataAfterStat.get(variable)));
                            boolean bl = false;
                            map2.put(string, pair);
                        }
                        continue;
                    }
                    for (DataFrame.Variable variable : variables) {
                        Object v = layerSerieByVarName.get(variable.getName());
                        Intrinsics.checkNotNull(v);
                        ((ArrayList)((Pair)v).getSecond()).addAll(tileLayerDataAfterStat.get(variable));
                    }
                }
                DataFrame.Builder builder = new DataFrame.Builder();
                for (String varName : layerSerieByVarName.keySet()) {
                    Object v = layerSerieByVarName.get(varName);
                    Intrinsics.checkNotNull(v);
                    DataFrame.Variable variable = (DataFrame.Variable)((Pair)v).getFirst();
                    Object v2 = layerSerieByVarName.get(varName);
                    Intrinsics.checkNotNull(v2);
                    ArrayList serie = (ArrayList)((Pair)v2).getSecond();
                    builder.put(variable, (List)serie);
                }
                DataFrame iterator = builder.build();
                dataByLayerAfterStat.add(iterator);
            } while (n <= n2);
        }
        PlotConfigServerSide plotConfigServerSide = this;
        n2 = 0;
        boolean bl = false;
        PlotConfigServerSide $this$updatePlotSpec_u24lambda_u2d0 = plotConfigServerSide;
        boolean bl2 = false;
        Iterator<LayerConfig> iterator = layerConfigs.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            int layerIndex = n3++;
            LayerConfig layerConfig = iterator.next();
            if (layerConfig.getStat() == Stats.INSTANCE.getIDENTITY() && !layerIndexWhereSamplingOccurred.contains(layerIndex)) continue;
            Object e = dataByLayerAfterStat.get(layerIndex);
            Intrinsics.checkNotNullExpressionValue(e, (String)"dataByLayerAfterStat[layerIndex]");
            DataFrame layerStatData = (DataFrame)e;
            layerConfig.replaceOwnData(layerStatData);
        }
        this.dropUnusedDataBeforeEncoding(layerConfigs);
    }

    private final void dropUnusedDataBeforeEncoding(List<LayerConfig> layerConfigs) {
        Object it22;
        Object element$iv$iv;
        Iterable $this$associateWith$iv = layerConfigs;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            LayerConfig layerConfig = (LayerConfig)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Set set = PlotConfigServerSide.Companion.variablesToKeep(this.getFacets(), (LayerConfig)it22);
            map2.put(t, set);
        }
        Map variablesToKeepByLayerConfig = result$iv;
        DataFrame plotData = this.getSharedData();
        Map plotVars = DataFrameUtil.INSTANCE.variables(plotData);
        HashSet<String> plotVarsToKeep = new HashSet<String>();
        for (String plotVar : plotVars.keySet()) {
            boolean canDropPlotVar = true;
            it22 = variablesToKeepByLayerConfig;
            boolean bl = false;
            element$iv$iv = it22.entrySet().iterator();
            while (element$iv$iv.hasNext()) {
                DataFrame layerData;
                Object object = it22 = (Map.Entry)element$iv$iv.next();
                boolean bl2 = false;
                LayerConfig layerConfig2 = (LayerConfig)object.getKey();
                Object object2 = it22;
                boolean bl3 = false;
                Set layerVarsToKeep = (Set)object2.getValue();
                Intrinsics.checkNotNull((Object)layerConfig2.getOwnData());
                if (DataFrameUtil.INSTANCE.variables(layerData).containsKey(plotVar) || !layerVarsToKeep.contains(plotVar)) continue;
                canDropPlotVar = false;
                break;
            }
            if (canDropPlotVar) continue;
            plotVarsToKeep.add(plotVar);
        }
        if (plotVarsToKeep.size() < plotVars.size()) {
            DataFrame plotDataCleaned = DataFrameUtil.INSTANCE.removeAllExcept(plotData, (Set)plotVarsToKeep);
            this.replaceSharedData(plotDataCleaned);
        }
        Object object = variablesToKeepByLayerConfig;
        boolean canDropPlotVar = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            DataFrame layerData;
            element$iv$iv = object = iterator2.next();
            boolean it22 = false;
            LayerConfig layerConfig = (LayerConfig)element$iv$iv.getKey();
            it22 = object;
            boolean layerConfig2 = false;
            Set layerVarsToKeep = (Set)it22.getValue();
            Intrinsics.checkNotNull((Object)layerConfig.getOwnData());
            DataFrame layerDataCleaned = DataFrameUtil.INSTANCE.removeAllExcept(layerData, layerVarsToKeep);
            layerConfig.replaceOwnData(layerDataCleaned);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<DataFrame>> dataByTileByLayerAfterStat(Function2<? super Integer, ? super String, Unit> layerIndexAndSamplingMessage) {
        ArrayList<DataFrame> dataByLayer = new ArrayList<DataFrame>();
        for (LayerConfig layerConfig : this.getLayerConfigs()) {
            DataFrame layerData = layerConfig.getCombinedData();
            layerData = DataProcessing.INSTANCE.transformOriginals(layerData, layerConfig.getVarBindings(), this.getScaleMap());
            dataByLayer.add(layerData);
        }
        PlotFacets facets = this.getFacets();
        List<List<DataFrame>> inputDataByTileByLayer = PlotConfigUtil.INSTANCE.toLayersDataByTile((List<DataFrame>)dataByLayer, facets);
        ArrayList result = new ArrayList();
        while (result.size() < inputDataByTileByLayer.size()) {
            result.add(new ArrayList());
        }
        Iterator<LayerConfig> iterator = this.getLayerConfigs().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int layerIndex = n++;
            LayerConfig layerConfig = iterator.next();
            ConfiguredStatContext statCtx = new ConfiguredStatContext((List<DataFrame>)dataByLayer, this.getScaleMap());
            int n2 = 0;
            int n3 = inputDataByTileByLayer.size() + -1;
            if (n2 > n3) continue;
            do {
                int tileIndex = n2++;
                DataFrame tileLayerInputData = inputDataByTileByLayer.get(tileIndex).get(layerIndex);
                List<VarBinding> varBindings = layerConfig.getVarBindings();
                GroupingContext groupingContext = new GroupingContext(tileLayerInputData, varBindings, layerConfig.getExplicitGroupingVarName(), null, true);
                GroupingContext groupingContextAfterStat = null;
                Stat stat = layerConfig.getStat();
                DataFrame tileLayerDataAfterStat = null;
                if (stat == Stats.INSTANCE.getIDENTITY()) {
                    tileLayerDataAfterStat = tileLayerInputData;
                    groupingContextAfterStat = groupingContext;
                } else {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Object object;
                    Collection collection;
                    Object object2;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv;
                    LayerConfig layerConfig2 = layerConfig;
                    boolean bl = false;
                    boolean bl2 = false;
                    LayerConfig $this$dataByTileByLayerAfterStat_u24lambda_u2d3 = layerConfig2;
                    boolean bl3 = false;
                    Iterable iterable = $this$dataByTileByLayerAfterStat_u24lambda_u2d3.getTooltips().getValueSources();
                    boolean $i$f$filterIsInstance = false;
                    void var28_28 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof DataFrameValue)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        object2 = (DataFrameValue)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        object = p0.getVariableName();
                        collection.add(object);
                    }
                    $this$map$iv = $this$dataByTileByLayerAfterStat_u24lambda_u2d3.getOrderOptions();
                    collection = (List)destination$iv$iv;
                    boolean $i$f$mapNotNull = false;
                    $this$mapTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    object2 = $this$forEach$iv$iv$iv.iterator();
                    while (object2.hasNext()) {
                        String string;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = object2.next();
                        boolean bl5 = false;
                        OrderOptionUtil.OrderOption p0 = (OrderOptionUtil.OrderOption)element$iv$iv;
                        boolean bl6 = false;
                        if (p0.getByVariable() == null) continue;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        String it$iv$iv = string;
                        boolean bl9 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    object = (List)destination$iv$iv;
                    List varsWithoutBinding = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
                    DataProcessing.DataAndGroupingContext tileLayerDataAndGroupingContextAfterStat2 = DataProcessing.INSTANCE.buildStatData(tileLayerInputData, stat, varBindings, this.getScaleMap(), groupingContext, facets, (StatContext)statCtx, varsWithoutBinding, layerConfig.getOrderOptions(), layerConfig.getAggregateOperation(), (Function1)new Function1<String, Unit>(layerIndexAndSamplingMessage, layerIndex, this, layerConfig){
                        final /* synthetic */ Function2<Integer, String, Unit> $layerIndexAndSamplingMessage;
                        final /* synthetic */ int $layerIndex;
                        final /* synthetic */ PlotConfigServerSide this$0;
                        final /* synthetic */ LayerConfig $layerConfig;
                        {
                            this.$layerIndexAndSamplingMessage = $layerIndexAndSamplingMessage;
                            this.$layerIndex = $layerIndex;
                            this.this$0 = $receiver;
                            this.$layerConfig = $layerConfig;
                            super(1);
                        }

                        public final void invoke(@NotNull String message) {
                            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                            this.$layerIndexAndSamplingMessage.invoke((Object)this.$layerIndex, (Object)PlotConfigServerSide.access$createStatMessage(this.this$0, message, this.$layerConfig));
                        }
                    });
                    tileLayerDataAfterStat = tileLayerDataAndGroupingContextAfterStat2.getData();
                    groupingContextAfterStat = tileLayerDataAndGroupingContextAfterStat2.getGroupingContext();
                }
                List<Sampling> list2 = layerConfig.getSamplings();
                Intrinsics.checkNotNull(list2);
                tileLayerDataAfterStat = PlotSampling.INSTANCE.apply(tileLayerDataAfterStat, list2, (Function1<? super Integer, Integer>)groupingContextAfterStat.getGroupMapper(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(layerIndexAndSamplingMessage, layerIndex, this, layerConfig){
                    final /* synthetic */ Function2<Integer, String, Unit> $layerIndexAndSamplingMessage;
                    final /* synthetic */ int $layerIndex;
                    final /* synthetic */ PlotConfigServerSide this$0;
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerIndexAndSamplingMessage = $layerIndexAndSamplingMessage;
                        this.$layerIndex = $layerIndex;
                        this.this$0 = $receiver;
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    public final void invoke(@NotNull String message) {
                        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                        this.$layerIndexAndSamplingMessage.invoke((Object)this.$layerIndex, (Object)PlotConfigServerSide.access$createSamplingMessage(this.this$0, message, this.$layerConfig));
                    }
                }));
                ((List)result.get(tileIndex)).add(tileLayerDataAfterStat);
            } while (n2 <= n3);
        }
        return result;
    }

    private final String getStatName(LayerConfig layerConfig) {
        String string = Reflection.getOrCreateKotlinClass(layerConfig.getStat().getClass()).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        String stat = string;
        stat = StringsKt.replace$default((String)stat, (String)"Stat", (String)" stat", (boolean)false, (int)4, null);
        CharSequence charSequence = stat;
        String string2 = "([a-z])([A-Z]+)";
        boolean bl = false;
        string2 = new Regex(string2);
        String string3 = "$1_$2";
        boolean bl2 = false;
        charSequence = string2.replace(charSequence, string3);
        boolean bl3 = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = ((String)charSequence2).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        stat = string4;
        return stat;
    }

    private final String createSamplingMessage(String samplingExpression, LayerConfig layerConfig) {
        String string = layerConfig.getGeomProto().getGeomKind().name();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        String geomKind = string3;
        String stat = this.getStatName(layerConfig);
        return samplingExpression + " was applied to [" + geomKind + '/' + stat + "] layer";
    }

    private final String createStatMessage(String statInfo, LayerConfig layerConfig) {
        String string = layerConfig.getGeomProto().getGeomKind().name();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        String geomKind = string3;
        String stat = this.getStatName(layerConfig);
        return statInfo + " in [" + geomKind + '/' + stat + "] layer";
    }

    public static final /* synthetic */ String access$createStatMessage(PlotConfigServerSide $this, String statInfo, LayerConfig layerConfig) {
        return $this.createStatMessage(statInfo, layerConfig);
    }

    public static final /* synthetic */ String access$createSamplingMessage(PlotConfigServerSide $this, String samplingExpression, LayerConfig layerConfig) {
        return $this.createSamplingMessage(samplingExpression, layerConfig);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006J(\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006H\u0002J(\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006H\u0002J\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u000fH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/server/config/PlotConfigServerSide$Companion;", "", "()V", "LOG", "Ljetbrains/datalore/base/logging/Logger;", "processTransform", "", "", "plotSpecRaw", "processTransformInBunch", "bunchSpecRaw", "processTransformIntern", "throwTestingException", "", "plotSpec", "", "variablesToKeep", "", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "layerConfig", "Ljetbrains/datalore/plot/config/LayerConfig;", "plot-config-portable"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Set<String> variablesToKeep(PlotFacets facets, LayerConfig layerConfig) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Collection<String> collection;
            String string;
            Iterable<String> iterable;
            List $this$mapTo$iv$iv;
            Object $this$map$iv;
            Aes aes;
            Stat stat = layerConfig.getStat();
            Map defStatMapping = Stats.INSTANCE.defaultMapping(stat);
            List<VarBinding> bindings = layerConfig.getVarBindings();
            HashSet varsToKeep = new HashSet(defStatMapping.values());
            for (VarBinding binding : bindings) {
                Aes aes2 = binding.getAes();
                if (stat.hasDefaultMapping(aes2)) {
                    varsToKeep.remove(stat.getDefaultMapping(aes2));
                }
                varsToKeep.add(binding.getVariable());
            }
            HashSet renderedAes = new HashSet(layerConfig.getGeomProto().renders());
            HashSet<DataFrame.Variable> renderedVars = new HashSet<DataFrame.Variable>();
            HashSet<DataFrame.Variable> notRenderedVars = new HashSet<DataFrame.Variable>();
            for (VarBinding binding : bindings) {
                aes = binding.getAes();
                if (renderedAes.contains(aes)) {
                    renderedVars.add(binding.getVariable());
                    continue;
                }
                notRenderedVars.add(binding.getVariable());
            }
            varsToKeep.removeAll((Collection)notRenderedVars);
            varsToKeep.addAll((Collection)renderedVars);
            Iterable iterable2 = varsToKeep;
            Set set = new HashSet();
            boolean $i$f$map232 = false;
            aes = $this$map$iv;
            Iterable<String> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void p0;
                DataFrame.Variable variable = (DataFrame.Variable)t;
                iterable = destination$iv$iv;
                boolean bl = false;
                string = p0.getName();
                iterable.add(string);
            }
            iterable = (List)destination$iv$iv;
            $this$map$iv = new String[]{"data_meta", "geodataframe", "geometry"};
            Set set2 = SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.plus((Set)set, (Iterable)iterable), (Object)Stats.INSTANCE.getGROUP().getName()), (Iterable)CollectionsKt.listOfNotNull((Object)OptionsSelectorKt.getString(layerConfig.getMergedOptions(), $this$map$iv)));
            Pair<List<?>, List<?>> $i$f$map232 = layerConfig.getMapJoin();
            if ($i$f$map232 == null) {
                collection = null;
            } else {
                $this$mapTo$iv$iv = (List)$i$f$map232.getFirst();
                if ($this$mapTo$iv$iv == null) {
                    collection = null;
                } else {
                    Iterator $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    destination$iv$iv = $this$mapTo$iv$iv;
                    set = set2;
                    boolean $i$f$map = false;
                    Iterator iterator = $this$map$iv2;
                    Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    Iterator bl = $this$mapTo$iv$iv2.iterator();
                    while (bl.hasNext()) {
                        void it;
                        Object item$iv$iv;
                        Object t = item$iv$iv = bl.next();
                        iterable = collection2;
                        boolean bl2 = false;
                        if (it == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        string = (String)it;
                        iterable.add(string);
                    }
                    iterable = (List)collection2;
                    set2 = set;
                    collection = iterable;
                }
            }
            $this$map$iv = collection;
            Iterable iterable3 = $this$map$iv == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)$this$map$iv;
            $this$map$iv = layerConfig.getTooltips().getValueSources();
            set = SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.plus((Set)set2, (Iterable)iterable3), (Iterable)facets.getVariables()), (Iterable)CollectionsKt.listOfNotNull((Object)layerConfig.getExplicitGroupingVarName()));
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object t : $this$filterIsInstanceTo$iv$iv) {
                if (!(t instanceof DataFrameValue)) continue;
                destination$iv$iv.add(t);
            }
            iterable = (List)destination$iv$iv;
            $this$filterIsInstance$iv = iterable;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void p0;
                DataFrameValue $i$f$mapTo2 = (DataFrameValue)t;
                iterable = destination$iv$iv;
                boolean bl = false;
                string = p0.getVariableName();
                iterable.add(string);
            }
            iterable = (List)destination$iv$iv;
            $this$map$iv = layerConfig.getOrderOptions();
            set = SetsKt.plus((Set)set, (Iterable)iterable);
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean bl = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                OrderOptionUtil.OrderOption p0 = (OrderOptionUtil.OrderOption)element$iv$iv;
                boolean bl3 = false;
                if (p0.getByVariable() == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                String it$iv$iv = string2;
                boolean bl6 = false;
                destination$iv$iv.add((String)it$iv$iv);
            }
            iterable = (List)destination$iv$iv;
            return SetsKt.plus((Set)set, iterable);
        }

        @NotNull
        public final Map<String, Object> processTransform(@NotNull Map<String, Object> plotSpecRaw) {
            Map<Object, Object> map2;
            Intrinsics.checkNotNullParameter(plotSpecRaw, (String)"plotSpecRaw");
            try {
                map2 = PlotConfig.Companion.isGGBunchSpec(plotSpecRaw) ? this.processTransformInBunch(plotSpecRaw) : this.processTransformIntern(plotSpecRaw);
            }
            catch (RuntimeException e) {
                FailureHandler.FailureInfo failureInfo = FailureHandler.INSTANCE.failureInfo(e);
                if (failureInfo.isInternalError()) {
                    LOG.error((Throwable)e, (Function0)new Function0<String>(failureInfo){
                        final /* synthetic */ FailureHandler.FailureInfo $failureInfo;
                        {
                            this.$failureInfo = $failureInfo;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return this.$failureInfo.getMessage();
                        }
                    });
                }
                map2 = (Map<Object, Object>)new HashMap<String, Object>(PlotConfig.Companion.failure(failureInfo.getMessage()));
            }
            return map2;
        }

        private final Map<String, Object> processTransformInBunch(Map<String, Object> bunchSpecRaw) {
            if (!bunchSpecRaw.containsKey("items")) {
                Map<String, Object> map2 = bunchSpecRaw;
                String string = "items";
                List list2 = CollectionsKt.emptyList();
                boolean bl = false;
                map2.put(string, list2);
                return bunchSpecRaw;
            }
            Object object = bunchSpecRaw.get("items");
            Intrinsics.checkNotNull((Object)object);
            Object itemsRaw = object;
            if (!(itemsRaw instanceof List)) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"GGBunch: list of features expected but was: ", (Object)Reflection.getOrCreateKotlinClass(itemsRaw.getClass()).getSimpleName()));
            }
            ArrayList items = new ArrayList();
            for (Object rawItem : (List)itemsRaw) {
                Object v;
                if (!(rawItem instanceof Map)) {
                    Object e = rawItem;
                    Intrinsics.checkNotNull(e);
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"GGBunch item: Map of attributes expected but was: ", (Object)Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName()));
                }
                HashMap item = new HashMap((Map)rawItem);
                if (!item.containsKey("feature_spec")) {
                    throw new IllegalArgumentException("GGBunch item: absent required attribute: feature_spec");
                }
                Intrinsics.checkNotNull(item.get("feature_spec"));
                Intrinsics.checkNotNullExpressionValue(v, (String)"item[Option.GGBunch.Item.FEATURE_SPEC]!!");
                Object featureSpecRaw = v;
                if (!(featureSpecRaw instanceof Map)) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"GGBunch item 'feature_spec' : Map of attributes expected but was: ", (Object)Reflection.getOrCreateKotlinClass(featureSpecRaw.getClass()).getSimpleName()));
                }
                HashMap featureSpec = new HashMap((Map)featureSpecRaw);
                Object kind = featureSpec.get("kind");
                if (!Intrinsics.areEqual((Object)"plot", kind)) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"GGBunch item feature kind not suppotred: ", kind));
                }
                Map<String, Object> plotSpec = this.processTransformIntern(featureSpec);
                Map map3 = item;
                String string = "feature_spec";
                boolean bl = false;
                map3.put(string, plotSpec);
                items.add(item);
            }
            Map<String, Object> map4 = bunchSpecRaw;
            String string = "items";
            boolean bl = false;
            map4.put(string, items);
            return bunchSpecRaw;
        }

        private final Map<String, Object> processTransformIntern(Map<String, Object> plotSpecRaw) {
            Map<String, Object> plotSpec = PlotConfigServerSideTransforms.INSTANCE.migrationTransform().apply(plotSpecRaw);
            plotSpec = PlotConfigServerSideTransforms.INSTANCE.bistroTransform().apply(plotSpec);
            plotSpec = PlotConfigServerSideTransforms.INSTANCE.entryTransform().apply(plotSpec);
            new PlotConfigServerSide(plotSpec).updatePlotSpec();
            return plotSpec;
        }

        private final void throwTestingException(Map<String, ? extends Object> plotSpec) {
            if (plotSpec.containsKey("ggtitle")) {
                Object object = plotSpec.get("ggtitle");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                Object v = ((Map)object).get("text");
                Intrinsics.checkNotNull(v);
                Object title = v;
                if (Intrinsics.areEqual((Object)"Throw testing exception", title)) {
                    throw new IllegalArgumentException("User configuration error");
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

