/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.Map;
import jetbrains.datalore.plot.base.pos.PositionAdjustments;
import jetbrains.datalore.plot.builder.assemble.PosProvider;
import jetbrains.datalore.plot.config.OptionsAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/config/PosProto;", "", "()V", "DODGE", "", "DODGE_WIDTH", "FILL", "IDENTITY", "JD_DODGE_WIDTH", "JD_JITTER_HEIGHT", "JD_JITTER_WIDTH", "JITTER", "JITTER_DODGE", "JITTER_HEIGHT", "JITTER_WIDTH", "NUDGE", "NUDGE_HEIGHT", "NUDGE_WIDTH", "STACK", "createPosProvider", "Ljetbrains/datalore/plot/builder/assemble/PosProvider;", "posName", "options", "", "plot-config-portable"})
public final class PosProto {
    @NotNull
    public static final PosProto INSTANCE = new PosProto();
    @NotNull
    private static final String IDENTITY = "identity";
    @NotNull
    public static final String STACK = "stack";
    @NotNull
    private static final String DODGE = "dodge";
    @NotNull
    private static final String FILL = "fill";
    @NotNull
    private static final String NUDGE = "nudge";
    @NotNull
    private static final String JITTER = "jitter";
    @NotNull
    private static final String JITTER_DODGE = "jitterdodge";
    @NotNull
    private static final String DODGE_WIDTH = "width";
    @NotNull
    private static final String JITTER_WIDTH = "width";
    @NotNull
    private static final String JITTER_HEIGHT = "height";
    @NotNull
    private static final String NUDGE_WIDTH = "x";
    @NotNull
    private static final String NUDGE_HEIGHT = "y";
    @NotNull
    private static final String JD_DODGE_WIDTH = "dodge_width";
    @NotNull
    private static final String JD_JITTER_WIDTH = "jitter_width";
    @NotNull
    private static final String JD_JITTER_HEIGHT = "jitter_height";

    private PosProto() {
    }

    @NotNull
    public final PosProvider createPosProvider(@NotNull String posName, @NotNull Map<String, ? extends Object> options) {
        PosProvider posProvider;
        Intrinsics.checkNotNullParameter((Object)posName, (String)"posName");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        OptionsAccessor opts = new OptionsAccessor(options, null, 2, null);
        switch (posName) {
            case "identity": {
                posProvider = PosProvider.Companion.wrap(PositionAdjustments.INSTANCE.identity());
                break;
            }
            case "stack": {
                posProvider = PosProvider.Companion.barStack();
                break;
            }
            case "dodge": {
                posProvider = PosProvider.Companion.dodge(opts.getDouble("width"));
                break;
            }
            case "fill": {
                posProvider = PosProvider.Companion.fill();
                break;
            }
            case "jitter": {
                posProvider = PosProvider.Companion.jitter(opts.getDouble("width"), opts.getDouble(JITTER_HEIGHT));
                break;
            }
            case "nudge": {
                posProvider = PosProvider.Companion.nudge(opts.getDouble(NUDGE_WIDTH), opts.getDouble(NUDGE_HEIGHT));
                break;
            }
            case "jitterdodge": {
                posProvider = PosProvider.Companion.jitterDodge(opts.getDouble(JD_DODGE_WIDTH), opts.getDouble(JD_JITTER_WIDTH), opts.getDouble(JD_JITTER_HEIGHT));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown position adjustments name: '" + posName + '\'');
            }
        }
        return posProvider;
    }
}

