/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.bolt.sampler;

import java.time.Duration;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.TransactionConfig;

public abstract class AbstractBoltTestElement
extends AbstractTestElement {
    private String cypher;
    private String params;
    private String database;
    private String accessMode;
    private boolean recordQueryResults;
    private int txTimeout;

    public int getTxTimeout() {
        return this.txTimeout;
    }

    public void setTxTimeout(int txTimeout) {
        this.txTimeout = txTimeout;
    }

    public String getAccessMode() {
        if (this.accessMode == null) {
            return AccessMode.WRITE.toString();
        }
        return this.accessMode;
    }

    public void setAccessMode(String accessMode) {
        if (EnumUtils.isValidEnum(AccessMode.class, (String)accessMode)) {
            this.accessMode = accessMode;
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getCypher() {
        return this.cypher;
    }

    public void setCypher(String cypher) {
        this.cypher = cypher;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public boolean isRecordQueryResults() {
        return this.recordQueryResults;
    }

    public void setRecordQueryResults(boolean recordQueryResults) {
        this.recordQueryResults = recordQueryResults;
    }

    public SessionConfig getSessionConfig() {
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.builder().withDefaultAccessMode(Enum.valueOf(AccessMode.class, this.getAccessMode()));
        if (StringUtils.isNotBlank((CharSequence)this.database)) {
            sessionConfigBuilder.withDatabase(this.database);
        }
        return sessionConfigBuilder.build();
    }

    public TransactionConfig getTransactionConfig() {
        TransactionConfig.Builder txConfigBuilder = TransactionConfig.builder();
        if (this.txTimeout > 0) {
            txConfigBuilder.withTimeout(Duration.ofSeconds(this.txTimeout));
        }
        return txConfigBuilder.build();
    }
}

