/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.canvas;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.vis.canvas.Canvas;
import jetbrains.datalore.vis.canvas.Context2d;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J8\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J \u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J0\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0016JP\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\b\u0010&\u001a\u00020\u0007H\u0016J\b\u0010'\u001a\u00020\u0007H\u0016J(\u0010(\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0016J \u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0018\u0010.\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020-H\u0016J\u0018\u00101\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\b\u00102\u001a\u00020\u0007H\u0016J\u0010\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0004H\u0016J\b\u00105\u001a\u00020\u0007H\u0016J\u0010\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0004H\u0016J\u0018\u00106\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u000209H\u0002J\u0010\u00108\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0010\u00108\u001a\u00020;2\u0006\u0010<\u001a\u00020;H\u0002J\u0012\u0010=\u001a\u00020\u00072\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0010\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u000209H\u0016J\u0010\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\u0004H\u0016J\u0010\u0010D\u001a\u00020\u00072\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020;H\u0016J\u0010\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020\u00072\u0006\u0010M\u001a\u00020\u0004H\u0016J\u0012\u0010N\u001a\u00020\u00072\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0010\u0010O\u001a\u00020\u00072\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020TH\u0016J8\u0010U\u001a\u00020\u00072\u0006\u0010V\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020\u00042\u0006\u0010Y\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0016J\b\u0010Z\u001a\u00020\u0007H\u0016J(\u0010[\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0016J \u0010\\\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J8\u0010]\u001a\u00020\u00072\u0006\u0010V\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020\u00042\u0006\u0010Y\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0016J\u0018\u0010^\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Ljetbrains/datalore/vis/canvas/ScaledContext2d;", "Ljetbrains/datalore/vis/canvas/Context2d;", "ctx", "myScale", "", "(Ljetbrains/datalore/vis/canvas/Context2d;D)V", "arc", "", "x", "y", "radius", "startAngle", "endAngle", "anticlockwise", "", "beginPath", "bezierCurveTo", "cp1x", "cp1y", "cp2x", "cp2y", "clearRect", "rect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "closePath", "descaled", "value", "drawImage", "snapshot", "Ljetbrains/datalore/vis/canvas/Canvas$Snapshot;", "dw", "dh", "sx", "sy", "sw", "sh", "dx", "dy", "fill", "fillEvenOdd", "fillRect", "w", "h", "fillText", "text", "", "lineTo", "measureText", "str", "moveTo", "restore", "rotate", "angle", "save", "scale", "xy", "scaled", "Ljetbrains/datalore/vis/canvas/Context2d$Font;", "font", "", "values", "setFillStyle", "color", "Ljetbrains/datalore/base/values/Color;", "setFont", "f", "setGlobalAlpha", "alpha", "setLineCap", "lineCap", "Ljetbrains/datalore/vis/canvas/Context2d$LineCap;", "setLineDash", "lineDash", "setLineJoin", "lineJoin", "Ljetbrains/datalore/vis/canvas/Context2d$LineJoin;", "setLineWidth", "lineWidth", "setStrokeStyle", "setTextAlign", "align", "Ljetbrains/datalore/vis/canvas/Context2d$TextAlign;", "setTextBaseline", "baseline", "Ljetbrains/datalore/vis/canvas/Context2d$TextBaseline;", "setTransform", "m11", "m12", "m21", "m22", "stroke", "strokeRect", "strokeText", "transform", "translate", "vis-canvas"})
public final class ScaledContext2d
implements Context2d {
    @NotNull
    private final Context2d ctx;
    private final double myScale;

    public ScaledContext2d(@NotNull Context2d ctx2, double myScale) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        this.ctx = ctx2;
        this.myScale = myScale;
    }

    private final double scaled(double value) {
        return this.myScale * value;
    }

    private final double descaled(double value) {
        return value / this.myScale;
    }

    private final double[] scaled(double[] values2) {
        if (this.myScale == 1.0) {
            return values2;
        }
        double[] res = new double[values2.length];
        int n = 0;
        int n2 = values2.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                res[i] = this.scaled(values2[i]);
            } while (n <= n2);
        }
        return res;
    }

    private final Context2d.Font scaled(Context2d.Font font) {
        return Context2d.Font.copy$default(font, null, null, this.scaled(font.getFontSize()), null, 11, null);
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.ctx.drawImage(snapshot, this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x2, double y2, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.ctx.drawImage(snapshot, this.scaled(x2), this.scaled(y2), this.scaled(dw), this.scaled(dh));
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.ctx.drawImage(snapshot, this.scaled(sx), this.scaled(sy), this.scaled(sw), this.scaled(sh), this.scaled(dx), this.scaled(dy), this.scaled(dw), this.scaled(dh));
    }

    @Override
    public void beginPath() {
        this.ctx.beginPath();
    }

    @Override
    public void closePath() {
        this.ctx.closePath();
    }

    @Override
    public void stroke() {
        this.ctx.stroke();
    }

    @Override
    public void fill() {
        this.ctx.fill();
    }

    @Override
    public void fillRect(double x2, double y2, double w, double h) {
        this.ctx.fillRect(this.scaled(x2), this.scaled(y2), this.scaled(w), this.scaled(h));
    }

    @Override
    public void moveTo(double x2, double y2) {
        this.ctx.moveTo(this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void lineTo(double x2, double y2) {
        this.ctx.lineTo(this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void arc(double x2, double y2, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        this.ctx.arc(this.scaled(x2), this.scaled(y2), this.scaled(radius), startAngle, endAngle, anticlockwise);
    }

    @Override
    public void save() {
        this.ctx.save();
    }

    @Override
    public void restore() {
        this.ctx.restore();
    }

    @Override
    public void setFillStyle(@Nullable Color color) {
        this.ctx.setFillStyle(color);
    }

    @Override
    public void setStrokeStyle(@Nullable Color color) {
        this.ctx.setStrokeStyle(color);
    }

    @Override
    public void setGlobalAlpha(double alpha) {
        this.ctx.setGlobalAlpha(alpha);
    }

    @Override
    public void setFont(@NotNull Context2d.Font f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.ctx.setFont(this.scaled(f));
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.ctx.setLineWidth(this.scaled(lineWidth));
    }

    @Override
    public void strokeRect(double x2, double y2, double w, double h) {
        this.ctx.strokeRect(this.scaled(x2), this.scaled(y2), this.scaled(w), this.scaled(h));
    }

    @Override
    public void strokeText(@NotNull String text, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.ctx.strokeText(text, this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void fillText(@NotNull String text, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.ctx.fillText(text, this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void scale(double x2, double y2) {
        this.ctx.scale(x2, y2);
    }

    @Override
    public void scale(double xy) {
        this.scale(xy, xy);
    }

    @Override
    public void rotate(double angle) {
        this.ctx.rotate(angle);
    }

    @Override
    public void translate(double x2, double y2) {
        this.ctx.translate(this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void transform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.ctx.transform(m11, m12, m21, m22, this.scaled(dx), this.scaled(dy));
    }

    @Override
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x2, double y2) {
        this.ctx.bezierCurveTo(this.scaled(cp1x), this.scaled(cp1y), this.scaled(cp2x), this.scaled(cp2y), this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void setLineJoin(@NotNull Context2d.LineJoin lineJoin) {
        Intrinsics.checkNotNullParameter((Object)((Object)lineJoin), (String)"lineJoin");
        this.ctx.setLineJoin(lineJoin);
    }

    @Override
    public void setLineCap(@NotNull Context2d.LineCap lineCap) {
        Intrinsics.checkNotNullParameter((Object)((Object)lineCap), (String)"lineCap");
        this.ctx.setLineCap(lineCap);
    }

    @Override
    public void setTextBaseline(@NotNull Context2d.TextBaseline baseline) {
        Intrinsics.checkNotNullParameter((Object)((Object)baseline), (String)"baseline");
        this.ctx.setTextBaseline(baseline);
    }

    @Override
    public void setTextAlign(@NotNull Context2d.TextAlign align) {
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        this.ctx.setTextAlign(align);
    }

    @Override
    public void setTransform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.ctx.setTransform(m11, m12, m21, m22, this.scaled(dx), this.scaled(dy));
    }

    @Override
    public void fillEvenOdd() {
        this.ctx.fillEvenOdd();
    }

    @Override
    public void setLineDash(@NotNull double[] lineDash) {
        Intrinsics.checkNotNullParameter((Object)lineDash, (String)"lineDash");
        this.ctx.setLineDash(this.scaled(lineDash));
    }

    @Override
    public double measureText(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.descaled(this.ctx.measureText(str));
    }

    @Override
    public void clearRect(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        this.ctx.clearRect(new DoubleRectangle(this.scaled(rect2.getLeft()), this.scaled(rect2.getTop()), this.scaled(rect2.getWidth()), this.scaled(rect2.getHeight())));
    }
}

