/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jetbrains.datalore.plot.base.livemap.LiveMapOptions;
import jetbrains.datalore.plot.base.livemap.LivemapConstants;
import jetbrains.datalore.plot.config.LiveMapOptionsParser;
import jetbrains.datalore.plot.config.OptionsAccessor;
import jetbrains.datalore.plot.config.OptionsSelectorKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ljetbrains/datalore/plot/config/LiveMapOptionsParser;", "", "()V", "Companion", "plot-config-portable"})
public final class LiveMapOptionsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u00020\u0004\"\u000e\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\bH\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/plot/config/LiveMapOptionsParser$Companion;", "", "()V", "formatValues", "", "ValueT", "", "values", "", "([Ljava/lang/Enum;)Ljava/lang/String;", "parseDisplayMode", "Ljetbrains/datalore/plot/base/livemap/LivemapConstants$DisplayMode;", "displayMode", "parseFromLayerOptions", "Ljetbrains/datalore/plot/base/livemap/LiveMapOptions;", "opts", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "parseFromPlotSpec", "plotSpec", "", "parseProjection", "Ljetbrains/datalore/plot/base/livemap/LivemapConstants$Projection;", "projection", "plot-config-portable"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LiveMapOptions parseFromPlotSpec(@NotNull Map<String, ? extends Object> plotSpec) {
            boolean bl;
            List<Map<?, ?>> layers;
            block9: {
                Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
                String[] stringArray = new String[]{"layers"};
                List<Map<?, ?>> list2 = OptionsSelectorKt.getMaps(plotSpec, stringArray);
                Intrinsics.checkNotNull(list2);
                layers = list2;
                Iterable $this$any$iv = layers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Map it = (Map)element$iv;
                        boolean bl2 = false;
                        if (!jetbrains.datalore.plot.config.LiveMapOptionsParser$Companion.parseFromPlotSpec$isLiveMap(it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                int n;
                Iterable $this$count$iv = layers;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        Map it = (Map)element$iv;
                        boolean bl3 = false;
                        if (!jetbrains.datalore.plot.config.LiveMapOptionsParser$Companion.parseFromPlotSpec$isLiveMap(it)) continue;
                        int n2 = ++count$iv;
                        boolean bl4 = false;
                        if (n2 >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                boolean bl5 = n == 1;
                boolean bl6 = false;
                boolean bl7 = false;
                if (!bl5) {
                    boolean bl8 = false;
                    String string = "Only one geom_livemap is allowed per plot";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                bl5 = jetbrains.datalore.plot.config.LiveMapOptionsParser$Companion.parseFromPlotSpec$isLiveMap((Map)CollectionsKt.first(layers));
                bl6 = false;
                bl7 = false;
                if (!bl5) {
                    boolean bl9 = false;
                    String string = "geom_livemap should be a first geom";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                return this.parseFromLayerOptions(new OptionsAccessor((Map)CollectionsKt.first(layers), null, 2, null));
            }
            return null;
        }

        @NotNull
        public final LiveMapOptions parseFromLayerOptions(@NotNull OptionsAccessor opts) {
            LivemapConstants.Projection projection;
            LivemapConstants.DisplayMode displayMode;
            String p0;
            Integer n;
            Object object;
            Double d;
            boolean bl;
            boolean bl2;
            boolean bl3;
            String string;
            LivemapConstants.DisplayMode displayMode2;
            Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
            Integer n2 = opts.getInteger("zoom");
            Object object2 = opts.get("location");
            Double d2 = opts.getDouble("stroke");
            boolean bl4 = opts.getBoolean("interactive", true);
            String string2 = opts.getString("display_mode");
            if (string2 == null) {
                displayMode2 = null;
            } else {
                string = string2;
                bl3 = false;
                bl2 = false;
                String string3 = string;
                bl = bl4;
                d = d2;
                object = object2;
                n = n2;
                boolean bl5 = false;
                displayMode = this.parseDisplayMode(p0);
                n2 = n;
                object2 = object;
                d2 = d;
                bl4 = bl;
                displayMode2 = displayMode;
            }
            LivemapConstants.DisplayMode displayMode3 = displayMode2;
            LivemapConstants.DisplayMode displayMode4 = displayMode3 == null ? LivemapConstants.DisplayMode.POINT : displayMode3;
            boolean bl6 = opts.getBoolean("scaled", false);
            boolean bl7 = opts.getBoolean("clustering", false);
            boolean bl8 = opts.getBoolean("labels", true);
            string2 = opts.getString("projection");
            if (string2 == null) {
                projection = null;
            } else {
                string = string2;
                bl3 = false;
                bl2 = false;
                p0 = string;
                boolean bl9 = bl8;
                boolean bl10 = bl7;
                boolean bl11 = bl6;
                displayMode = displayMode4;
                bl = bl4;
                d = d2;
                object = object2;
                n = n2;
                boolean bl12 = false;
                LivemapConstants.Projection projection2 = this.parseProjection(p0);
                n2 = n;
                object2 = object;
                d2 = d;
                bl4 = bl;
                displayMode4 = displayMode;
                bl6 = bl11;
                bl7 = bl10;
                bl8 = bl9;
                projection = projection2;
            }
            displayMode3 = projection;
            Map<String, Object> map2 = opts.getMap("dev_params");
            Map<String, Object> map3 = opts.getMap("tiles");
            Map<String, Object> map4 = opts.getMap("geocoding");
            boolean bl13 = opts.getBoolean("geodesic", true);
            Enum enum_ = displayMode3 == null ? LivemapConstants.Projection.EPSG3857 : displayMode3;
            boolean bl14 = bl8;
            boolean bl15 = bl7;
            boolean bl16 = bl6;
            LivemapConstants.DisplayMode displayMode5 = displayMode4;
            boolean bl17 = bl4;
            Double d3 = d2;
            Object object3 = object2;
            Integer n3 = n2;
            return new LiveMapOptions(n3, object3, d3, bl17, displayMode5, bl16, bl15, bl14, (LivemapConstants.Projection)enum_, bl13, map4, map3, map2);
        }

        private final <ValueT extends Enum<ValueT>> String formatValues(ValueT[] values2) {
            return ArraysKt.joinToString$default((Object[])values2, (CharSequence)"|", (CharSequence)"=[", (CharSequence)"]", (int)0, null, (Function1)formatValues.1.INSTANCE, (int)24, null);
        }

        private final LivemapConstants.DisplayMode parseDisplayMode(String displayMode) {
            try {
                String string = displayMode;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
                return LivemapConstants.DisplayMode.valueOf(string3);
            }
            catch (Exception ignored) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"geom", (Object)this.formatValues(LivemapConstants.DisplayMode.values())));
            }
        }

        private final LivemapConstants.Projection parseProjection(String projection) {
            try {
                String string = projection;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
                return LivemapConstants.Projection.valueOf(string3);
            }
            catch (Exception ignored) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"projection", (Object)this.formatValues(LivemapConstants.Projection.values())));
            }
        }

        private static final boolean parseFromPlotSpec$isLiveMap(Map<?, ?> $this$parseFromPlotSpec_u24isLiveMap) {
            Map<?, ?> map2 = $this$parseFromPlotSpec_u24isLiveMap;
            String string = "geom";
            boolean bl = false;
            return Intrinsics.areEqual(map2.get(string), (Object)"livemap");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

