/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom.util;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgRectElement;
import jetbrains.datalore.vis.svg.slim.SvgSlimElements;
import jetbrains.datalore.vis.svg.slim.SvgSlimGroup;
import jetbrains.datalore.vis.svg.slim.SvgSlimShape;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fJ\u001c\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fJ6\u0010\u0014\u001a\u00020\u00152\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f2\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/base/geom/util/RectanglesHelper;", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "myAesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "(Ljetbrains/datalore/plot/base/Aesthetics;Ljetbrains/datalore/plot/base/PositionAdjustment;Ljetbrains/datalore/plot/base/CoordinateSystem;Ljetbrains/datalore/plot/base/GeomContext;)V", "createRectangles", "", "Ljetbrains/datalore/vis/svg/SvgNode;", "rectangleByDataPoint", "Lkotlin/Function1;", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "createSlimRectangles", "Ljetbrains/datalore/vis/svg/slim/SvgSlimGroup;", "iterateRectangleGeometry", "", "iterator", "Lkotlin/Function2;", "plot-base-portable"})
public final class RectanglesHelper
extends GeomHelper {
    @NotNull
    private final Aesthetics myAesthetics;

    public RectanglesHelper(@NotNull Aesthetics myAesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)myAesthetics, (String)"myAesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        super(pos, coord, ctx2);
        this.myAesthetics = myAesthetics;
    }

    @NotNull
    public final List<SvgNode> createRectangles(@NotNull Function1<? super DataPointAesthetics, DoubleRectangle> rectangleByDataPoint2) {
        Intrinsics.checkNotNullParameter(rectangleByDataPoint2, (String)"rectangleByDataPoint");
        ArrayList<SvgRectElement> result = new ArrayList<SvgRectElement>();
        int n = 0;
        int n2 = this.myAesthetics.dataPointCount();
        if (n < n2) {
            do {
                int index;
                DataPointAesthetics p;
                DoubleRectangle doubleRectangle;
                if ((doubleRectangle = this.toClientRect$plot_base_portable(p = this.myAesthetics.dataPointAt(index = n++), rectangleByDataPoint2)) == null) continue;
                DoubleRectangle clientRect = doubleRectangle;
                SvgRectElement svgRect = new SvgRectElement(clientRect);
                GeomHelper.Companion.decorate$default(GeomHelper.Companion, svgRect, p, false, 4, null);
                result.add(svgRect);
            } while (n < n2);
        }
        return result;
    }

    public final void iterateRectangleGeometry(@NotNull Function1<? super DataPointAesthetics, DoubleRectangle> rectangleByDataPoint2, @NotNull Function2<? super DataPointAesthetics, ? super DoubleRectangle, Unit> iterator2) {
        Intrinsics.checkNotNullParameter(rectangleByDataPoint2, (String)"rectangleByDataPoint");
        Intrinsics.checkNotNullParameter(iterator2, (String)"iterator");
        int n = 0;
        int n2 = this.myAesthetics.dataPointCount();
        if (n < n2) {
            do {
                int index;
                DataPointAesthetics p;
                DoubleRectangle rect2;
                DoubleRectangle doubleRectangle;
                if ((doubleRectangle = (rect2 = this.toClientRect$plot_base_portable(p = this.myAesthetics.dataPointAt(index = n++), rectangleByDataPoint2))) == null) continue;
                DoubleRectangle doubleRectangle2 = doubleRectangle;
                boolean bl = false;
                boolean bl2 = false;
                DoubleRectangle it = doubleRectangle2;
                boolean bl3 = false;
                iterator2.invoke((Object)p, (Object)rect2);
            } while (n < n2);
        }
    }

    @NotNull
    public final SvgSlimGroup createSlimRectangles(@NotNull Function1<? super DataPointAesthetics, DoubleRectangle> rectangleByDataPoint2) {
        Intrinsics.checkNotNullParameter(rectangleByDataPoint2, (String)"rectangleByDataPoint");
        int pointCount = this.myAesthetics.dataPointCount();
        SvgSlimGroup group2 = SvgSlimElements.INSTANCE.g(pointCount);
        int n = 0;
        if (n < pointCount) {
            do {
                int index;
                DataPointAesthetics p;
                DoubleRectangle doubleRectangle;
                if ((doubleRectangle = this.toClientRect$plot_base_portable(p = this.myAesthetics.dataPointAt(index = n++), rectangleByDataPoint2)) == null) continue;
                DoubleRectangle clientRect = doubleRectangle;
                SvgSlimShape slimShape = SvgSlimElements.INSTANCE.rect(clientRect.getLeft(), clientRect.getTop(), clientRect.getWidth(), clientRect.getHeight());
                GeomHelper.Companion.decorateSlimShape$plot_base_portable(slimShape, p);
                slimShape.appendTo(group2);
            } while (n < pointCount);
        }
        return group2;
    }
}

