/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.components.ScrollPopupMenu;
import com.github.weisj.darklaf.listener.PopupMenuAdapter;
import com.github.weisj.darklaf.ui.tabbedpane.DarkScrollableTabPanel;
import com.github.weisj.darklaf.ui.tabbedpane.DarkScrollableTabViewport;
import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.tabbedpane.ScrollableTabSupport;
import com.github.weisj.darklaf.ui.tabbedpane.TabButtonContainer;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;

public class DarkScrollableTabSupport
extends ScrollableTabSupport
implements MouseWheelListener,
ActionListener {
    protected static final int SCROLL_REWIND_DELAY = 1200;
    protected final ScrollPopupMenu scrollPopupMenu;
    protected final TabButtonContainer moreTabsButton;
    protected final TabButtonContainer newTabButton;
    protected final Timer timer;
    protected long lastClickEvent;
    private final DarkTabbedPaneUI ui;

    public DarkScrollableTabSupport(DarkTabbedPaneUI ui, int tabPlacement) {
        super(ui);
        this.ui = ui;
        this.viewport = new DarkScrollableTabViewport(ui);
        this.tabPanel = new DarkScrollableTabPanel(ui);
        this.viewport.setView(this.tabPanel);
        this.viewport.addMouseWheelListener(this);
        this.moreTabsButton = ui.createMoreTabsButton();
        this.moreTabsButton.button.addActionListener(this);
        this.moreTabsButton.setVisible(false);
        this.newTabButton = ui.createNewTabButton();
        this.newTabButton.setVisible(PropertyUtil.getBooleanProperty((JComponent)ui.tabPane, (String)"JTabbedPane.showNewTabButton"));
        this.scrollPopupMenu = new ScrollPopupMenu(UIManager.getInt("TabbedPane.maxPopupHeight"));
        PopupMenuAdapter popupMenuListener = new PopupMenuAdapter(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                DarkScrollableTabSupport.this.lastClickEvent = System.currentTimeMillis();
            }
        };
        this.scrollPopupMenu.addPopupMenuListener(popupMenuListener);
        ui.tabPane.add(this.moreTabsButton);
        this.timer = new Timer(1200, e -> this.endScroll());
        this.timer.setRepeats(false);
    }

    protected void endScroll() {
        this.ui.currentShiftX += this.ui.scrollShiftX;
        this.ui.currentShiftY += this.ui.scrollShiftY;
        this.ui.scrollShiftX = 0;
        this.ui.scrollShiftY = 0;
        this.ui.scrollLayout.calculateTabRects(this.ui.tabPane.getTabPlacement(), this.ui.tabPane.getTabCount());
        this.ui.scrollLayout.layoutTabComponents();
        this.updateRollover();
        this.viewport.repaint();
    }

    protected void updateRollover() {
        Point pos = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(pos, this.ui.tabPane);
        this.ui.setRolloverTab(pos.x, pos.y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.scrollPopupMenu.isVisible()) {
            this.scrollPopupMenu.setVisible(false);
        } else {
            if (!this.ui.tabPane.isEnabled()) {
                return;
            }
            if (this.lastClickEvent == 0L || System.currentTimeMillis() - this.lastClickEvent > 250L) {
                Dimension pref = this.scrollPopupMenu.getPreferredSize();
                boolean leftToRight = this.ui.tabPane.getComponentOrientation().isLeftToRight();
                switch (this.ui.tabPane.getTabPlacement()) {
                    case 2: {
                        this.scrollPopupMenu.show(this.moreTabsButton, this.moreTabsButton.getWidth(), this.moreTabsButton.getHeight() - pref.height);
                        break;
                    }
                    case 4: {
                        this.scrollPopupMenu.show(this.moreTabsButton, -pref.width, this.moreTabsButton.getHeight() - pref.height);
                        break;
                    }
                    case 1: {
                        if (leftToRight) {
                            this.scrollPopupMenu.show(this.moreTabsButton, this.moreTabsButton.getWidth() - pref.width, this.moreTabsButton.getHeight());
                            break;
                        }
                        this.scrollPopupMenu.show(this.moreTabsButton, 0, this.moreTabsButton.getHeight());
                        break;
                    }
                    case 3: {
                        if (leftToRight) {
                            this.scrollPopupMenu.show(this.moreTabsButton, this.moreTabsButton.getWidth() - pref.width, -pref.height);
                            break;
                        }
                        this.scrollPopupMenu.show(this.moreTabsButton, 0, -pref.height);
                    }
                }
            }
        }
    }

    public void hideMoreTabsButton() {
        this.moreTabsButton.setVisible(false);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int scrolled;
        if (!this.ui.tabPane.isEnabled() || this.ui.tabPane.getTabCount() == 0) {
            return;
        }
        int scrollAmount = -1 * e.getUnitsToScroll() * e.getScrollAmount();
        int scrollX = 0;
        int scrollY = 0;
        if (!this.ui.isHorizontalTabPlacement()) {
            if (!this.moreTabsButton.isVisible()) {
                return;
            }
            this.timer.stop();
            scrollY = scrolled = this.scroll(scrollAmount, false);
        } else {
            if (!this.moreTabsButton.isVisible()) {
                return;
            }
            this.timer.stop();
            scrollX = scrolled = this.scroll(scrollAmount, true);
        }
        if (scrolled != 0) {
            for (int i = 0; i < this.ui.tabPane.getTabCount(); ++i) {
                Component c = this.ui.tabPane.getTabComponentAt(i);
                if (c == null) continue;
                c.setLocation(c.getX() + scrollX, c.getY() + scrollY);
            }
            this.showMoreTabsButton();
            this.updateRollover();
            this.viewport.repaint();
        }
        this.timer.start();
    }

    protected int scroll(int amount, boolean horizontal) {
        int shift;
        Dimension size = this.ui.tabPane.getSize();
        Insets insets = this.ui.tabPane.getInsets();
        Insets tabAreaInsets = this.ui.getTabAreaInsets(this.ui.tabPane.getTabPlacement());
        int tabCount = this.ui.tabPane.getTabCount();
        if (horizontal) {
            int rightMargin = size.width - (insets.left + insets.right + tabAreaInsets.right + tabAreaInsets.left);
            if (this.moreTabsButton.isVisible()) {
                rightMargin -= this.moreTabsButton.getWidth();
            }
            int low = this.ui.rects[0].x;
            int high = this.ui.rects[tabCount - 1].x + this.ui.rects[tabCount - 1].width;
            shift = this.getShift(amount, rightMargin, low, high);
            this.ui.scrollLayout.commitShiftX(shift, tabCount);
            this.ui.scrollShiftX += shift;
        } else {
            int bottomMargin = size.height - (insets.bottom + tabAreaInsets.bottom + insets.top + tabAreaInsets.top);
            if (this.moreTabsButton.isVisible()) {
                bottomMargin -= this.moreTabsButton.getHeight();
            }
            int low = this.ui.rects[0].y;
            int high = this.ui.rects[tabCount - 1].y + this.ui.rects[tabCount - 1].height;
            shift = this.getShift(amount, bottomMargin, low, high);
            this.ui.scrollLayout.commitShiftY(shift, tabCount);
            this.ui.scrollShiftY += shift;
        }
        return shift;
    }

    private int getShift(int amount, int margin, int low, int high) {
        int shift = Math.abs(amount);
        if (amount > 0) {
            shift = Math.min(Math.max(-1 * low, 0), shift);
        } else {
            shift = Math.min(Math.max(high - margin, 0), shift);
            shift *= -1;
        }
        return shift;
    }

    public void showMoreTabsButton() {
        int i;
        this.moreTabsButton.setVisible(true);
        this.scrollPopupMenu.removeAll();
        if (this.ui.maxVisible < 0 || this.ui.minVisible >= this.ui.tabPane.getTabCount()) {
            this.ui.scrollLayout.updateVisibleRange(this.ui.tabPane.getTabPlacement());
        }
        if (this.ui.minVisible != this.ui.tabPane.getTabCount() && this.ui.maxVisible >= 0) {
            for (i = 0; i < this.ui.minVisible; ++i) {
                this.scrollPopupMenu.add(this.createMenuItem(i));
            }
        }
        for (i = this.ui.maxVisible + 1; i < this.ui.tabPane.getTabCount(); ++i) {
            this.scrollPopupMenu.add(this.createMenuItem(i));
        }
        this.moreTabsButton.repaint();
    }

    protected JMenuItem createMenuItem(final int i) {
        Icon icon = this.ui.tabPane.getIconAt(i);
        if (icon != null && !this.ui.tabPane.getComponentAt(i).isEnabled()) {
            icon = this.ui.tabPane.getDisabledIconAt(i);
        }
        final Component comp = this.ui.tabPane.getComponentAt(i);
        return new JMenuItem(new AbstractAction(this.ui.tabPane.getTitleAt(i), icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (i >= 0 && i <= ((DarkScrollableTabSupport)DarkScrollableTabSupport.this).ui.tabPane.getTabCount()) {
                    ((DarkScrollableTabSupport)DarkScrollableTabSupport.this).ui.tabPane.setSelectedComponent(comp);
                    ((DarkScrollableTabSupport)DarkScrollableTabSupport.this).ui.tabPane.doLayout();
                    comp.requestFocusInWindow();
                }
            }
        });
    }
}

