/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.settings;

import com.github.weisj.darklaf.platform.ThemePreferencesHandler;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.theme.info.FontSizeRule;

public class SettingsConfiguration {
    private boolean isSystemPreferencesEnabled;
    private boolean isAccentColorFollowsSystem;
    private boolean isFontSizeFollowsSystem;
    private boolean isThemeFollowsSystem;
    private boolean isSelectionColorFollowsSystem;
    private AccentColorRule accentColorRule;
    private FontSizeRule fontSizeRule;
    private Theme theme;

    public void load(SettingsConfiguration config) {
        this.setSystemPreferencesEnabled(config.isSystemPreferencesEnabled());
        this.setAccentColorFollowsSystem(config.isAccentColorFollowsSystem());
        this.setSelectionColorFollowsSystem(config.isSelectionColorFollowsSystem());
        this.setFontSizeFollowsSystem(config.isFontSizeFollowsSystem());
        this.setThemeFollowsSystem(config.isThemeFollowsSystem());
        this.setFontSizeRule(config.getFontSizeRule());
        this.setAccentColorRule(config.getAccentColorRule());
        this.setTheme(config.getTheme());
    }

    public boolean isSystemPreferencesEnabled() {
        return this.isSystemPreferencesEnabled;
    }

    public boolean isAccentColorFollowsSystem() {
        return this.isAccentColorFollowsSystem;
    }

    public boolean isFontSizeFollowsSystem() {
        return this.isFontSizeFollowsSystem;
    }

    public boolean isSelectionColorFollowsSystem() {
        return this.isSelectionColorFollowsSystem;
    }

    public boolean isThemeFollowsSystem() {
        return this.isThemeFollowsSystem;
    }

    public AccentColorRule getAccentColorRule() {
        return this.accentColorRule;
    }

    public FontSizeRule getFontSizeRule() {
        return this.fontSizeRule;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setSystemPreferencesEnabled(boolean enabled) {
        this.isSystemPreferencesEnabled = enabled;
    }

    public void setAccentColorFollowsSystem(boolean accentColorFollowsSystem) {
        this.isAccentColorFollowsSystem = accentColorFollowsSystem;
    }

    public void setFontSizeFollowsSystem(boolean fontSizeFollowsSystem) {
        this.isFontSizeFollowsSystem = fontSizeFollowsSystem;
    }

    public void setSelectionColorFollowsSystem(boolean selectionColorFollowsSystem) {
        this.isSelectionColorFollowsSystem = selectionColorFollowsSystem;
    }

    public void setThemeFollowsSystem(boolean themeFollowsSystem) {
        this.isThemeFollowsSystem = themeFollowsSystem;
    }

    public void setAccentColorRule(AccentColorRule accentColorRule) {
        this.accentColorRule = accentColorRule;
    }

    public void setFontSizeRule(FontSizeRule fontSizeRule) {
        this.fontSizeRule = fontSizeRule;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public boolean isSystemPreferencesSupported() {
        return ThemePreferencesHandler.getSharedInstance().canReport();
    }

    public boolean isSystemAccentColorSupported() {
        return this.isSystemPreferencesEnabled() && ThemePreferencesHandler.getSharedInstance().supportsNativeAccentColor();
    }

    public boolean isSystemFontSizeSupported() {
        return this.isSystemPreferencesEnabled() && ThemePreferencesHandler.getSharedInstance().supportsNativeFontSize();
    }

    public boolean isSystemSelectionColorSupported() {
        return this.isSystemPreferencesEnabled() && ThemePreferencesHandler.getSharedInstance().supportsNativeSelectionColor();
    }

    public boolean isSystemThemeSupported() {
        return this.isSystemPreferencesEnabled() && ThemePreferencesHandler.getSharedInstance().supportsNativeTheme();
    }

    public String toString() {
        return "SettingsConfiguration{isSystemPreferencesEnabled=" + this.isSystemPreferencesEnabled + ", isAccentColorFollowsSystem=" + this.isAccentColorFollowsSystem + ", isFontSizeFollowsSystem=" + this.isFontSizeFollowsSystem + ", isThemeFollowsSystem=" + this.isThemeFollowsSystem + ", isSelectionColorFollowsSystem=" + this.isSelectionColorFollowsSystem + ", accentColorRule=" + this.accentColorRule + ", fontSizeRule=" + this.fontSizeRule + ", theme=" + this.theme + '}';
    }
}

