/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.graphics.GraphicsUtil;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.task.ForegroundColorGenerationTask;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public abstract class SwatchPanel
extends JPanel {
    protected Color[] colors;
    protected Dimension swatchSize;
    protected Dimension numSwatches;
    protected Dimension gap;
    private final ToolTipContext toolTipContext = new ToolTipContext(this).setAlignment(Alignment.CENTER).setToolTipRectSupplier(this::getSwatchBounds).setHideOnExit(true);
    private int selRow;
    private int selCol;

    public SwatchPanel() {
        this.initValues();
        this.initColors();
        this.setToolTipText("");
        this.setOpaque(true);
        this.setBackground(UIManager.getColor("ColorChooser.swatchGridColor"));
        this.setFocusable(true);
        this.setInheritsPopupMenu(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwatchPanel.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                SwatchPanel.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (SwatchPanel.this.selRow < 0 || SwatchPanel.this.selCol < 0) {
                    return;
                }
                int typed = e.getKeyCode();
                switch (typed) {
                    case 38: {
                        if (SwatchPanel.this.selRow <= 0) break;
                        SwatchPanel.this.setSelection(SwatchPanel.this.selRow - 1, SwatchPanel.this.selCol);
                        break;
                    }
                    case 40: {
                        if (SwatchPanel.this.getIndex(SwatchPanel.this.selRow + 1, SwatchPanel.this.selCol) >= SwatchPanel.this.colors.length) break;
                        SwatchPanel.this.setSelection(SwatchPanel.this.selRow + 1, SwatchPanel.this.selCol);
                        break;
                    }
                    case 37: {
                        if (SwatchPanel.this.selCol > 0 && SwatchPanel.this.getComponentOrientation().isLeftToRight()) {
                            SwatchPanel.this.setSelection(SwatchPanel.this.selRow, SwatchPanel.this.selCol - 1);
                            SwatchPanel.this.repaint();
                            break;
                        }
                        if (SwatchPanel.this.selCol >= SwatchPanel.this.numSwatches.width - 1 || SwatchPanel.this.getSelectionIndex() >= SwatchPanel.this.colors.length - 1 || SwatchPanel.this.getComponentOrientation().isLeftToRight()) break;
                        SwatchPanel.this.setSelection(SwatchPanel.this.selRow, SwatchPanel.this.selCol + 1);
                        SwatchPanel.this.repaint();
                        break;
                    }
                    case 39: {
                        if (SwatchPanel.this.selCol < SwatchPanel.this.numSwatches.width - 1 && SwatchPanel.this.getSelectionIndex() < SwatchPanel.this.colors.length - 1 && SwatchPanel.this.getComponentOrientation().isLeftToRight()) {
                            SwatchPanel.this.setSelection(SwatchPanel.this.selRow, SwatchPanel.this.selCol + 1);
                            SwatchPanel.this.repaint();
                            break;
                        }
                        if (SwatchPanel.this.selCol <= 0 || SwatchPanel.this.getComponentOrientation().isLeftToRight()) break;
                        SwatchPanel.this.setSelection(SwatchPanel.this.selRow, SwatchPanel.this.selCol - 1);
                        SwatchPanel.this.repaint();
                        break;
                    }
                    case 36: {
                        SwatchPanel.this.setSelection(0, 0);
                        break;
                    }
                    case 35: {
                        SwatchPanel.this.setSelection(SwatchPanel.this.colors.length - 1);
                    }
                }
            }
        });
    }

    protected int getSelectionIndex() {
        return this.getIndex(this.selRow, this.selCol);
    }

    protected int getIndex(int row, int col) {
        return row * this.numSwatches.width + col;
    }

    protected void setSelection(int index) {
        int col = index % this.numSwatches.width;
        int row = (index - col) / this.numSwatches.width;
        this.setSelection(row, col);
    }

    protected void setSelection(int row, int col) {
        this.selCol = col;
        this.selRow = row;
        this.repaint();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.toolTipContext != null) {
            this.toolTipContext.updateToolTipUI();
        }
    }

    protected void initValues() {
    }

    protected void initColors() {
    }

    public Color getSelectedColor() {
        return this.getColorForCell(this.selCol, this.selRow);
    }

    private Color getColorForCell(int column, int row) {
        int index = this.getIndex(row, column);
        if (index >= this.colors.length || index < 0) {
            return null;
        }
        return this.colors[index];
    }

    @Override
    public void paintComponent(Graphics g) {
        Insets ins = this.getInsets();
        g.setColor(this.getBackground());
        g.fillRect(ins.left, ins.top, this.getWidth() - ins.left - ins.right, this.getHeight() - ins.top - ins.bottom);
        g.translate(ins.left, ins.top);
        for (int row = 0; row < this.numSwatches.height; ++row) {
            int y = this.getYForRow(row);
            for (int column = 0; column < this.numSwatches.width; ++column) {
                Color c = this.getColorForCell(column, row);
                if (c == null) continue;
                g.setColor(c);
                int x = this.getXForColumn(column);
                g.fillRect(x, y, this.swatchSize.width, this.swatchSize.height);
                if (this.selRow != row || this.selCol != column || !this.isFocusOwner()) continue;
                ColorUIResource c2 = ForegroundColorGenerationTask.makeForeground(c);
                g.setColor(c2);
                PaintUtil.drawRect(g, x, y, this.swatchSize.width, this.swatchSize.height, 1);
                GraphicsUtil.setupStrokePainting(g);
                g.drawLine(x + 1, y + 1, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                g.drawLine(x + 1, y + this.swatchSize.height - 1, x + this.swatchSize.width - 1, y + 1);
            }
        }
        g.translate(-ins.left, -ins.top);
    }

    private int getYForRow(int row) {
        return row * (this.swatchSize.height + this.gap.height);
    }

    private int getXForColumn(int column) {
        if (!this.getComponentOrientation().isLeftToRight()) {
            return (this.numSwatches.width - column - 1) * (this.swatchSize.width + this.gap.width);
        }
        return column * (this.swatchSize.width + this.gap.width);
    }

    @Override
    public Dimension getPreferredSize() {
        int x = this.numSwatches.width * (this.swatchSize.width + this.gap.width);
        int y = this.numSwatches.height * (this.swatchSize.height + this.gap.height);
        Insets ins = this.getInsets();
        return new Dimension(x + ins.left + ins.right, y + ins.top + ins.bottom);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Color color = this.getColorForLocation(e.getX(), e.getY());
        if (color == null) {
            return null;
        }
        return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return this.toolTipContext.getToolTipLocation(e);
    }

    @Override
    public JToolTip createToolTip() {
        return this.toolTipContext.getToolTip();
    }

    public Color getColorForLocation(int x, int y) {
        Point p = this.getCoordinatesForLocation(x, y);
        return this.getColorForCell(p.x, p.y);
    }

    public Point getCoordinatesForLocation(int x, int y) {
        int column = !this.getComponentOrientation().isLeftToRight() ? this.numSwatches.width - x / (this.swatchSize.width + this.gap.width) - 1 : x / (this.swatchSize.width + this.gap.width);
        int row = y / (this.swatchSize.height + this.gap.height);
        return new Point(column, row);
    }

    protected Rectangle getSwatchBounds(MouseEvent e) {
        Point p = this.getCoordinatesForLocation(e.getX(), e.getY());
        int x = this.getXForColumn(p.x);
        int y = this.getYForRow(p.y);
        return new Rectangle(x, y, this.swatchSize.width, this.swatchSize.height);
    }

    public void setSelectedColorFromLocation(int x, int y) {
        Point p = this.getCoordinatesForLocation(x, y);
        this.setSelection(p.y, p.x);
    }
}

