/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.TestFragmentController;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.UndoHistory;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.menu.StaticJMeterGUIComponent;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.MenuInfo;
import org.apache.jmeter.gui.util.MenuSeparatorInfo;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.NonTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Printable;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.reflect.ClassFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MenuFactory {
    private static final Logger log = LoggerFactory.getLogger(MenuFactory.class);
    public static final String THREADS = "menu_threads";
    public static final String FRAGMENTS = "menu_fragments";
    public static final String TIMERS = "menu_timer";
    public static final String CONTROLLERS = "menu_logic_controller";
    public static final String SAMPLERS = "menu_generative_controller";
    public static final String CONFIG_ELEMENTS = "menu_config_element";
    public static final String POST_PROCESSORS = "menu_post_processors";
    public static final String PRE_PROCESSORS = "menu_pre_processors";
    public static final String ASSERTIONS = "menu_assertions";
    public static final String NON_TEST_ELEMENTS = "menu_non_test_elements";
    public static final String LISTENERS = "menu_listener";
    public static final String SEPARATOR = "menu_separator";
    private static final Map<String, List<MenuInfo>> menuMap = new HashMap<String, List<MenuInfo>>();

    private static Set<String> classesToSkip() {
        return Arrays.stream(JMeterUtils.getPropDefault("not_in_menu", "").split(",")).map(String::trim).collect(Collectors.toSet());
    }

    private static void initializeMenus(Map<String, List<MenuInfo>> menus, Set<String> elementsToSkip) {
        try {
            List guiClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{JMeterGUIComponent.class, TestBean.class}).stream().filter(name -> !name.endsWith("JMeterTreeNode")).filter(name -> !name.endsWith("TestBeanGUI")).filter(name -> !name.equals("org.apache.jmeter.gui.menu.StaticJMeterGUIComponent")).filter(name -> !elementsToSkip.contains(name)).distinct().map(String::trim).collect(Collectors.toList());
            boolean debugTimings = log.isDebugEnabled();
            HashMap<String, Long> times = debugTimings ? new HashMap<String, Long>() : null;
            HashMap<String, JMeterGUIComponent> comps = debugTimings ? new HashMap<String, JMeterGUIComponent>() : null;
            long a0 = System.currentTimeMillis();
            for (String className : guiClasses) {
                long t0 = 0L;
                if (debugTimings) {
                    t0 = System.currentTimeMillis();
                }
                JMeterGUIComponent item = MenuFactory.getGUIComponent(className, elementsToSkip);
                if (debugTimings) {
                    long t1 = System.currentTimeMillis();
                    times.put(className, t1 - t0);
                    comps.put(className, item);
                }
                if (item == null) continue;
                Collection<String> categories = item.getMenuCategories();
                if (categories == null) {
                    log.debug("{} participates in no menus.", (Object)className);
                    continue;
                }
                for (Map.Entry<String, List<MenuInfo>> entry : menus.entrySet()) {
                    if (!categories.contains(entry.getKey())) continue;
                    entry.getValue().add(new MenuInfo(item, className));
                }
            }
            if (debugTimings) {
                long a1 = System.currentTimeMillis();
                times.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getValue)).forEachOrdered(e -> {
                    String res = "";
                    JMeterGUIComponent comp = (JMeterGUIComponent)comps.get(e.getKey());
                    if (comp != null && comp.getLabelResource() != null) {
                        res = " @TestElementMetadata(labelResource = \"" + comp.getLabelResource() + "\")";
                    }
                    log.debug("{}ms {} {}", new Object[]{e.getValue(), e.getKey(), res});
                });
                log.debug("{}ms total menu initialization time", (Object)(a1 - a0));
            }
        }
        catch (IOException e2) {
            log.error("IO Exception while initializing menus.", (Throwable)e2);
        }
    }

    private static JMeterGUIComponent getGUIComponent(String name, Set<String> elementsToSkip) {
        JMeterGUIComponent item = null;
        boolean hideBean = false;
        try {
            Class<?> c = Class.forName(name, false, MenuFactory.class.getClassLoader());
            TestElementMetadata metadata = c.getAnnotation(TestElementMetadata.class);
            if (metadata != null) {
                item = new StaticJMeterGUIComponent(c, metadata);
            } else if (TestBean.class.isAssignableFrom(c)) {
                TestBeanGUI testBeanGUI = new TestBeanGUI(c);
                hideBean = testBeanGUI.isHidden() || testBeanGUI.isExpert() && !JMeterUtils.isExpertMode();
                item = testBeanGUI;
            } else {
                item = (JMeterGUIComponent)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (NoClassDefFoundError e) {
            log.warn("Configuration error, probably corrupt or missing third party library(jar)? Could not create class: {}.", (Object)name, (Object)e);
        }
        catch (HeadlessException e) {
            log.warn("Could not instantiate class: {}", (Object)name, (Object)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn("Could not instantiate class: {}", (Object)name, (Object)e);
        }
        if (hideBean || item != null && elementsToSkip.contains(item.getStaticLabel())) {
            log.info("Skipping {}", (Object)name);
            item = null;
        }
        return item;
    }

    private static void sortMenus(Collection<List<MenuInfo>> menus) {
        for (List<MenuInfo> menu : menus) {
            menu.sort(Comparator.comparing(MenuInfo::getLabel));
            menu.sort(Comparator.comparingInt(MenuInfo::getSortOrder));
        }
    }

    private static void separateItemsWithExplicitOrder(Collection<List<MenuInfo>> menus) {
        for (List<MenuInfo> menu : menus) {
            Optional<MenuInfo> firstDefaultSortItem;
            int index = menu.indexOf((firstDefaultSortItem = menu.stream().filter(info -> info.getSortOrder() == 100).findFirst()).orElseThrow(IllegalStateException::new));
            if (index <= 0) continue;
            menu.add(index, new MenuSeparatorInfo());
        }
    }

    private MenuFactory() {
    }

    public static void addEditMenu(JPopupMenu menu, boolean removable) {
        MenuFactory.addSeparator(menu);
        if (removable) {
            menu.add(MenuFactory.makeMenuItemRes("cut", "Cut", KeyStrokes.CUT));
        }
        menu.add(MenuFactory.makeMenuItemRes("copy", "Copy", KeyStrokes.COPY));
        menu.add(MenuFactory.makeMenuItemRes("paste", "Paste", KeyStrokes.PASTE));
        menu.add(MenuFactory.makeMenuItemRes("duplicate", "duplicate", KeyStrokes.DUPLICATE));
        if (removable) {
            menu.add(MenuFactory.makeMenuItemRes("remove", "remove", KeyStrokes.REMOVE));
        }
    }

    public static void addPasteResetMenu(JPopupMenu menu) {
        MenuFactory.addSeparator(menu);
        menu.add(MenuFactory.makeMenuItemRes("paste", "Paste", KeyStrokes.PASTE));
    }

    public static void addFileMenu(JPopupMenu pop) {
        MenuFactory.addFileMenu(pop, true);
    }

    public static void addFileMenu(JPopupMenu menu, boolean addSaveTestFragmentMenu) {
        if (UndoHistory.isEnabled()) {
            MenuFactory.addUndoItems(menu);
        }
        MenuFactory.addSeparator(menu);
        menu.add(MenuFactory.makeMenuItemRes("open", "open"));
        menu.add(MenuFactory.makeMenuItemRes("menu_merge", "merge"));
        menu.add(MenuFactory.makeMenuItemRes("save_as", "save_as"));
        if (addSaveTestFragmentMenu) {
            menu.add(MenuFactory.makeMenuItemRes("save_as_test_fragment", "save_as_test_fragment"));
        }
        MenuFactory.addSeparator(menu);
        JMenuItem savePicture = MenuFactory.makeMenuItemRes("save_as_image", "save_graphics", KeyStrokes.SAVE_GRAPHICS);
        menu.add(savePicture);
        if (!(GuiPackage.getInstance().getCurrentGui() instanceof Printable)) {
            savePicture.setEnabled(false);
        }
        JMenuItem savePictureAll = MenuFactory.makeMenuItemRes("save_as_image_all", "save_graphics_all", KeyStrokes.SAVE_GRAPHICS_ALL);
        menu.add(savePictureAll);
        MenuFactory.addSeparator(menu);
        JMenuItem disabled = MenuFactory.makeMenuItemRes("disable", "disable");
        JMenuItem enabled = MenuFactory.makeMenuItemRes("enable", "enable");
        boolean isEnabled = GuiPackage.getInstance().getTreeListener().getCurrentNode().isEnabled();
        disabled.setEnabled(isEnabled);
        enabled.setEnabled(!isEnabled);
        menu.add(enabled);
        menu.add(disabled);
        JMenuItem toggle = MenuFactory.makeMenuItemRes("toggle", "toggle", KeyStrokes.TOGGLE);
        menu.add(toggle);
        MenuFactory.addSeparator(menu);
        menu.add(MenuFactory.makeMenuItemRes("help", "help"));
    }

    private static void addUndoItems(JPopupMenu menu) {
        MenuFactory.addSeparator(menu);
        JMenuItem undo = MenuFactory.makeMenuItemRes("undo", "undo");
        undo.setEnabled(GuiPackage.getInstance().canUndo());
        menu.add(undo);
        JMenuItem redo = MenuFactory.makeMenuItemRes("redo", "redo");
        redo.setEnabled(GuiPackage.getInstance().canRedo());
        menu.add(redo);
    }

    public static JMenu makeMenus(String[] categories, String label, String actionCommand) {
        JMenu addMenu = new JMenu(label);
        Arrays.stream(categories).map(category -> MenuFactory.makeMenu(category, actionCommand)).forEach(addMenu::add);
        GuiUtils.makeScrollableMenu((JMenu)addMenu);
        return addMenu;
    }

    public static JPopupMenu getDefaultControllerMenu() {
        JPopupMenu pop = new JPopupMenu();
        String addAction = "Add";
        JMenu addMenu = new JMenu(JMeterUtils.getResString("add"));
        addMenu.add(MenuFactory.makeMenu(SAMPLERS, addAction));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu(CONTROLLERS, addAction));
        addMenu.addSeparator();
        pop.add(MenuFactory.addDefaultAddMenuToMenu(addMenu, addAction));
        pop.add(MenuFactory.makeMenuItemRes("add_think_times", "Add Think Time between each step"));
        pop.add(MenuFactory.makeMenuItemRes("apply_naming", "Apply Naming Convention"));
        pop.add(MenuFactory.makeMenus(new String[]{CONTROLLERS}, JMeterUtils.getResString("change_parent"), "Change Parent"));
        pop.add(MenuFactory.makeMenus(new String[]{CONTROLLERS}, JMeterUtils.getResString("insert_parent"), "Add Parent"));
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    private static JMenu createDefaultAddMenu() {
        String addAction = "Add";
        JMenu addMenu = new JMenu(JMeterUtils.getResString("add"));
        MenuFactory.addDefaultAddMenuToMenu(addMenu, addAction);
        return addMenu;
    }

    private static JMenu addDefaultAddMenuToMenu(JMenu addMenu, String addAction) {
        addMenu.add(MenuFactory.makeMenu(ASSERTIONS, addAction));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu(TIMERS, addAction));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu(PRE_PROCESSORS, addAction));
        addMenu.add(MenuFactory.makeMenu(POST_PROCESSORS, addAction));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu(CONFIG_ELEMENTS, addAction));
        addMenu.add(MenuFactory.makeMenu(LISTENERS, addAction));
        return addMenu;
    }

    public static JPopupMenu getDefaultSamplerMenu() {
        JPopupMenu pop = new JPopupMenu();
        pop.add(MenuFactory.createDefaultAddMenu());
        pop.add(MenuFactory.makeMenus(new String[]{CONTROLLERS}, JMeterUtils.getResString("insert_parent"), "Add Parent"));
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultConfigElementMenu() {
        return MenuFactory.createDefaultPopupMenu();
    }

    public static JPopupMenu getDefaultVisualizerMenu() {
        JPopupMenu pop = new JPopupMenu();
        pop.add(MenuFactory.makeMenuItemRes("clear", "action.clear"));
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultTimerMenu() {
        return MenuFactory.createDefaultPopupMenu();
    }

    public static JPopupMenu getDefaultAssertionMenu() {
        return MenuFactory.createDefaultPopupMenu();
    }

    public static JPopupMenu getDefaultExtractorMenu() {
        return MenuFactory.createDefaultPopupMenu();
    }

    public static JPopupMenu getDefaultMenu() {
        return MenuFactory.createDefaultPopupMenu();
    }

    private static JPopupMenu createDefaultPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JMenu makeMenu(String category, String actionCommand) {
        return MenuFactory.makeMenu((Collection<MenuInfo>)menuMap.get(category), actionCommand, JMeterUtils.getResString(category));
    }

    private static JMenu makeMenu(Collection<MenuInfo> menuInfo, String actionCommand, String menuName) {
        JMenu menu = new JMenu(menuName);
        menuInfo.stream().map(info -> MenuFactory.makeMenuItem(info, actionCommand)).forEach(menu::add);
        GuiUtils.makeScrollableMenu((JMenu)menu);
        return menu;
    }

    public static void setEnabled(JMenu menu) {
        if (menu.getSubElements().length == 0) {
            menu.setEnabled(false);
        }
    }

    public static JMenuItem makeMenuItem(String label, String name, String actionCommand) {
        JMenuItem newMenuChoice = new JMenuItem(label);
        newMenuChoice.setName(name);
        newMenuChoice.addActionListener(ActionRouter.getInstance());
        if (actionCommand != null) {
            newMenuChoice.setActionCommand(actionCommand);
        }
        return newMenuChoice;
    }

    public static JMenuItem makeMenuItemRes(String resource, String actionCommand) {
        JMenuItem newMenuChoice = new JMenuItem(JMeterUtils.getResString(resource));
        newMenuChoice.setName(resource);
        newMenuChoice.addActionListener(ActionRouter.getInstance());
        if (actionCommand != null) {
            newMenuChoice.setActionCommand(actionCommand);
        }
        return newMenuChoice;
    }

    private static Component makeMenuItem(MenuInfo info, String actionCommand) {
        if (info instanceof MenuSeparatorInfo) {
            return new JPopupMenu.Separator();
        }
        JMenuItem newMenuChoice = new JMenuItem(info.getLabel());
        newMenuChoice.setName(info.getClassName());
        newMenuChoice.setEnabled(info.getEnabled(actionCommand));
        newMenuChoice.addActionListener(ActionRouter.getInstance());
        if (actionCommand != null) {
            newMenuChoice.setActionCommand(actionCommand);
        }
        return newMenuChoice;
    }

    private static JMenuItem makeMenuItemRes(String resource, String actionCommand, KeyStroke accel) {
        JMenuItem item = MenuFactory.makeMenuItemRes(resource, actionCommand);
        item.setAccelerator(accel);
        return item;
    }

    private static void addSeparator(JPopupMenu menu) {
        MenuElement[] elements = menu.getSubElements();
        if (elements.length > 0 && !(elements[elements.length - 1] instanceof JPopupMenu.Separator)) {
            menu.addSeparator();
        }
    }

    public static boolean canAddTo(JMeterTreeNode parentNode, TestElement element) {
        JMeterTreeNode node = new JMeterTreeNode(element, null);
        return MenuFactory.canAddTo(parentNode, new JMeterTreeNode[]{node});
    }

    public static boolean canAddTo(JMeterTreeNode parentNode, JMeterTreeNode[] nodes) {
        if (parentNode == null || MenuFactory.foundClass(nodes, new Class[]{TestPlan.class})) {
            return false;
        }
        TestElement parent = parentNode.getTestElement();
        if (MenuFactory.foundClass(nodes, new Class[]{TestFragmentController.class})) {
            return parent instanceof TestPlan;
        }
        if (MenuFactory.foundMenuCategories(nodes, NON_TEST_ELEMENTS) && !(parent instanceof TestPlan) && !(parent instanceof TestFragmentController)) {
            return false;
        }
        if (parent instanceof TestPlan) {
            List<Class<?>> samplerAndController = Arrays.asList(Sampler.class, Controller.class);
            List<Class<?>> exceptions = Arrays.asList(AbstractThreadGroup.class, NonTestElement.class);
            return !MenuFactory.foundClass(nodes, samplerAndController, exceptions);
        }
        if (MenuFactory.foundClass(nodes, new Class[]{AbstractThreadGroup.class})) {
            return false;
        }
        if (parent instanceof Controller) {
            return true;
        }
        if (parent instanceof Sampler) {
            return !MenuFactory.foundClass(nodes, new Class[]{Sampler.class, Controller.class});
        }
        return false;
    }

    private static boolean foundClass(JMeterTreeNode[] nodes, Class<?>[] classes) {
        for (JMeterTreeNode node : nodes) {
            for (Class<?> aClass : classes) {
                if (!aClass.isInstance(node.getUserObject())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean foundMenuCategories(JMeterTreeNode[] nodes, String category) {
        return Arrays.stream(nodes).flatMap(node -> node.getMenuCategories().stream()).anyMatch(category::equals);
    }

    private static boolean foundClass(JMeterTreeNode[] nodes, List<Class<?>> classes, List<Class<?>> exceptions) {
        return Arrays.stream(nodes).map(DefaultMutableTreeNode::getUserObject).filter(userObj -> exceptions.stream().noneMatch(c -> c.isInstance(userObj))).anyMatch(userObj -> classes.stream().anyMatch(c -> c.isInstance(userObj)));
    }

    static {
        menuMap.put(THREADS, new ArrayList());
        menuMap.put(TIMERS, new ArrayList());
        menuMap.put(ASSERTIONS, new ArrayList());
        menuMap.put(CONFIG_ELEMENTS, new ArrayList());
        menuMap.put(CONTROLLERS, new ArrayList());
        menuMap.put(LISTENERS, new ArrayList());
        menuMap.put(NON_TEST_ELEMENTS, new ArrayList());
        menuMap.put(SAMPLERS, new ArrayList());
        menuMap.put(POST_PROCESSORS, new ArrayList());
        menuMap.put(PRE_PROCESSORS, new ArrayList());
        menuMap.put(FRAGMENTS, new ArrayList());
        menuMap.put(SEPARATOR, Collections.singletonList(new MenuSeparatorInfo()));
        try {
            MenuFactory.initializeMenus(menuMap, MenuFactory.classesToSkip());
            MenuFactory.sortMenus(menuMap.values());
            MenuFactory.separateItemsWithExplicitOrder(menuMap.values());
        }
        catch (Error | RuntimeException ex) {
            log.error("Error initializing menus, check configuration if using 3rd party libraries", ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("Error initializing menus, check configuration if using 3rd party libraries", (Throwable)ex);
        }
    }
}

