/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.LocalDate;
import java.time.Year;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomDate
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(RandomDate.class);
    private static final String KEY = "__RandomDate";
    private static final int MIN_PARAMETER_COUNT = 3;
    private static final int MAX_PARAMETER_COUNT = 5;
    private static final List<String> desc = Arrays.asList(JMeterUtils.getResString((String)"time_format_random"), JMeterUtils.getResString((String)"date_start"), JMeterUtils.getResString((String)"date_end"), JMeterUtils.getResString((String)"locale_format"), JMeterUtils.getResString((String)"function_name_paropt"));
    private Locale locale = JMeterUtils.getLocale();
    private ZoneId systemDefaultZoneID = ZoneId.systemDefault();
    private CompoundVariable[] values;
    private Cache<LocaleFormatObject, DateTimeFormatter> dateRandomFormatterCache;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        DateTimeFormatter formatter;
        LocaleFormatObject lfo;
        String format;
        String localeAsString;
        if (this.values.length > 3 && !(localeAsString = this.values[3].execute().trim()).trim().isEmpty()) {
            this.locale = LocaleUtils.toLocale((String)localeAsString);
        }
        if (!StringUtils.isEmpty((CharSequence)(format = this.values[0].execute().trim()))) {
            try {
                lfo = new LocaleFormatObject(format, this.locale);
                formatter = (DateTimeFormatter)this.dateRandomFormatterCache.get((Object)lfo, key -> this.createFormatter((LocaleFormatObject)key));
            }
            catch (IllegalArgumentException ex) {
                log.error("Format date pattern '{}' is invalid (see https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html)", (Object)format, (Object)ex);
                return "";
            }
        }
        try {
            lfo = new LocaleFormatObject("yyyy-MM-dd", this.locale);
            formatter = (DateTimeFormatter)this.dateRandomFormatterCache.get((Object)lfo, key -> this.createFormatter((LocaleFormatObject)key));
        }
        catch (IllegalArgumentException ex) {
            log.error("Format date pattern '{}' is invalid (see https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html)", (Object)format, (Object)ex);
            return "";
        }
        String dateStart = this.values[1].execute().trim();
        long localStartDate = 0L;
        if (!dateStart.isEmpty()) {
            try {
                localStartDate = LocalDate.parse(dateStart, formatter).toEpochDay();
            }
            catch (NumberFormatException | DateTimeParseException ex) {
                log.error("Failed to parse Start Date '{}'", (Object)dateStart, (Object)ex);
            }
        } else {
            try {
                localStartDate = LocalDate.now(this.systemDefaultZoneID).toEpochDay();
            }
            catch (NumberFormatException | DateTimeParseException ex) {
                log.error("Failed to create current date '{}'", (Object)dateStart, (Object)ex);
            }
        }
        long localEndDate = 0L;
        String dateEnd = this.values[2].execute().trim();
        try {
            localEndDate = LocalDate.parse(dateEnd, formatter).toEpochDay();
        }
        catch (NumberFormatException | DateTimeParseException ex) {
            log.error("Failed to parse End date '{}'", (Object)dateEnd, (Object)ex);
        }
        String dateString = "";
        if (localEndDate < localStartDate) {
            log.error("End Date '{}' must be greater than Start Date '{}'", (Object)dateEnd, (Object)dateStart);
        } else {
            long randomDay = ThreadLocalRandom.current().nextLong(localStartDate, localEndDate);
            try {
                dateString = LocalDate.ofEpochDay(randomDay).format(formatter);
            }
            catch (NumberFormatException | DateTimeParseException ex) {
                log.error("Failed to generate random date '{}'", (Object)randomDay, (Object)ex);
            }
            this.addVariableValue(dateString, this.values, 4);
        }
        return dateString;
    }

    private DateTimeFormatter createFormatter(LocaleFormatObject format) {
        log.debug("Create a new instance of DateTimeFormatter for format '{}' in the cache", (Object)format);
        return new DateTimeFormatterBuilder().appendPattern(format.getFormat()).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.YEAR_OF_ERA, Year.now().getValue()).toFormatter(format.getLocale());
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 3, 5);
        this.values = parameters.toArray(new CompoundVariable[parameters.size()]);
        if (this.dateRandomFormatterCache == null) {
            this.dateRandomFormatterCache = Caffeine.newBuilder().maximumSize(100L).build();
        }
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    private static final class LocaleFormatObject {
        private String format;
        private Locale locale;

        public LocaleFormatObject(String format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }

        public String getFormat() {
            return this.format;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public int hashCode() {
            return this.format.hashCode() + this.locale.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof LocaleFormatObject)) {
                return false;
            }
            LocaleFormatObject otherError = (LocaleFormatObject)other;
            return this.format.equals(otherError.getFormat()) && this.locale.getDisplayName().equals(otherError.getLocale().getDisplayName());
        }

        public String toString() {
            return "LocaleFormatObject [format=" + this.format + ", locale=" + this.locale + "]";
        }
    }
}

