/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows;

import com.github.weisj.darklaf.platform.windows.JNIThemeInfoWindows;
import com.github.weisj.darklaf.platform.windows.WindowsLibrary;
import com.github.weisj.darklaf.platform.windows.WindowsPreferenceMonitor;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.theme.info.ColorToneRule;
import com.github.weisj.darklaf.theme.info.ContrastRule;
import com.github.weisj.darklaf.theme.info.FontSizeRule;
import com.github.weisj.darklaf.theme.info.PreferredThemeStyle;
import com.github.weisj.darklaf.theme.info.ThemePreferenceProvider;
import java.awt.Color;
import java.util.function.Consumer;

public class WindowsThemePreferenceProvider
implements ThemePreferenceProvider {
    private final PreferredThemeStyle fallbackStyle = new PreferredThemeStyle(ContrastRule.STANDARD, ColorToneRule.LIGHT);
    private final WindowsPreferenceMonitor monitor = new WindowsPreferenceMonitor(this);
    private Consumer<PreferredThemeStyle> callback;

    public PreferredThemeStyle getPreference() {
        if (!WindowsLibrary.get().isLoaded()) {
            return this.fallbackStyle;
        }
        boolean darkMode = JNIThemeInfoWindows.isDarkThemeEnabled();
        boolean highContrast = JNIThemeInfoWindows.isHighContrastEnabled();
        long fontScaling = JNIThemeInfoWindows.getFontScaleFactor();
        int accentColorRGB = JNIThemeInfoWindows.getAccentColor();
        return this.create(highContrast, darkMode, fontScaling, accentColorRGB);
    }

    private PreferredThemeStyle create(boolean highContrast, boolean darkMode, long fontScaling, int accentColorRGB) {
        ContrastRule contrastRule = highContrast ? ContrastRule.HIGH_CONTRAST : ContrastRule.STANDARD;
        ColorToneRule toneRule = darkMode ? ColorToneRule.DARK : ColorToneRule.LIGHT;
        FontSizeRule fontSizeRule = FontSizeRule.relativeAdjustment((float)((float)fontScaling / 100.0f));
        AccentColorRule accentColorRule = AccentColorRule.fromColor((Color)this.createColorFromRGB(accentColorRGB));
        return new PreferredThemeStyle(contrastRule, toneRule, accentColorRule, fontSizeRule);
    }

    private Color createColorFromRGB(int rgb) {
        if (rgb == 0) {
            return null;
        }
        return new Color(rgb);
    }

    void reportPreferenceChange(boolean highContrast, boolean darkMode, long fontScaleFactor, int accentColorRGB) {
        if (this.callback != null) {
            PreferredThemeStyle style = this.create(highContrast, darkMode, fontScaleFactor, accentColorRGB);
            this.callback.accept(style);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReporting(boolean reporting) {
        if (reporting && !WindowsLibrary.get().isLoaded()) {
            WindowsLibrary.get().updateLibrary();
        }
        WindowsPreferenceMonitor windowsPreferenceMonitor = this.monitor;
        synchronized (windowsPreferenceMonitor) {
            this.monitor.setRunning(reporting);
        }
    }

    public boolean isReporting() {
        return this.monitor.isRunning();
    }

    public void initialize() {
        WindowsLibrary.get().updateLibrary();
    }

    public void setCallback(Consumer<PreferredThemeStyle> callback) {
        this.callback = callback;
    }

    public boolean canReport() {
        return true;
    }

    public boolean supportsNativeAccentColor() {
        return WindowsLibrary.get().isLoaded();
    }

    public boolean supportsNativeFontSize() {
        return WindowsLibrary.get().isLoaded();
    }

    public boolean supportsNativeTheme() {
        return WindowsLibrary.get().isLoaded();
    }
}

