/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.PropertyLoader;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.icons.StateIcon;
import com.github.weisj.darklaf.task.AccentColorAdjustmentTask;
import com.github.weisj.darklaf.task.ForegroundColorGenerationTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.ui.togglebutton.radiobutton.DarkRadioButtonUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class ColoredRadioButton
extends JRadioButton {
    public static final Color DEFAULT_COLOR = new Color(0);
    private Color color;
    private Color focusColor;

    public ColoredRadioButton(String text, Color color) {
        super(text, null, false);
        this.setColors(color, color);
    }

    public ColoredRadioButton(String text, boolean selected, Color color) {
        super(text, null, selected);
        this.setColors(color, color);
    }

    public ColoredRadioButton(String text, Color color, Color focusColor) {
        super(text, null, false);
        this.setColors(color, focusColor);
    }

    public ColoredRadioButton(String text, boolean selected, Color color, Color focusColor) {
        super(text, null, selected);
        this.setColors(color, focusColor);
    }

    public void setColors(Color color, Color focusColor) {
        this.color = color;
        this.focusColor = focusColor != null ? focusColor : color;
        this.updateColorUI();
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateColorUI();
    }

    public void setFocusColor(Color color) {
        this.focusColor = color;
        this.updateColorUI();
    }

    private void updateColorUI() {
        ColoredRadioButtonUI ui = DarkUIUtil.getUIOfType(this.getUI(), ColoredRadioButtonUI.class);
        if (ui != null) {
            ui.setColors(this.color, this.focusColor);
        }
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        if (!(newUI instanceof ColoredRadioButtonUI)) {
            throw new IllegalArgumentException("UI must be of type ColoredRadioButtonUI");
        }
        super.setUI(newUI);
    }

    @Override
    public void updateUI() {
        this.setUI(new ColoredRadioButtonUI(this.color, this.focusColor));
    }

    protected static class ColoredRadioButtonUI
    extends DarkRadioButtonUI {
        private static final String[] PROPERTIES = new String[]{"Icons.RadioButton.activeFillColor", "Icons.RadioButton.activeBorderColor", "Icons.RadioButtonDisabled.inactiveFillColor", "Icons.RadioButtonDisabled.inactiveBorderColor", "Icons.RadioButtonFocused.activeFillColor", "Icons.RadioButtonFocused.focusBorderColor", "Icons.RadioButtonFocused.glowFocus", "Icons.RadioButtonFocused.glowOpacity", "Icons.RadioButtonSelected.selectedFillColor", "Icons.RadioButtonSelected.selectedBorderColor", "Icons.RadioButtonSelected.selectionSelectedColor", "Icons.RadioButtonSelectedDisabled.inactiveFillColor", "Icons.RadioButtonSelectedDisabled.inactiveBorderColor", "Icons.RadioButtonSelectedDisabled.selectionDisabledColor", "Icons.RadioButtonSelectedFocused.selectedFillColor", "Icons.RadioButtonSelectedFocused.focusSelectedBorderColor", "Icons.RadioButtonSelectedFocused.selectionFocusSelectedColor", "Icons.RadioButtonSelectedFocused.glowFocus", "Icons.RadioButtonSelectedFocused.glowOpacity"};
        private static final String[] COLOR_PROPERTIES = new String[]{"Icons.RadioButton.activeFillColor", "Icons.RadioButton.activeBorderColor", "Icons.RadioButtonFocused.activeFillColor", "Icons.RadioButtonFocused.focusBorderColor", "Icons.RadioButtonSelected.selectedFillColor", "Icons.RadioButtonSelected.selectedBorderColor", "Icons.RadioButtonSelectedFocused.selectedFillColor", "Icons.RadioButtonSelectedFocused.focusSelectedBorderColor"};
        private static final String[] FOCUS_COLOR_PROPERTIES = new String[]{"Icons.RadioButtonFocused.glowFocus", "Icons.RadioButtonSelectedFocused.glowFocus"};
        private static final String[] FOREGROUND_PROPERTIES = new String[]{"Icons.RadioButtonSelected.selectionSelectedColor", "Icons.RadioButtonSelectedFocused.selectionFocusSelectedColor"};
        private static final double MIN_FG_CONTRAST = 0.6;
        private Properties propertyMap;
        private Icon stateIcon;
        private Color color;
        private Color focusColor;
        private Color patchedColor;
        private Color patchedFocusColor;
        private boolean patched;
        private static final AccentColorAdjustmentTask adjustment = new AccentColorAdjustmentTask();

        public ColoredRadioButtonUI(Color color, Color focusColor) {
            this.color = color;
            this.focusColor = focusColor;
        }

        @Override
        protected void installIcons() {
            super.installIcons();
            this.patchColors(this.color, this.focusColor);
        }

        public void setColors(Color color, Color focusColor) {
            this.color = color;
            this.focusColor = focusColor != null ? focusColor : color;
        }

        @Override
        public void update(Graphics g, JComponent c) {
            if (this.patchedColor != this.color || this.patchedFocusColor != this.focusColor) {
                this.patchColors(this.color, this.focusColor);
            }
            super.update(g, c);
        }

        private void patchColors(Color color, Color focusColor) {
            if (color == null || this.patched && this.patchedColor == color && this.patchedFocusColor == focusColor) {
                return;
            }
            this.patchedColor = color;
            this.patchedFocusColor = focusColor;
            IconLoader loader = DarkUIUtil.ICON_LOADER;
            Theme theme = LafManager.getInstalledTheme();
            Properties props = new Properties();
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            theme.loadDefaults(props, defaults);
            Color accentCol = color == DEFAULT_COLOR ? (Color)props.get("widgetFillDefault") : color;
            Color focusCol = focusColor == DEFAULT_COLOR ? accentCol : focusColor;
            adjustment.applyColors(theme, props, accentCol, null);
            PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(DarkLaf.class, (String)"radioButton", (String)"properties/ui/"), (Properties)props, (UIDefaults)defaults);
            PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(DarkLaf.class, (String)"radioButton", (String)"properties/icons/"), (Properties)props, (UIDefaults)defaults);
            this.propertyMap = new Properties();
            for (String prop : PROPERTIES) {
                this.propertyMap.put(prop, props.get(prop));
            }
            for (String prop : COLOR_PROPERTIES) {
                this.propertyMap.put(prop, accentCol);
            }
            if (focusColor != DEFAULT_COLOR) {
                for (String prop : FOCUS_COLOR_PROPERTIES) {
                    this.propertyMap.put(prop, focusCol);
                }
            }
            for (String prop : FOREGROUND_PROPERTIES) {
                ForegroundColorGenerationTask.Bias bias = ForegroundColorGenerationTask.Bias.getBackground(0.552);
                ColorUIResource fg = ForegroundColorGenerationTask.makeAdjustedForeground((Color)props.get(prop), accentCol, bias, 0.6);
                this.propertyMap.put(prop, fg);
            }
            this.stateIcon = new StateIcon(new Icon[]{this.load(loader, "control/radio.svg"), this.load(loader, "control/radioDisabled.svg"), this.load(loader, "control/radioFocused.svg"), this.load(loader, "control/radioSelected.svg"), this.load(loader, "control/radioSelectedDisabled.svg"), this.load(loader, "control/radioSelectedFocused.svg")});
            this.patched = true;
        }

        private Icon load(IconLoader loader, String name) {
            return loader.loadSVGIcon(name, 19, 19, true, (Map)this.propertyMap);
        }

        @Override
        protected Icon getStateIcon(AbstractButton b) {
            return this.patched ? this.stateIcon : super.getStateIcon(b);
        }
    }
}

