/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui.ui;

import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.apiguardian.api.API;

@API(since="5.3", status=API.Status.INTERNAL)
public class TextComponentUI {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final boolean IS_MAC = Pattern.compile("mac os x|darwin|osx", 2).matcher(OS_NAME).find();
    private static final int COMMAND_KEY = IS_MAC ? 256 : 128;
    @API(since="5.3", status=API.Status.INTERNAL)
    public static final TextComponentUI INSTANCE = new TextComponentUI();
    private final AtomicInteger undoEpoch = new AtomicInteger();

    @API(since="5.3", status=API.Status.INTERNAL)
    public void resetUndoHistory() {
        this.undoEpoch.getAndIncrement();
    }

    @API(since="5.3", status=API.Status.INTERNAL)
    public void installUndo(JTextComponent component) {
        final UndoManager manager = new UndoManager(){
            private int ourUndoEpoch;
            {
                this.ourUndoEpoch = TextComponentUI.this.undoEpoch.get();
            }

            @Override
            public synchronized void discardAllEdits() {
                super.discardAllEdits();
                this.ourUndoEpoch = TextComponentUI.this.undoEpoch.get();
            }

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                int epoch = TextComponentUI.this.undoEpoch.get();
                if (this.ourUndoEpoch != epoch) {
                    this.discardAllEdits();
                }
                super.undoableEditHappened(e);
            }

            @Override
            public synchronized boolean canUndo() {
                return this.ourUndoEpoch == TextComponentUI.this.undoEpoch.get() && super.canUndo();
            }

            @Override
            public synchronized boolean canRedo() {
                return this.ourUndoEpoch == TextComponentUI.this.undoEpoch.get() && super.canRedo();
            }
        };
        manager.setLimit(200);
        component.addPropertyChangeListener("document", evt -> {
            manager.discardAllEdits();
            if (evt.getOldValue() != null) {
                ((Document)evt.getOldValue()).removeUndoableEditListener(manager);
            }
            if (evt.getNewValue() != null) {
                ((Document)evt.getNewValue()).addUndoableEditListener(manager);
            }
        });
        component.getActionMap().put("undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (manager.canUndo()) {
                    manager.undo();
                }
            }
        });
        component.getActionMap().put("redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (manager.canRedo()) {
                    manager.redo();
                }
            }
        });
        KeyStroke commandZ = KeyStroke.getKeyStroke(90, COMMAND_KEY);
        component.getInputMap().put(commandZ, "undo");
        KeyStroke shiftCommandZ = KeyStroke.getKeyStroke(90, COMMAND_KEY | 0x40);
        component.getInputMap().put(shiftCommandZ, "redo");
    }
}

