/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.rmi;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.jmeter.rmi.AliasKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLRMIServerSocketFactory
implements RMIServerSocketFactory,
Serializable {
    private static final long serialVersionUID = 258730225720182190L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLRMIServerSocketFactory.class);
    private final InetAddress localAddress;
    private String alias;
    private String keyStoreLocation;
    private String keyStorePassword;
    private String keyStoreType;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String trustStoreType;
    private boolean clientAuth;

    public SSLRMIServerSocketFactory(InetAddress pAddress) {
        this.localAddress = pAddress;
    }

    public void setNeedClientAuth(boolean clientAuth) {
        this.clientAuth = clientAuth;
    }

    public void setKeystore(String location, String type, String password) {
        this.keyStoreLocation = location;
        this.keyStoreType = type;
        this.keyStorePassword = password;
    }

    public void setTruststore(String location, String type, String password) {
        this.trustStoreLocation = location;
        this.trustStoreType = type;
        this.trustStorePassword = password;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket socket;
        SSLContext ctx;
        char[] passphrase = null;
        if (this.keyStorePassword != null) {
            passphrase = this.keyStorePassword.toCharArray();
        }
        KeyStore keyStore = null;
        if (this.keyStoreLocation != null) {
            keyStore = this.loadStore(this.keyStoreLocation, passphrase, this.keyStoreType);
        }
        KeyStore trustStore = this.trustStoreLocation != null ? this.loadStore(this.trustStoreLocation, this.trustStorePassword.toCharArray(), this.trustStoreType) : keyStore;
        if (this.alias == null) {
            throw new IOException("SSL certificate alias cannot be null; MUST be set for SSLServerSocketFactory!");
        }
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, passphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            ctx = SSLContext.getInstance("TLS");
            ctx.init(AliasKeyManager.wrap(kmf.getKeyManagers(), this.alias), tmf.getTrustManagers(), null);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        SSLServerSocketFactory factory = ctx.getServerSocketFactory();
        if (factory == null) {
            throw new IOException("Unable to obtain SSLServerSocketFactory for provided KeyStore");
        }
        try {
            socket = (SSLServerSocket)factory.createServerSocket(port, 0, this.localAddress);
        }
        catch (BindException e) {
            throw new IOException("Could not bind to " + this.localAddress + " using port " + port, e);
        }
        socket.setNeedClientAuth(this.clientAuth);
        LOGGER.info("Created SSLSocket: {}", (Object)socket);
        return socket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore loadStore(String location, char[] passphrase, String type) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(location);){
            KeyStore store = KeyStore.getInstance(type);
            store.load(fileInputStream, passphrase);
            KeyStore keyStore = store;
            return keyStore;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(e);
        }
    }

    public String toString() {
        return "SSLRMIServerSocketFactory(host=" + this.localAddress + ", keyStoreLocation=" + this.keyStoreLocation + ", type=" + this.keyStoreType + ", trustStoreLocation=" + this.trustStoreLocation + ", type=" + this.trustStoreType + ", alias=" + this.alias + ')';
    }
}

