/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.Validate;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.core.SampleException;
import org.apache.jmeter.report.core.SampleMetadata;
import org.apache.jmeter.report.processor.AbstractSampleProcessor;
import org.apache.jmeter.report.processor.SampleConsumer;
import org.apache.jmeter.report.processor.SampleContext;
import org.apache.jmeter.report.processor.SampleProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSampleConsumer
extends AbstractSampleProcessor
implements SampleConsumer,
SampleProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSampleConsumer.class);
    private String name;
    private long producedSampleCount;
    private File workingDir;
    private List<SampleConsumer> sampleConsumers = new ArrayList<SampleConsumer>();
    private Map<Integer, SampleMetadata> consumedMetadata = new TreeMap<Integer, SampleMetadata>();

    protected final Object getDataFromContext(String key) {
        return this.getSampleContext().getData().get(key);
    }

    protected final void setDataToContext(String key, Object value) {
        this.getSampleContext().getData().put(key, value);
    }

    public String getName() {
        if (this.name == null) {
            return this.getClass().getSimpleName() + "-" + this.hashCode();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final File getWorkingDirectory() {
        return this.workingDir;
    }

    private void setWorkingDirectory(File baseDirectory) {
        this.workingDir = new File(baseDirectory, this.getName());
    }

    @Override
    public void setSampleContext(SampleContext sampleContext) {
        super.setSampleContext(sampleContext);
        this.initConsumers(sampleContext);
        this.setWorkingDirectory(sampleContext.getWorkingDirectory());
    }

    public void setSampleConsumers(List<SampleConsumer> consumers) {
        Validate.notNull(consumers, (String)"consumers must not be null", (Object[])new Object[0]);
        this.sampleConsumers = consumers;
    }

    public void addSampleConsumer(SampleConsumer consumer) {
        if (consumer == null) {
            return;
        }
        this.sampleConsumers.add(consumer);
    }

    public void setSampleConsumer(SampleConsumer consumer) {
        this.addSampleConsumer(consumer);
    }

    public void removeSampleConsumer(SampleConsumer consumer) {
        if (consumer == null) {
            return;
        }
        this.sampleConsumers.remove(consumer);
    }

    @Override
    public void setConsumedMetadata(SampleMetadata sampleMetadata, int channel) {
        this.consumedMetadata.put(channel, sampleMetadata);
    }

    public SampleMetadata getConsumedMetadata(int channel) {
        return this.consumedMetadata.get(channel);
    }

    public int getConsumedChannelCount() {
        return this.consumedMetadata.size();
    }

    private void initConsumers(SampleContext context) {
        for (SampleConsumer consumer : this.sampleConsumers) {
            try {
                consumer.setSampleContext(context);
            }
            catch (Exception e) {
                throw new SampleException("Consumer failed with message :" + e.getMessage(), e);
            }
        }
    }

    @Override
    public void setChannelAttribute(int channel, String key, Object value) {
        super.setChannelAttribute(channel, key, value);
        for (SampleConsumer consumer : this.sampleConsumers) {
            consumer.setChannelAttribute(channel, key, value);
        }
    }

    @Override
    public void setProducedMetadata(SampleMetadata metadata, int channel) {
        for (SampleConsumer consumer : this.sampleConsumers) {
            try {
                consumer.setConsumedMetadata(metadata, channel);
            }
            catch (Exception e) {
                throw new SampleException("Consumer failed with message :" + e.getMessage(), e);
            }
        }
    }

    protected SampleConsumer getConsumer(int i) {
        if (i < this.sampleConsumers.size()) {
            return this.sampleConsumers.get(i);
        }
        return null;
    }

    @Override
    public void startProducing() {
        this.producedSampleCount = 0L;
        for (SampleConsumer consumer : this.sampleConsumers) {
            try {
                consumer.startConsuming();
            }
            catch (Exception e) {
                throw new SampleException("Consumer failed with message :" + e.getMessage(), e);
            }
        }
    }

    @Override
    public void produce(Sample s, int channel) {
        for (SampleConsumer consumer : this.sampleConsumers) {
            try {
                consumer.consume(s, channel);
                ++this.producedSampleCount;
            }
            catch (Exception e) {
                throw new SampleException("Consumer failed with message :" + e.getMessage(), e);
            }
        }
    }

    @Override
    public void stopProducing() {
        for (SampleConsumer consumer : this.sampleConsumers) {
            try {
                consumer.stopConsuming();
            }
            catch (Exception e) {
                throw new SampleException("Consumer failed with message :" + e.getMessage(), e);
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(this.getClass() + "#stopProducing(): " + this.getName() + " produced " + this.producedSampleCount + " samples");
        }
    }
}

