/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jmeter.gui.action.ActionNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IconToolbarBean {
    private static final Logger log = LoggerFactory.getLogger(IconToolbarBean.class);
    private static final String ICON_FIELD_SEP = ",";
    private static final Pattern DIMENSIONS = Pattern.compile("(\\d+)x(\\d+)");
    private final String i18nKey;
    private final String actionName;
    private final String iconPath;
    private final String iconPathPressed;
    private final int width;
    private final int height;

    IconToolbarBean(String strToSplit, String iconSize) throws IllegalArgumentException {
        if (strToSplit == null) {
            throw new IllegalArgumentException("Icon definition must not be null");
        }
        String[] tmp = strToSplit.split(ICON_FIELD_SEP);
        if (tmp.length <= 2) {
            throw new IllegalArgumentException("Incorrect argument format - expected at least 2 fields separated by ,");
        }
        this.i18nKey = tmp[0];
        this.actionName = tmp[1];
        this.iconPath = tmp[2].replace("<SIZE>", iconSize);
        this.iconPathPressed = tmp.length > 3 ? tmp[3].replace("<SIZE>", iconSize) : this.iconPath;
        Matcher m = DIMENSIONS.matcher(iconSize);
        if (m.matches()) {
            this.width = Integer.parseInt(m.group(1));
            this.height = Integer.parseInt(m.group(2));
        } else {
            log.info("Unable to parse {} as width x height for icon {}. Will default to 22x22", (Object)iconSize, (Object)this.actionName);
            this.width = 22;
            this.height = 22;
        }
    }

    public String getActionNameResolve() {
        String aName;
        try {
            aName = (String)ActionNames.class.getField(this.actionName).get(null);
        }
        catch (Exception e) {
            log.warn("Toolbar icon Action names error: {}, use unknown action.", (Object)this.actionName);
            return this.actionName;
        }
        return aName;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getIconPathPressed() {
        return this.iconPathPressed;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

