/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.tree;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.MenuFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterTreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(JMeterTreeTransferHandler.class);
    private DataFlavor nodeFlavor;
    private DataFlavor[] jMeterTreeNodeDataFlavors = new DataFlavor[1];
    private List<JMeterTreeNode> nodesForRemoval = null;

    public JMeterTreeTransferHandler() {
        try {
            String jvmLocalFlavor = "application/x-java-jvm-local-objectref;class=\"" + JMeterTreeNode[].class.getName() + "\"";
            this.jMeterTreeNodeDataFlavors[0] = this.nodeFlavor = new DataFlavor(jvmLocalFlavor);
        }
        catch (ClassNotFoundException e) {
            log.error("Class Not Found", (Throwable)e);
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.nodesForRemoval = null;
        JTree tree = (JTree)c;
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null) {
            JMeterTreeTransferHandler.sortTreePathByRow(paths, tree);
            boolean[] toRemove = new boolean[paths.length];
            int size = paths.length;
            block0: for (int i = 0; i < paths.length; ++i) {
                for (int j = 0; j < paths.length; ++j) {
                    if (i == j || !((JMeterTreeNode)paths[i].getLastPathComponent()).isNodeAncestor((JMeterTreeNode)paths[j].getLastPathComponent())) continue;
                    toRemove[i] = true;
                    --size;
                    continue block0;
                }
            }
            JMeterTreeNode[] nodes = new JMeterTreeNode[size];
            size = 0;
            for (int i = 0; i < paths.length; ++i) {
                if (toRemove[i]) continue;
                JMeterTreeNode node = (JMeterTreeNode)paths[i].getLastPathComponent();
                nodes[size++] = node;
            }
            return new NodesTransferable(nodes);
        }
        return null;
    }

    private static void sortTreePathByRow(TreePath[] paths, JTree tree) {
        Comparator cp = (o1, o2) -> {
            int row1 = tree.getRowForPath((TreePath)o1);
            int row2 = tree.getRowForPath((TreePath)o2);
            return Integer.compare(row1, row2);
        };
        Arrays.sort(paths, cp);
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (this.nodesForRemoval != null && (action & 2) == 2) {
            GuiPackage guiInstance = GuiPackage.getInstance();
            for (JMeterTreeNode jMeterTreeNode : this.nodesForRemoval) {
                guiInstance.getTreeModel().removeNodeFromParent(jMeterTreeNode);
            }
            this.nodesForRemoval = null;
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        DataFlavor[] flavors;
        if (!support.isDrop()) {
            return false;
        }
        for (DataFlavor flavor : flavors = support.getDataFlavors()) {
            if (!flavor.isFlavorJavaFileListType()) continue;
            return true;
        }
        if (!support.isDataFlavorSupported(this.nodeFlavor)) {
            return false;
        }
        int action = support.getDropAction();
        if (action != 2) {
            return false;
        }
        support.setShowDropLocation(true);
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath dest = dl.getPath();
        JMeterTreeNode target = (JMeterTreeNode)dest.getLastPathComponent();
        if (target.isRoot()) {
            return false;
        }
        JMeterTreeNode[] nodes = this.getDraggedNodes(support.getTransferable());
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (JMeterTreeNode node : nodes) {
            if (target == node) {
                return false;
            }
            if (node.getChildCount() <= 0 || !target.isNodeAncestor(node)) continue;
            return false;
        }
        return MenuFactory.canAddTo(target, nodes);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        GuiPackage guiInstance = GuiPackage.getInstance();
        DataFlavor[] flavors = support.getDataFlavors();
        Transferable t = support.getTransferable();
        for (DataFlavor flavor : flavors) {
            if (!flavor.isFlavorJavaFileListType()) continue;
            try {
                return guiInstance.getMainFrame().openJmxFilesFromDragAndDrop(t);
            }
            catch (Exception e) {
                log.error("Drop file failed", (Throwable)e);
                return false;
            }
        }
        JMeterTreeNode[] nodes = this.getDraggedNodes(t);
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath dest = dl.getPath();
        JMeterTreeNode target = (JMeterTreeNode)dest.getLastPathComponent();
        this.nodesForRemoval = new ArrayList<JMeterTreeNode>();
        int index = dl.getChildIndex();
        TreePath[] pathsToSelect = new TreePath[nodes.length];
        int pathPosition = 0;
        JMeterTreeModel treeModel = guiInstance.getTreeModel();
        for (JMeterTreeNode node : nodes) {
            if (index == -1) {
                index = target.getChildCount();
            }
            JMeterTreeNode copy = (JMeterTreeNode)node.clone();
            Enumeration<TreeNode> enumFrom = node.children();
            ArrayList<JMeterTreeNode> tmp = new ArrayList<JMeterTreeNode>();
            while (enumFrom.hasMoreElements()) {
                JMeterTreeNode child = (JMeterTreeNode)enumFrom.nextElement();
                tmp.add(child);
            }
            for (JMeterTreeNode jMeterTreeNode : tmp) {
                copy.add(jMeterTreeNode);
            }
            treeModel.insertNodeInto(copy, target, index++);
            this.nodesForRemoval.add(node);
            pathsToSelect[pathPosition++] = new TreePath(treeModel.getPathToRoot(copy));
        }
        TreePath treePath = new TreePath(target.getPath());
        JTree tree = (JTree)support.getComponent();
        tree.expandPath(treePath);
        tree.setSelectionPaths(pathsToSelect);
        return true;
    }

    private JMeterTreeNode[] getDraggedNodes(Transferable t) {
        JMeterTreeNode[] nodes = null;
        try {
            nodes = (JMeterTreeNode[])t.getTransferData(this.nodeFlavor);
        }
        catch (Exception e) {
            log.error("Unsupported Flavor in Transferable", (Throwable)e);
        }
        return nodes;
    }

    private class NodesTransferable
    implements Transferable {
        JMeterTreeNode[] nodes;

        public NodesTransferable(JMeterTreeNode[] nodes) {
            this.nodes = nodes;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return JMeterTreeTransferHandler.this.jMeterTreeNodeDataFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return JMeterTreeTransferHandler.this.nodeFlavor.equals(flavor);
        }
    }
}

