/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JFactory;
import org.apache.jorphan.gui.JLabeledTextField;

@GUIMenuSortOrder(value=5)
@TestElementMetadata(labelResource="url_config_title")
public class HttpDefaultsGui
extends AbstractConfigGui {
    private static final long serialVersionUID = 241L;
    private UrlConfigGui urlConfigGui;
    private JCheckBox retrieveEmbeddedResources;
    private JCheckBox concurrentDwn;
    private JTextField concurrentPool;
    private JCheckBox useMD5;
    private JLabeledTextField embeddedRE;
    private JTextField sourceIpAddr;
    private JComboBox<String> sourceIpType = new JComboBox<String>(HTTPSamplerBase.getSourceTypeList());
    private JTextField proxyScheme;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private JTextField proxyUser;
    private JPasswordField proxyPass;
    private JComboBox<String> httpImplementation = new JComboBox<String>(HTTPSamplerFactory.getImplementations());
    private JTextField connectTimeOut;
    private JTextField responseTimeOut;

    public HttpDefaultsGui() {
        this.init();
    }

    public String getLabelResource() {
        return "url_config_title";
    }

    public TestElement createTestElement() {
        ConfigTestElement config = new ConfigTestElement();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement config) {
        ConfigTestElement cfg = (ConfigTestElement)config;
        ConfigTestElement el = (ConfigTestElement)this.urlConfigGui.createTestElement();
        cfg.clear();
        cfg.addConfigElement((ConfigElement)el);
        super.configureTestElement(config);
        if (this.retrieveEmbeddedResources.isSelected()) {
            config.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.image_parser", true));
        } else {
            config.removeProperty("HTTPSampler.image_parser");
        }
        this.enableConcurrentDwn(this.retrieveEmbeddedResources.isSelected());
        if (this.concurrentDwn.isSelected()) {
            config.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.concurrentDwn", true));
        } else {
            config.removeProperty("HTTPSampler.concurrentDwn");
        }
        if (!StringUtils.isEmpty((CharSequence)this.concurrentPool.getText())) {
            config.setProperty((JMeterProperty)new StringProperty("HTTPSampler.concurrentPool", this.concurrentPool.getText()));
        } else {
            config.setProperty((JMeterProperty)new StringProperty("HTTPSampler.concurrentPool", String.valueOf(6)));
        }
        if (this.useMD5.isSelected()) {
            config.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.md5", true));
        } else {
            config.removeProperty("HTTPSampler.md5");
        }
        if (!StringUtils.isEmpty((CharSequence)this.embeddedRE.getText())) {
            config.setProperty((JMeterProperty)new StringProperty("HTTPSampler.embedded_url_re", this.embeddedRE.getText()));
        } else {
            config.removeProperty("HTTPSampler.embedded_url_re");
        }
        if (!StringUtils.isEmpty((CharSequence)this.sourceIpAddr.getText())) {
            config.setProperty((JMeterProperty)new StringProperty("HTTPSampler.ipSource", this.sourceIpAddr.getText()));
            config.setProperty((JMeterProperty)new IntegerProperty("HTTPSampler.ipSourceType", this.sourceIpType.getSelectedIndex()));
        } else {
            config.removeProperty("HTTPSampler.ipSource");
            config.removeProperty("HTTPSampler.ipSourceType");
        }
        config.setProperty("HTTPSampler.proxyScheme", this.proxyScheme.getText(), "");
        config.setProperty("HTTPSampler.proxyHost", this.proxyHost.getText(), "");
        config.setProperty("HTTPSampler.proxyPort", this.proxyPort.getText(), "");
        config.setProperty("HTTPSampler.proxyUser", this.proxyUser.getText(), "");
        config.setProperty("HTTPSampler.proxyPass", String.valueOf(this.proxyPass.getPassword()), "");
        config.setProperty("HTTPSampler.implementation", this.httpImplementation.getSelectedItem().toString(), "");
        config.setProperty("HTTPSampler.connect_timeout", this.connectTimeOut.getText());
        config.setProperty("HTTPSampler.response_timeout", this.responseTimeOut.getText());
    }

    public void clearGui() {
        super.clearGui();
        this.retrieveEmbeddedResources.setSelected(false);
        this.concurrentDwn.setSelected(false);
        this.concurrentPool.setText(String.valueOf(6));
        this.enableConcurrentDwn(false);
        this.useMD5.setSelected(false);
        this.urlConfigGui.clear();
        this.embeddedRE.setText("");
        this.sourceIpAddr.setText("");
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
        this.proxyScheme.setText("");
        this.proxyHost.setText("");
        this.proxyPort.setText("");
        this.proxyUser.setText("");
        this.proxyPass.setText("");
        this.httpImplementation.setSelectedItem("");
        this.connectTimeOut.setText("");
        this.responseTimeOut.setText("");
    }

    public void configure(TestElement el) {
        super.configure(el);
        AbstractTestElement samplerBase = (AbstractTestElement)el;
        this.urlConfigGui.configure(el);
        this.retrieveEmbeddedResources.setSelected(samplerBase.getPropertyAsBoolean("HTTPSampler.image_parser"));
        this.concurrentDwn.setSelected(samplerBase.getPropertyAsBoolean("HTTPSampler.concurrentDwn"));
        this.concurrentPool.setText(samplerBase.getPropertyAsString("HTTPSampler.concurrentPool"));
        this.useMD5.setSelected(samplerBase.getPropertyAsBoolean("HTTPSampler.md5", false));
        this.embeddedRE.setText(samplerBase.getPropertyAsString("HTTPSampler.embedded_url_re", ""));
        this.sourceIpAddr.setText(samplerBase.getPropertyAsString("HTTPSampler.ipSource"));
        this.sourceIpType.setSelectedIndex(samplerBase.getPropertyAsInt("HTTPSampler.ipSourceType", HTTPSamplerBase.SOURCE_TYPE_DEFAULT));
        this.proxyScheme.setText(samplerBase.getPropertyAsString("HTTPSampler.proxyScheme"));
        this.proxyHost.setText(samplerBase.getPropertyAsString("HTTPSampler.proxyHost"));
        this.proxyPort.setText(samplerBase.getPropertyAsString("HTTPSampler.proxyPort"));
        this.proxyUser.setText(samplerBase.getPropertyAsString("HTTPSampler.proxyUser"));
        this.proxyPass.setText(samplerBase.getPropertyAsString("HTTPSampler.proxyPass"));
        this.httpImplementation.setSelectedItem(samplerBase.getPropertyAsString("HTTPSampler.implementation"));
        this.connectTimeOut.setText(samplerBase.getPropertyAsString("HTTPSampler.connect_timeout"));
        this.responseTimeOut.setText(samplerBase.getPropertyAsString("HTTPSampler.response_timeout"));
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.urlConfigGui = new UrlConfigGui(false, true, false);
        HorizontalPanel httpOptions = new HorizontalPanel();
        httpOptions.add(this.getImplementationPanel());
        httpOptions.add(this.getTimeOutPanel());
        VerticalPanel advancedPanel = new VerticalPanel();
        advancedPanel.add((Component)httpOptions);
        advancedPanel.add(this.createEmbeddedRsrcPanel());
        advancedPanel.add(this.createSourceAddrPanel());
        advancedPanel.add(this.getProxyServerPanel());
        advancedPanel.add(this.createOptionalTasksPanel());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_basic"), this.urlConfigGui);
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_advanced"), (Component)advancedPanel);
        JPanel emptyPanel = new JPanel();
        emptyPanel.setMaximumSize(new Dimension());
        this.add(this.makeTitlePanel(), "North");
        this.add(tabbedPane, "Center");
        this.add(emptyPanel, "South");
    }

    private JPanel getTimeOutPanel() {
        HorizontalPanel timeOut = new HorizontalPanel();
        timeOut.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_server_timeout_title")));
        JPanel connPanel = this.getConnectTimeOutPanel();
        JPanel reqPanel = this.getResponseTimeOutPanel();
        timeOut.add(connPanel);
        timeOut.add(reqPanel);
        return timeOut;
    }

    private JPanel getConnectTimeOutPanel() {
        this.connectTimeOut = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_timeout_connect"));
        label.setLabelFor(this.connectTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.connectTimeOut, "Center");
        return panel;
    }

    private JPanel getResponseTimeOutPanel() {
        this.responseTimeOut = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_timeout_response"));
        label.setLabelFor(this.responseTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.responseTimeOut, "Center");
        return panel;
    }

    protected JPanel createEmbeddedRsrcPanel() {
        this.retrieveEmbeddedResources = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        this.retrieveEmbeddedResources.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.enableConcurrentDwn(true);
            } else {
                this.enableConcurrentDwn(false);
            }
        });
        this.concurrentDwn = new JCheckBox(JMeterUtils.getResString((String)"web_testing_concurrent_download"));
        this.concurrentDwn.addItemListener(e -> {
            if (this.retrieveEmbeddedResources.isSelected() && e.getStateChange() == 1) {
                this.concurrentPool.setEnabled(true);
            } else {
                this.concurrentPool.setEnabled(false);
            }
        });
        this.concurrentPool = new JTextField(2);
        this.concurrentPool.setMinimumSize(new Dimension(10, (int)this.concurrentPool.getPreferredSize().getHeight()));
        this.concurrentPool.setMaximumSize(new Dimension(30, (int)this.concurrentPool.getPreferredSize().getHeight()));
        HorizontalPanel embeddedRsrcPanel = new HorizontalPanel();
        embeddedRsrcPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_testing_retrieve_title")));
        embeddedRsrcPanel.add(this.retrieveEmbeddedResources);
        embeddedRsrcPanel.add(this.concurrentDwn);
        embeddedRsrcPanel.add(this.concurrentPool);
        this.embeddedRE = new JLabeledTextField(JMeterUtils.getResString((String)"web_testing_embedded_url_pattern"), 20);
        embeddedRsrcPanel.add((Component)this.embeddedRE);
        return embeddedRsrcPanel;
    }

    protected JPanel createSourceAddrPanel() {
        HorizontalPanel sourceAddrPanel = new HorizontalPanel();
        sourceAddrPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_testing_source_ip")));
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
        sourceAddrPanel.add(this.sourceIpType);
        this.sourceIpAddr = new JTextField();
        sourceAddrPanel.add(this.sourceIpAddr);
        return sourceAddrPanel;
    }

    protected JPanel createOptionalTasksPanel() {
        VerticalPanel checkBoxPanel = new VerticalPanel();
        checkBoxPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"optional_tasks")));
        this.useMD5 = new JCheckBox(JMeterUtils.getResString((String)"response_save_as_md5"));
        checkBoxPanel.add(this.useMD5);
        return checkBoxPanel;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void enableConcurrentDwn(boolean enable) {
        if (enable) {
            this.concurrentDwn.setEnabled(true);
            this.embeddedRE.setEnabled(true);
            if (this.concurrentDwn.isSelected()) {
                this.concurrentPool.setEnabled(true);
            }
        } else {
            this.concurrentDwn.setEnabled(false);
            this.concurrentPool.setEnabled(false);
            this.embeddedRE.setEnabled(false);
        }
    }

    protected final JPanel getImplementationPanel() {
        HorizontalPanel implPanel = new HorizontalPanel();
        implPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_server_client")));
        implPanel.add(new JLabel(JMeterUtils.getResString((String)"http_implementation")));
        this.httpImplementation.addItem("");
        implPanel.add(this.httpImplementation);
        return implPanel;
    }

    protected final JPanel getProxyServerPanel() {
        HorizontalPanel proxyServer = new HorizontalPanel();
        proxyServer.add((Component)this.getProxySchemePanel(), "West");
        proxyServer.add((Component)this.getProxyHostPanel(), "Center");
        proxyServer.add((Component)this.getProxyPortPanel(), "East");
        HorizontalPanel proxyLogin = new HorizontalPanel();
        proxyLogin.add(this.getProxyUserPanel());
        proxyLogin.add(this.getProxyPassPanel());
        HorizontalPanel proxyServerPanel = new HorizontalPanel();
        proxyServerPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_proxy_server_title")));
        proxyServerPanel.add((Component)proxyServer);
        proxyServerPanel.add((Component)proxyLogin);
        return proxyServerPanel;
    }

    private JPanel getProxySchemePanel() {
        this.proxyScheme = new JTextField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_proxy_scheme"));
        label.setLabelFor(this.proxyScheme);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyScheme, "Center");
        return panel;
    }

    private JPanel getProxyHostPanel() {
        this.proxyHost = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_domain"));
        label.setLabelFor(this.proxyHost);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyHost, "Center");
        return panel;
    }

    private JPanel getProxyPortPanel() {
        this.proxyPort = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_port"));
        label.setLabelFor(this.proxyPort);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPort, "Center");
        return panel;
    }

    private JPanel getProxyUserPanel() {
        this.proxyUser = new JTextField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"username"));
        label.setLabelFor(this.proxyUser);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyUser, "Center");
        return panel;
    }

    private JPanel getProxyPassPanel() {
        this.proxyPass = new JPasswordField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"password"));
        label.setLabelFor(this.proxyPass);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPass, "Center");
        return panel;
    }
}

