/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.protocol.jms.control.gui.JMSPropertiesPanel;
import org.apache.jmeter.protocol.jms.sampler.JMSProperties;
import org.apache.jmeter.protocol.jms.sampler.JMSSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextField;

@TestElementMetadata(labelResource="jms_point_to_point")
public class JMSSamplerGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 240L;
    private JLabeledTextField queueConnectionFactory = new JLabeledTextField(JMeterUtils.getResString((String)"jms_queue_connection_factory"));
    private JLabeledTextField sendQueue = new JLabeledTextField(JMeterUtils.getResString((String)"jms_send_queue"));
    private JLabeledTextField receiveQueue = new JLabeledTextField(JMeterUtils.getResString((String)"jms_receive_queue"));
    private JLabeledTextField timeout = new JLabeledTextField(JMeterUtils.getResString((String)"jms_timeout"), 10);
    private JLabeledTextField expiration = new JLabeledTextField(JMeterUtils.getResString((String)"jms_expiration"), 10);
    private JLabeledTextField priority = new JLabeledTextField(JMeterUtils.getResString((String)"jms_priority"), 1);
    private JLabeledTextField jmsSelector = new JLabeledTextField(JMeterUtils.getResString((String)"jms_selector"));
    private JLabeledTextField numberOfSamplesToAggregate = new JLabeledTextField("Number of samples to aggregate");
    private JSyntaxTextArea messageContent = JSyntaxTextArea.getInstance((int)10, (int)50);
    private JLabeledTextField initialContextFactory = new JLabeledTextField(JMeterUtils.getResString((String)"jms_initial_context_factory"));
    private JLabeledTextField providerUrl = new JLabeledTextField(JMeterUtils.getResString((String)"jms_provider_url"));
    private static final String[] JMS_COMMUNICATION_STYLE_LABELS = new String[]{"request_only", "request_reply", "read", "browse", "clear"};
    private JLabeledChoice jmsCommunicationStyle = new JLabeledChoice(JMeterUtils.getResString((String)"jms_communication_style"), JMS_COMMUNICATION_STYLE_LABELS);
    private JMSPropertiesPanel jmsPropertiesPanel;
    private ArgumentsPanel jndiPropertiesPanel;
    private JCheckBox useNonPersistentDelivery;
    private JCheckBox useReqMsgIdAsCorrelId;
    private JCheckBox useResMsgIdAsCorrelId;

    public JMSSamplerGui() {
        this.init();
    }

    public void clearGui() {
        super.clearGui();
        this.queueConnectionFactory.setText("");
        this.sendQueue.setText("");
        this.receiveQueue.setText("");
        this.jmsCommunicationStyle.setSelectedIndex(0);
        this.timeout.setText("");
        this.expiration.setText("");
        this.priority.setText("");
        this.jmsSelector.setText("");
        this.numberOfSamplesToAggregate.setText("");
        this.messageContent.setInitialText("");
        this.initialContextFactory.setText("");
        this.providerUrl.setText("");
        this.jmsPropertiesPanel.clearGui();
        this.jndiPropertiesPanel.clear();
    }

    public TestElement createTestElement() {
        JMSSampler sampler = new JMSSampler();
        super.configureTestElement((TestElement)sampler);
        this.transfer(sampler);
        return sampler;
    }

    private void transfer(JMSSampler element) {
        element.setQueueConnectionFactory(this.queueConnectionFactory.getText());
        element.setSendQueue(this.sendQueue.getText());
        element.setReceiveQueue(this.receiveQueue.getText());
        element.setProperty("JMSSampler.communicationStyle", this.jmsCommunicationStyle.getSelectedIndex());
        element.removeProperty("JMSSampler.isFireAndForget");
        element.setNonPersistent(this.useNonPersistentDelivery.isSelected());
        element.setUseReqMsgIdAsCorrelId(this.useReqMsgIdAsCorrelId.isSelected());
        element.setUseResMsgIdAsCorrelId(this.useResMsgIdAsCorrelId.isSelected());
        element.setTimeout(this.timeout.getText());
        element.setExpiration(this.expiration.getText());
        element.setPriority(this.priority.getText());
        element.setJMSSelector(this.jmsSelector.getText());
        element.setNumberOfSamplesToAggregate(this.numberOfSamplesToAggregate.getText());
        element.setContent(this.messageContent.getText());
        element.setInitialContextFactory(this.initialContextFactory.getText());
        element.setContextProvider(this.providerUrl.getText());
        Arguments jndiArgs = (Arguments)this.jndiPropertiesPanel.createTestElement();
        element.setJNDIProperties(jndiArgs);
        JMSProperties args = (JMSProperties)this.jmsPropertiesPanel.createTestElement();
        element.setJMSProperties(args);
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (!(element instanceof JMSSampler)) {
            return;
        }
        JMSSampler sampler = (JMSSampler)element;
        this.transfer(sampler);
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (!(el instanceof JMSSampler)) {
            return;
        }
        JMSSampler sampler = (JMSSampler)el;
        this.queueConnectionFactory.setText(sampler.getQueueConnectionFactory());
        this.sendQueue.setText(sampler.getSendQueue());
        this.receiveQueue.setText(sampler.getReceiveQueue());
        JMeterProperty oneWay = el.getProperty("JMSSampler.isFireAndForget");
        if (oneWay instanceof NullProperty) {
            this.jmsCommunicationStyle.setSelectedIndex(el.getPropertyAsInt("JMSSampler.communicationStyle"));
        } else {
            this.jmsCommunicationStyle.setSelectedIndex(((BooleanProperty)oneWay).getBooleanValue() ? JMSSampler.COMMUNICATION_STYLE.ONE_WAY.getValue() : JMSSampler.COMMUNICATION_STYLE.REQUEST_REPLY.getValue());
        }
        this.useNonPersistentDelivery.setSelected(sampler.isNonPersistent());
        this.useReqMsgIdAsCorrelId.setSelected(sampler.isUseReqMsgIdAsCorrelId());
        this.useResMsgIdAsCorrelId.setSelected(sampler.isUseResMsgIdAsCorrelId());
        this.timeout.setText(sampler.getTimeout());
        this.expiration.setText(sampler.getExpiration());
        this.priority.setText(sampler.getPriority());
        this.jmsSelector.setText(sampler.getJMSSelector());
        this.numberOfSamplesToAggregate.setText(sampler.getNumberOfSamplesToAggregate());
        this.messageContent.setInitialText(sampler.getContent());
        this.initialContextFactory.setText(sampler.getInitialContextFactory());
        this.providerUrl.setText(sampler.getContextProvider());
        this.jmsPropertiesPanel.configure((TestElement)sampler.getJMSProperties());
        this.jndiPropertiesPanel.configure((TestElement)sampler.getJNDIProperties());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel jmsQueueingPanel = new JPanel(new BorderLayout());
        jmsQueueingPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"jms_queueing")));
        JPanel qcfPanel = new JPanel(new BorderLayout(5, 0));
        qcfPanel.add((Component)this.queueConnectionFactory, "Center");
        jmsQueueingPanel.add((Component)qcfPanel, "North");
        JPanel sendQueuePanel = new JPanel(new BorderLayout(5, 0));
        sendQueuePanel.add((Component)this.sendQueue);
        jmsQueueingPanel.add((Component)sendQueuePanel, "Center");
        JPanel receiveQueuePanel = new JPanel(new BorderLayout(5, 0));
        receiveQueuePanel.add((Component)this.jmsSelector, "South");
        receiveQueuePanel.add((Component)this.numberOfSamplesToAggregate, "Center");
        receiveQueuePanel.add((Component)this.receiveQueue, "North");
        jmsQueueingPanel.add((Component)receiveQueuePanel, "South");
        JPanel messagePanel = new JPanel(new BorderLayout());
        messagePanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"jms_message_title")));
        HorizontalPanel correlationPanel = new HorizontalPanel();
        correlationPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"jms_correlation_title")));
        this.useReqMsgIdAsCorrelId = new JCheckBox(JMeterUtils.getResString((String)"jms_use_req_msgid_as_correlid"), false);
        this.useResMsgIdAsCorrelId = new JCheckBox(JMeterUtils.getResString((String)"jms_use_res_msgid_as_correlid"), false);
        correlationPanel.add(this.useReqMsgIdAsCorrelId);
        correlationPanel.add(this.useResMsgIdAsCorrelId);
        JPanel communicationStylePanel = new JPanel();
        communicationStylePanel.add((Component)this.jmsCommunicationStyle);
        JPanel messageNorthPanel = new JPanel(new BorderLayout());
        HorizontalPanel onewayPanel = new HorizontalPanel();
        onewayPanel.add(communicationStylePanel);
        onewayPanel.add((Component)correlationPanel);
        messageNorthPanel.add((Component)onewayPanel, "North");
        this.useNonPersistentDelivery = new JCheckBox(JMeterUtils.getResString((String)"jms_use_non_persistent_delivery"), false);
        HorizontalPanel timeoutPanel = new HorizontalPanel();
        timeoutPanel.add((Component)this.timeout);
        timeoutPanel.add((Component)this.expiration);
        timeoutPanel.add((Component)this.priority);
        timeoutPanel.add(this.useNonPersistentDelivery);
        messageNorthPanel.add((Component)timeoutPanel, "South");
        messagePanel.add((Component)messageNorthPanel, "North");
        JPanel messageContentPanel = new JPanel(new BorderLayout());
        messageContentPanel.add((Component)new JLabel(JMeterUtils.getResString((String)"jms_msg_content")), "North");
        messageContentPanel.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.messageContent), "Center");
        messagePanel.add((Component)messageContentPanel, "Center");
        this.jmsPropertiesPanel = new JMSPropertiesPanel();
        messagePanel.add((Component)this.jmsPropertiesPanel, "South");
        Box mainPanel = Box.createVerticalBox();
        this.add(mainPanel, "Center");
        mainPanel.add((Component)jmsQueueingPanel, "North");
        mainPanel.add((Component)messagePanel, "Center");
        JPanel jndiPanel = this.createJNDIPanel();
        mainPanel.add((Component)jndiPanel, "South");
    }

    private JPanel createJNDIPanel() {
        JPanel jndiPanel = new JPanel(new BorderLayout());
        jndiPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"jms_jndi_props")));
        JPanel contextPanel = new JPanel(new BorderLayout(10, 0));
        contextPanel.add((Component)this.initialContextFactory);
        jndiPanel.add((Component)contextPanel, "North");
        JPanel providerPanel = new JPanel(new BorderLayout(10, 0));
        providerPanel.add((Component)this.providerUrl);
        jndiPanel.add((Component)providerPanel, "South");
        this.jndiPropertiesPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"jms_jndi_props"));
        jndiPanel.add((Component)this.jndiPropertiesPanel);
        return jndiPanel;
    }

    public String getLabelResource() {
        return "jms_point_to_point";
    }
}

