/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.toolbar;

import com.github.weisj.darklaf.listener.MouseResponder;
import com.github.weisj.darklaf.ui.toolbar.DarkToolBarUIBridge;
import com.github.weisj.darklaf.ui.toolbar.DropPreviewPanel;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class DarkToolBarUI
extends DarkToolBarUIBridge {
    protected static final String KEY_PREFIX = "JToolBar.";
    public static final String KEY_USE_TOOL_BAR_BACKGROUND = "JToolBar.drag.useToolbarBackground";
    private static final Robot robot = DarkToolBarUI.createRobot();
    private final DropPreviewPanel previewPanel = new DropPreviewPanel();
    protected Color background;
    private Dimension verticalDim = new Dimension(0, 0);
    private Dimension horizontalDim = new Dimension(0, 0);
    private final Timer timer = new Timer(5, e -> this.dragTo());

    public static ComponentUI createUI(JComponent c) {
        return new DarkToolBarUI();
    }

    private static Robot createRobot() {
        try {
            return new Robot();
        }
        catch (AWTException e) {
            return null;
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.previewPanel.setToolBar(this.toolBar);
        this.dragWindow = this.createDragWindow(this.toolBar);
    }

    public RootPaneContainer getFloatingToolBar() {
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        return this.floatingToolBar;
    }

    @Override
    protected void setBorderToRollover(Component c) {
    }

    @Override
    protected void setBorderToNormal(Component c) {
    }

    @Override
    public void setFloating(boolean b, Point p) {
        if (this.toolBar.isFloatable()) {
            this.toolBar.doLayout();
            boolean visible = false;
            final Window ancestor = SwingUtilities.getWindowAncestor(this.toolBar);
            if (ancestor != null) {
                visible = ancestor.isVisible();
            }
            if (this.dragWindow != null) {
                this.stopDrag();
            }
            this.floating = b;
            if (b) {
                this.constraintBeforeFloating = this.calculateConstraint();
                if (this.propertyListener != null) {
                    UIManager.addPropertyChangeListener(this.propertyListener);
                }
                this.getFloatingToolBar().getContentPane().add((Component)this.toolBar, "Center");
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).pack();
                    ((Window)((Object)this.floatingToolBar)).setLocation(this.floatingX, this.floatingY);
                    if (visible) {
                        ((Window)((Object)this.floatingToolBar)).setVisible(true);
                    } else if (ancestor != null) {
                        ancestor.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowOpened(WindowEvent e) {
                                ((Window)((Object)DarkToolBarUI.this.floatingToolBar)).setVisible(true);
                                ancestor.removeWindowListener(this);
                            }
                        });
                    }
                }
            } else {
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(false);
                }
                this.floatingToolBar.getContentPane().remove(this.toolBar);
                String constraint = this.getDockingConstraint(this.dockingSource, p);
                if (constraint == null) {
                    constraint = "North";
                }
                this.setOrientation(this.mapConstraintToOrientation(constraint));
                this.dockingSource.add((Component)this.toolBar, constraint);
                this.updateDockingSource();
            }
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.background = UIManager.getColor("ToolBar.background");
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
    }

    @Override
    protected DarkToolBarUIBridge.DragWindow createDragWindow(JToolBar toolbar) {
        Window frame = null;
        if (this.toolBar != null) {
            Container p;
            for (p = toolbar.getParent(); p != null && !(p instanceof Window); p = p.getParent()) {
            }
            if (p != null) {
                frame = (Window)p;
            }
        }
        if (this.floatingToolBar instanceof Window) {
            frame = (Window)((Object)this.floatingToolBar);
        }
        return new DarkDragWindow(frame);
    }

    @Override
    protected boolean isBlocked(Component comp, Object constraint) {
        Container cont;
        LayoutManager lm;
        if (comp instanceof Container && (lm = (cont = (Container)comp).getLayout()) instanceof BorderLayout) {
            BorderLayout blm = (BorderLayout)lm;
            Component c = blm.getLayoutComponent(cont, constraint);
            return c != null && c != this.toolBar && c != this.previewPanel;
        }
        return false;
    }

    @Override
    protected String getDockingConstraint(Component c, Point p) {
        if (p == null) {
            return this.constraintBeforeFloating;
        }
        if (c.contains(p)) {
            if (p.y < this.horizontalDim.height && !this.isBlocked(c, "North")) {
                return "North";
            }
            if (p.y >= c.getHeight() - this.horizontalDim.height && !this.isBlocked(c, "South")) {
                return "South";
            }
            if (p.x >= c.getWidth() - this.verticalDim.width && !this.isBlocked(c, "East")) {
                return "East";
            }
            if (p.x < this.verticalDim.width && !this.isBlocked(c, "West")) {
                return "West";
            }
        }
        return null;
    }

    @Override
    protected void dragTo() {
        if (this.toolBar.isFloatable()) {
            Point offset = this.dragWindow.getOffset();
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo == null) {
                return;
            }
            Point global = pointerInfo.getLocation();
            Point dragPoint = new Point(global.x - offset.x, global.y - offset.y);
            this.ensureDockingSource();
            Point dockingPosition = this.dockingSource.getLocationOnScreen();
            Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
            if (this.canDock(this.dockingSource, comparisonPoint)) {
                String constraint = this.getDockingConstraint(this.dockingSource, comparisonPoint);
                this.setOrientation(this.mapConstraintToOrientation(constraint));
                this.dockingSource.add((Component)this.previewPanel, constraint);
            } else {
                this.setOrientation(this.mapConstraintToOrientation(this.constraintBeforeFloating));
                this.dockingSource.remove(this.previewPanel);
            }
            this.updateDockingSource();
            this.dragWindow.setLocation(dragPoint.x, dragPoint.y);
            this.startDrag();
        }
    }

    private void ensureDockingSource() {
        if (this.dockingSource == null) {
            this.dockingSource = this.toolBar.getParent();
        }
    }

    protected void updateDockingSource() {
        this.dockingSource.invalidate();
        Container dockingSourceParent = this.dockingSource.getParent();
        if (dockingSourceParent != null) {
            dockingSourceParent.validate();
        }
        this.dockingSource.repaint();
    }

    protected void startDrag() {
        DarkUIUtil.getWindow(this.getFloatingToolBar().getRootPane()).setVisible(false);
        if (!this.dragWindow.isVisible()) {
            this.dragWindow.getContentPane().add(this.toolBar);
            this.updateDockingSource();
            this.dragWindow.setVisible(true);
            SwingUtilities.invokeLater(() -> robot.mouseRelease(1024));
            int oldOrientation = this.toolBar.getOrientation();
            this.toolBar.setOrientation(1);
            this.verticalDim = this.toolBar.getPreferredSize();
            this.toolBar.setOrientation(0);
            this.horizontalDim = this.toolBar.getPreferredSize();
            this.toolBar.setOrientation(oldOrientation);
            this.timer.start();
        }
    }

    @Override
    protected void floatAt() {
        if (this.toolBar.isFloatable()) {
            try {
                Point offset = this.dragWindow.getOffset();
                Point global = MouseInfo.getPointerInfo().getLocation();
                this.setFloatingLocation(global.x - offset.x, global.y - offset.y);
                if (this.dockingSource != null) {
                    Point dockingPosition = this.dockingSource.getLocationOnScreen();
                    Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
                    if (this.canDock(this.dockingSource, comparisonPoint)) {
                        this.setFloating(false, comparisonPoint);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dockingSource.remove(this.previewPanel);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected void stopDrag() {
        this.dragWindow.setVisible(false);
        this.timer.stop();
    }

    @Override
    protected void paintDragWindow(Graphics g) {
        g.setColor(this.dragWindow.getBackground());
        int w = this.dragWindow.getWidth();
        int h = this.dragWindow.getHeight();
        g.fillRect(0, 0, w, h);
        g.setColor(this.dragWindow.getBorderColor());
        g.fillRect(0, 0, w, 1);
        g.fillRect(0, 0, 1, h);
        g.fillRect(w - 1, 0, 1, h);
        g.fillRect(0, h - 1, w, 1);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        g.setColor(this.background);
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
    }

    protected class DarkDragWindow
    extends DarkToolBarUIBridge.DragWindow {
        protected DarkDragWindow(Window w) {
            super(DarkToolBarUI.this, w);
            this.setLayout(new BorderLayout());
            this.setBackground(DarkToolBarUI.this.toolBar.getBackground());
            JPanel glassPane = new JPanel();
            glassPane.setOpaque(false);
            glassPane.addMouseListener(new MouseResponder(e -> {
                e.consume();
                if (e.getID() == 502) {
                    DarkToolBarUI.this.floatAt();
                }
            }));
            this.setGlassPane(glassPane);
            glassPane.setVisible(true);
        }

        @Override
        public void setOrientation(int o) {
            super.setOrientation(o);
            Dimension size = DarkToolBarUI.this.toolBar.getPreferredSize();
            size.width += 2;
            size.height += 2;
            this.setSize(size);
            this.doLayout();
        }

        @Override
        public Point getOffset() {
            return new Point(this.getWidth() / 2, this.getHeight() / 2);
        }
    }
}

