/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.togglebutton;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.GraphicsUtil;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.button.DarkButtonUI;
import com.github.weisj.darklaf.ui.togglebutton.DarkToggleButtonListener;
import com.github.weisj.darklaf.ui.togglebutton.ToggleButtonConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import sun.swing.SwingUtilities2;

public class DarkToggleButtonUI
extends DarkButtonUI
implements ToggleButtonConstants {
    private static final Rectangle rect = new Rectangle();
    protected Dimension sliderSize;
    protected Color background;
    protected Color backgroundInactive;
    protected Color focusBorderColor;
    protected Color borderColor;
    protected Color inactiveBorderColor;
    protected Color sliderColor;
    protected Color inactiveSliderColor;
    protected Color sliderBorderColor;
    protected Color inactiveSliderBorderColor;
    protected Color selectedForeground;

    public static ComponentUI createUI(JComponent c) {
        return new DarkToggleButtonUI();
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.sliderSize = UIManager.getDimension("ToggleButton.sliderSize");
        this.background = UIManager.getColor("ToggleButton.activeFillColor");
        this.backgroundInactive = UIManager.getColor("ToggleButton.inactiveFillColor");
        this.focusBorderColor = UIManager.getColor("ToggleButton.focusedSliderBorderColor");
        this.borderColor = UIManager.getColor("ToggleButton.sliderBorderColor");
        this.inactiveBorderColor = UIManager.getColor("ToggleButton.disabledSliderBorderColor");
        this.sliderColor = UIManager.getColor("ToggleButton.sliderKnobFillColor");
        this.inactiveSliderColor = UIManager.getColor("ToggleButton.disabledSliderKnobFillColor");
        this.sliderBorderColor = UIManager.getColor("ToggleButton.sliderKnobBorderColor");
        this.inactiveSliderBorderColor = UIManager.getColor("ToggleButton.disabledSliderKnobBorderColor");
        this.selectedForeground = UIManager.getColor("ToggleButton.selectedForeground");
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new DarkToggleButtonListener(b, this);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (ToggleButtonConstants.isSlider(c)) {
            GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
            AbstractButton b = (AbstractButton)c;
            String text = this.layout(b, c, SwingUtilities2.getFontMetrics((JComponent)b, g), b.getWidth(), b.getHeight());
            this.paintSlider((Graphics2D)g, b);
            this.paintIcon(g, b, c);
            this.paintText(g, b, text);
            config.restore();
        } else {
            super.paint(g, c);
        }
    }

    private void paintSlider(Graphics2D g, AbstractButton c) {
        Rectangle bounds = this.getSliderBounds(c);
        g.translate(bounds.x, bounds.y);
        if (c.hasFocus()) {
            g.translate(-this.borderSize, -this.borderSize);
            PaintUtil.paintFocusBorder(g, bounds.width + 2 * this.borderSize, bounds.height + 2 * this.borderSize, bounds.height, this.borderSize);
            g.translate(this.borderSize, this.borderSize);
        }
        g.setColor(this.getBackgroundColor(c));
        PaintUtil.fillRoundRect(g, 0.0f, 0.0f, bounds.width, bounds.height, bounds.height);
        g.setColor(this.getToggleBorderColor(c));
        PaintUtil.paintLineBorder(g, 0.0f, 0.0f, bounds.width, bounds.height, bounds.height);
        int size = bounds.height - 2;
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        if (c.isSelected()) {
            g.setColor(this.getSliderColor(c));
            PaintUtil.fillRoundRect(g, bounds.width - size - 1, 1.0f, size, size, size);
            g.setColor(this.getSliderBorderColor(c));
            PaintUtil.paintLineBorder(g, bounds.width - size - 1, 1.0f, size, size, size);
        } else {
            g.setColor(this.getSliderColor(c));
            PaintUtil.fillRoundRect(g, 1.0f, 1.0f, size, size, size);
            g.setColor(this.getSliderBorderColor(c));
            PaintUtil.paintLineBorder(g, 1.0f, 1.0f, size, size, size);
        }
        g.translate(-bounds.x, -bounds.y);
        config.restore();
    }

    @Override
    protected Color getForeground(AbstractButton button) {
        if (button.isSelected() && !ToggleButtonConstants.isSlider(button) && button.getForeground() instanceof UIResource) {
            return this.selectedForeground;
        }
        return super.getForeground(button);
    }

    @Override
    protected Color getBackgroundColor(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        boolean rollOver = b.isRolloverEnabled() && b.getModel().isRollover();
        boolean clicked = b.getModel().isArmed();
        boolean isSelected = b.isSelected();
        if (c.isEnabled()) {
            if (isSelected) {
                return this.background;
            }
            if (clicked) {
                return this.clickBackground;
            }
            if (rollOver) {
                return this.hoverBackground;
            }
            if (c instanceof JToggleButton) {
                return this.backgroundInactive;
            }
            return super.getBackgroundColor(c);
        }
        return this.inactiveBackground;
    }

    protected Color getToggleBorderColor(AbstractButton b) {
        if (b.hasFocus()) {
            return this.focusBorderColor;
        }
        return b.isEnabled() ? this.borderColor : this.inactiveBorderColor;
    }

    protected Color getSliderColor(AbstractButton b) {
        return b.isEnabled() ? this.sliderColor : this.inactiveSliderColor;
    }

    protected Color getSliderBorderColor(AbstractButton b) {
        return b.isEnabled() ? this.sliderBorderColor : this.inactiveSliderBorderColor;
    }

    protected Rectangle getSliderBounds(JComponent c) {
        int x = this.borderSize;
        int y = (c.getHeight() - this.sliderSize.height) / 2;
        DarkToggleButtonUI.rect.x = x;
        DarkToggleButtonUI.rect.y = y;
        DarkToggleButtonUI.rect.width = this.sliderSize.width;
        DarkToggleButtonUI.rect.height = this.sliderSize.height;
        if (!c.getComponentOrientation().isLeftToRight()) {
            DarkToggleButtonUI.rect.x = c.getWidth() - DarkToggleButtonUI.rect.x - DarkToggleButtonUI.rect.width;
        }
        return rect;
    }

    @Override
    protected String layout(AbstractButton b, JComponent c, FontMetrics fm, int width, int height) {
        if (ToggleButtonConstants.isSlider(c)) {
            return this.layoutSlider(b, c, fm, width, height);
        }
        return super.layout(b, c, fm, width, height);
    }

    private String layoutSlider(AbstractButton b, JComponent c, FontMetrics fm, int width, int height) {
        Insets i = b.getInsets();
        Rectangle bounds = this.getSliderBounds(c);
        DarkToggleButtonUI.viewRect.x = bounds.width + 2 * this.borderSize;
        DarkToggleButtonUI.viewRect.width = width - (i.right + DarkToggleButtonUI.viewRect.x);
        DarkToggleButtonUI.viewRect.y = i.top;
        DarkToggleButtonUI.viewRect.height = height - (i.bottom + DarkToggleButtonUI.viewRect.y);
        if (!b.getComponentOrientation().isLeftToRight()) {
            DarkToggleButtonUI.viewRect.x = bounds.x - DarkToggleButtonUI.viewRect.width - this.borderSize;
        }
        DarkToggleButtonUI.textRect.height = 0;
        DarkToggleButtonUI.textRect.width = 0;
        DarkToggleButtonUI.textRect.y = 0;
        DarkToggleButtonUI.textRect.x = 0;
        DarkToggleButtonUI.iconRect.height = 0;
        DarkToggleButtonUI.iconRect.width = 0;
        DarkToggleButtonUI.iconRect.y = 0;
        DarkToggleButtonUI.iconRect.x = 0;
        return SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        if (ToggleButtonConstants.isSlider(c)) {
            d.width += this.sliderSize.width + this.borderSize;
        }
        return d;
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (!ToggleButtonConstants.isSlider(c)) {
            return super.contains(c, x, y);
        }
        if (x < 0 || x > c.getWidth() || y < 0 || y > c.getHeight()) {
            return false;
        }
        Rectangle bounds = this.getSliderBounds(c);
        return new RoundRectangle2D.Float(bounds.x, bounds.y, bounds.width, bounds.height, bounds.height, bounds.height).contains(x, y);
    }
}

