/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.listener.MouseClickListener;
import com.github.weisj.darklaf.listener.PopupMenuAdapter;
import com.github.weisj.darklaf.ui.text.DarkCaret;
import com.github.weisj.darklaf.ui.text.DarkTextFieldUIBridge;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class DarkTextFieldUI
extends DarkTextFieldUIBridge
implements PropertyChangeListener,
MouseClickListener {
    protected static final String KEY_PREFIX = "JTextField.";
    public static final String KEY_VARIANT = "JTextField.variant";
    public static final String KEY_SHOW_CLEAR = "JTextField.showClear";
    public static final String KEY_KEEP_SELECTION_ON_FOCUS_LOST = "JTextField.keepSelectionOnFocusLost";
    public static final String KEY_FIND_POPUP = "JTextField.Search.FindPopup";
    public static final String VARIANT_SEARCH = "search";
    protected static Icon clear;
    protected static Icon clearHover;
    protected static Icon search;
    protected static Icon searchDisabled;
    protected static Icon searchWithHistory;
    protected static Icon searchWithHistoryDisabled;
    protected int arcSize;
    protected int searchArcSize;
    protected int borderSize;
    protected Color background;
    protected Color inactiveBackground;
    private long lastSearchEvent;
    private final PopupMenuListener searchPopupListener = new PopupMenuAdapter(){

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            DarkTextFieldUI.this.lastSearchEvent = System.currentTimeMillis();
        }
    };
    private boolean clearHovered;
    private final MouseMotionListener mouseMotionListener = e -> this.updateCursor(e.getPoint());
    private final KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            SwingUtilities.invokeLater(() -> {
                Point p = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(p, DarkTextFieldUI.this.getComponent());
                DarkTextFieldUI.this.updateCursor(p);
            });
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarkTextFieldUI();
    }

    protected static Icon getClearIcon(boolean clearHovered) {
        return clearHovered ? clearHover : clear;
    }

    protected Rectangle getTextRect(JTextComponent c) {
        Insets i = c.getInsets();
        Dimension dim = c.getSize();
        Rectangle r = new Rectangle(i.left, i.top, dim.width - i.left - i.right, dim.height - i.top - i.bottom);
        this.adjustTextRect(c, r);
        return r;
    }

    protected void adjustTextRect(JTextComponent c, Rectangle r) {
        Point p;
        int end = r.x + r.width;
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        if (this.doPaintLeftIcon(c)) {
            p = this.getSearchIconCoord();
            if (ltr) {
                r.x = p.x + DarkTextFieldUI.getSearchIcon(c).getIconWidth();
            } else {
                end = p.x;
            }
        }
        if (this.doPaintRightIcon(c)) {
            p = this.getClearIconCoord();
            if (ltr) {
                end = p.x;
            } else {
                r.x = p.x + DarkTextFieldUI.getClearIcon(false).getIconWidth();
            }
        }
        r.width = end - r.x;
    }

    public static boolean isOver(Point p, Icon icon, Point e) {
        return new Rectangle(p.x, p.y, icon.getIconWidth(), icon.getIconHeight()).contains(e);
    }

    protected void updateCursor(Point p) {
        Rectangle textRect;
        ClickAction action = this.getActionUnder(p);
        boolean oldClear = this.clearHovered;
        boolean bl = this.clearHovered = action == ClickAction.RIGHT_ACTION;
        if (oldClear != this.clearHovered) {
            this.editor.repaint();
        }
        if ((textRect = this.getTextRect(this.getComponent())).contains(p)) {
            this.getComponent().setCursor(Cursor.getPredefinedCursor(2));
        } else {
            Cursor cursor = action == ClickAction.NONE ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12);
            this.getComponent().setCursor(cursor);
        }
    }

    protected ClickAction getActionUnder(Point p) {
        JTextComponent c = this.getComponent();
        if (!c.isEnabled()) {
            return ClickAction.NONE;
        }
        if (c.isEditable() && DarkTextFieldUI.isOver(this.getClearIconCoord(), DarkTextFieldUI.getClearIcon(this.clearHovered), p) && DarkTextFieldUI.showClearIcon(c)) {
            return ClickAction.RIGHT_ACTION;
        }
        if (DarkTextFieldUI.isOver(this.getSearchIconCoord(), DarkTextFieldUI.getSearchIcon(c), p) && DarkTextFieldUI.isSearchField(c)) {
            return ClickAction.LEFT_ACTION;
        }
        return ClickAction.NONE;
    }

    private static JPopupMenu getSearchPopup(JComponent c) {
        return (JPopupMenu)PropertyUtil.getObject((JComponent)c, (String)KEY_FIND_POPUP, JPopupMenu.class);
    }

    protected Point getSearchIconCoord() {
        Rectangle r = this.getDrawingRect(this.getComponent());
        int w = DarkTextFieldUI.getSearchIcon(this.getComponent()).getIconWidth();
        return DarkUIUtil.adjustForOrientation(new Point(r.x + this.borderSize, r.y + (r.height - w) / 2), w, this.editor);
    }

    protected static Icon getSearchIcon(Component c) {
        boolean enabled = c.isEnabled();
        return DarkTextFieldUI.isSearchFieldWithHistoryPopup(c) ? (enabled ? searchWithHistory : searchWithHistoryDisabled) : (enabled ? search : searchDisabled);
    }

    public static boolean isSearchFieldWithHistoryPopup(Component c) {
        return DarkTextFieldUI.isSearchField(c) && DarkTextFieldUI.getSearchPopup((JComponent)c) != null;
    }

    public static boolean isSearchField(Component c) {
        return PropertyUtil.isPropertyEqual((Component)c, (String)KEY_VARIANT, (Object)VARIANT_SEARCH);
    }

    public static boolean showClearIcon(Component c) {
        return PropertyUtil.getBooleanProperty((Component)c, (String)KEY_SHOW_CLEAR);
    }

    @Override
    protected void paintSafely(Graphics g) {
        GraphicsContext context = new GraphicsContext(g);
        super.paintSafely(g);
        context.restore();
        this.paintIcons(g);
    }

    protected void paintIcons(Graphics g) {
        JTextComponent c = this.getComponent();
        if (this.doPaintLeftIcon(c)) {
            this.paintLeftIcon(g);
        }
        if (this.doPaintRightIcon(c)) {
            this.paintRightIcon(g);
        }
    }

    protected boolean doPaintLeftIcon(JTextComponent c) {
        return DarkTextFieldUI.isSearchField(c);
    }

    protected boolean doPaintRightIcon(JTextComponent c) {
        return c.getText().length() > 0 && DarkTextFieldUI.showClearIcon(c);
    }

    protected void paintRightIcon(Graphics g) {
        this.paintClearIcon(g);
    }

    protected void paintLeftIcon(Graphics g) {
        this.paintSearchIcon(g);
    }

    @Override
    public Rectangle getDrawingRect(JTextComponent c) {
        int w = this.borderSize;
        return new Rectangle(w, w, c.getWidth() - 2 * w, c.getHeight() - 2 * w);
    }

    @Override
    protected int getArcSize(JComponent c) {
        return DarkTextFieldUI.isSearchField(c) ? this.searchArcSize : this.arcSize;
    }

    private void paintClearIcon(Graphics g) {
        Point p = this.getClearIconCoord();
        DarkTextFieldUI.getClearIcon(this.clearHovered || !this.editor.isEditable() || !this.editor.isEnabled()).paintIcon(null, g, p.x, p.y);
    }

    private void paintSearchIcon(Graphics g) {
        Point p = this.getSearchIconCoord();
        DarkTextFieldUI.getSearchIcon(this.editor).paintIcon(null, g, p.x, p.y);
    }

    protected Point getClearIconCoord() {
        Rectangle r = this.getDrawingRect(this.getComponent());
        int w = DarkTextFieldUI.getClearIcon(this.clearHovered).getIconWidth();
        return DarkUIUtil.adjustForOrientation(new Point(r.x + r.width - w - this.borderSize, r.y + (r.height - w) / 2), w, this.editor);
    }

    protected void showSearchPopup() {
        JPopupMenu menu;
        if ((this.lastSearchEvent == 0L || System.currentTimeMillis() - this.lastSearchEvent > 250L) && (menu = DarkTextFieldUI.getSearchPopup(this.getComponent())) != null) {
            menu.show(this.getComponent(), this.getSearchIconCoord().x, this.getComponent().getHeight());
        }
    }

    @Override
    protected DarkCaret.CaretStyle getDefaultCaretStyle() {
        return DarkCaret.CaretStyle.VERTICAL_LINE_STYLE;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.editor.putClientProperty(KEY_KEEP_SELECTION_ON_FOCUS_LOST, UIManager.getBoolean("TextField.keepSelectionOnFocusLost"));
        this.arcSize = UIManager.getInt("TextField.arc");
        this.borderSize = UIManager.getInt("TextField.borderThickness");
        this.searchArcSize = UIManager.getInt("TextField.searchArc");
        this.background = UIManager.getColor("TextField.background");
        this.inactiveBackground = UIManager.getColor("TextField.disabledBackground");
        clearHover = UIManager.getIcon("TextField.search.clearHover.icon");
        clear = UIManager.getIcon("TextField.search.clear.icon");
        searchWithHistory = UIManager.getIcon("TextField.search.searchWithHistory.icon");
        searchWithHistoryDisabled = UIManager.getIcon("TextField.search.searchWithHistory.disabled.icon");
        search = UIManager.getIcon("TextField.search.search.icon");
        searchDisabled = UIManager.getIcon("TextField.search.search.disabled.icon");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String key = evt.getPropertyName();
        if (KEY_FIND_POPUP.equals(key)) {
            Object oldVal = evt.getOldValue();
            Object newVal = evt.getNewValue();
            if (oldVal instanceof JPopupMenu) {
                ((JPopupMenu)oldVal).removePopupMenuListener(this.searchPopupListener);
            }
            if (newVal instanceof JPopupMenu) {
                ((JPopupMenu)newVal).addPopupMenuListener(this.searchPopupListener);
            }
        } else if (KEY_VARIANT.equals(key)) {
            this.editor.putClientProperty(KEY_SHOW_CLEAR, DarkTextFieldUI.isSearchField(this.editor));
            this.layoutChanged();
        } else if (KEY_SHOW_CLEAR.equals(key)) {
            this.layoutChanged();
        }
    }

    protected void layoutChanged() {
        Container parent = this.editor.getParent();
        if (parent instanceof JComponent) {
            ((Component)parent).doLayout();
        }
        this.editor.repaint();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        JTextComponent c = this.getComponent();
        c.addMouseListener(this);
        c.addMouseMotionListener(this.mouseMotionListener);
        c.addKeyListener(this.keyListener);
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent c = this.getComponent();
        c.removeMouseListener(this);
        c.removeMouseMotionListener(this.mouseMotionListener);
        c.removeKeyListener(this.keyListener);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        ClickAction actionUnder = this.getActionUnder(e.getPoint());
        if (actionUnder == ClickAction.RIGHT_ACTION) {
            this.getComponent().setText("");
        } else if (actionUnder == ClickAction.LEFT_ACTION) {
            this.showSearchPopup();
        }
    }

    protected static enum ClickAction {
        RIGHT_ACTION,
        LEFT_ACTION,
        NONE;

    }
}

