/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.table.DarkColorTableCellRendererEditor;
import com.github.weisj.darklaf.ui.table.DarkTableCellEditor;
import com.github.weisj.darklaf.ui.table.DarkTableCellRenderer;
import com.github.weisj.darklaf.ui.table.DarkTableUIBridge;
import com.github.weisj.darklaf.ui.table.TableUIBridge;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.swing.SwingUtilities2;

public class DarkTableUI
extends DarkTableUIBridge
implements FocusListener {
    public static final String KEY_IS_TABLE_EDITOR = "JComponent.isTableEditor";
    public static final String KEY_IS_TABLE_RENDERER = "JComponent.isTableRenderer";
    protected static final String KEY_PREFIX = "JTable.";
    public static final String KEY_ALTERNATE_ROW_COLOR = "JTable.alternateRowColor";
    public static final String KEY_RENDER_BOOLEAN_AS_CHECKBOX = "JTable.renderBooleanAsCheckBox";
    public static final String KEY_BOOLEAN_RENDER_TYPE = "JTable.booleanRenderType";
    public static final String KEY_FULL_ROW_FOCUS_BORDER = "JTable.rowFocusBorder";
    public static final String KEY_FORCE_LEFT_BORDER = "JTable.forcePaintLeft";
    public static final String KEY_FORCE_RIGHT_BORDER = "JTable.forcePaintRight";
    public static final String KEY_FILE_CHOOSER_PARENT = "JTable.fileChooserParent";
    public static final String KEY_FILENAME_COLUMN_INDEX = "JTable.fileNameColumnIndex";
    public static final String KEY_HORIZONTAL_LINES = "showHorizontalLines";
    public static final String KEY_VERTICAL_LINES = "showVerticalLines";
    public static final String KEY_IS_FILE_LIST = "Table.isFileList";
    public static final String KEY_IS_PRINT_MODE = "Table.printMode";
    public static final String RENDER_TYPE_CHECKBOX = "checkBox";
    public static final String RENDER_TYPE_RADIOBUTTON = "radioButton";
    private static final int ROW_HEIGHT_FALLBACK = 22;
    private final PropertyChangeListener propertyChangeListener = e -> {
        String key = e.getPropertyName();
        if (KEY_HORIZONTAL_LINES.equals(key)) {
            boolean b = Boolean.TRUE.equals(e.getNewValue());
            this.table.setRowMargin(b ? 1 : 0);
        } else if (KEY_VERTICAL_LINES.equals(key)) {
            boolean b = Boolean.TRUE.equals(e.getNewValue());
            this.table.getColumnModel().setColumnMargin(b ? 1 : 0);
        } else if ("ancestor".equals(key)) {
            Container newUnwrapped;
            Object oldVal = e.getOldValue();
            Object newVal = e.getNewValue();
            if (oldVal instanceof Component) {
                Container oldUnwrapped = DarkUIUtil.getUnwrappedParent((Component)oldVal);
                LookAndFeel.uninstallBorder((JComponent)oldUnwrapped);
            }
            if (newVal instanceof Component && (newUnwrapped = DarkUIUtil.getUnwrappedParent((Component)newVal)) instanceof JScrollPane) {
                LookAndFeel.installBorder((JComponent)newUnwrapped, "Table.scrollPaneBorder");
            }
            this.checkFocus();
        } else if ("componentOrientation".equals(key)) {
            this.table.doLayout();
            this.table.repaint();
        } else if (KEY_ALTERNATE_ROW_COLOR.equals(key) || KEY_RENDER_BOOLEAN_AS_CHECKBOX.equals(key) || KEY_BOOLEAN_RENDER_TYPE.equals(key)) {
            this.table.repaint();
        }
    };
    protected Color selectionBackground;
    protected Color selectionFocusBackground;
    protected Color borderColor;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTableUI();
    }

    @Override
    protected boolean pointOutsidePrefSize(int row, int column, Point p) {
        return false;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.table.setSurrendersFocusOnKeystroke(true);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.table.addFocusListener(this);
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected TableUIBridge.Handler getHandler() {
        if (this.handler == null) {
            this.handler = new DarkHandler();
        }
        return this.handler;
    }

    @Override
    public void focusGained(FocusEvent e) {
        Color bg = this.table.getSelectionBackground();
        if (bg instanceof UIResource) {
            this.table.setSelectionBackground(this.selectionFocusBackground);
        }
        this.table.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        Color bg = this.table.getSelectionBackground();
        if (bg instanceof UIResource) {
            if (this.table.isEditing()) {
                this.table.setSelectionBackground(this.table.getBackground());
            } else {
                this.table.setSelectionBackground(this.selectionBackground);
            }
        }
        this.table.repaint();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.table.removeFocusListener(this);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        Container oldUnwrapped = DarkUIUtil.getUnwrappedParent(this.table.getParent());
        LookAndFeel.uninstallBorder((JComponent)oldUnwrapped);
    }

    protected static void setupRendererComponents(JTable table) {
        DarkTableCellRenderer cellRenderer = new DarkTableCellRenderer();
        DarkTableCellEditor cellEditor = new DarkTableCellEditor();
        DarkColorTableCellRendererEditor colorRendererEditor = new DarkColorTableCellRendererEditor();
        table.setDefaultRenderer(Object.class, cellRenderer);
        table.setDefaultRenderer(String.class, cellRenderer);
        table.setDefaultRenderer(Integer.class, cellRenderer);
        table.setDefaultRenderer(Double.class, cellRenderer);
        table.setDefaultRenderer(Float.class, cellRenderer);
        table.setDefaultRenderer(Boolean.class, cellRenderer);
        table.setDefaultRenderer(Color.class, colorRendererEditor);
        table.setDefaultEditor(Object.class, cellEditor);
        table.setDefaultEditor(String.class, cellEditor);
        table.setDefaultEditor(Integer.class, cellEditor);
        table.setDefaultEditor(Double.class, cellEditor);
        table.setDefaultEditor(Float.class, cellEditor);
        table.setDefaultEditor(Boolean.class, cellEditor);
        table.setDefaultEditor(Color.class, colorRendererEditor);
    }

    protected Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        int rowHeight = UIManager.getInt("Table.rowHeight");
        if (rowHeight > 0) {
            LookAndFeel.installProperty(this.table, "rowHeight", 22);
        }
        this.table.setDefaultEditor(Object.class, new DarkTableCellEditor());
        this.table.putClientProperty(KEY_RENDER_BOOLEAN_AS_CHECKBOX, UIManager.getBoolean("Table.renderBooleanAsCheckBox"));
        this.table.putClientProperty(KEY_BOOLEAN_RENDER_TYPE, UIManager.getString("Table.booleanRenderType"));
        this.table.putClientProperty(KEY_ALTERNATE_ROW_COLOR, UIManager.getBoolean("Table.alternateRowColor"));
        DarkTableUI.setupRendererComponents(this.table);
        this.borderColor = UIManager.getColor("TableHeader.borderColor");
        this.selectionFocusBackground = UIManager.getColor("Table.focusSelectionBackground");
        this.selectionBackground = UIManager.getColor("Table.selectionNoFocusBackground");
    }

    protected void checkFocus() {
        boolean focus = DarkUIUtil.hasFocus(this.table);
        if (focus) {
            this.focusGained(null);
        } else {
            this.focusLost(null);
        }
    }

    @Override
    protected void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        block12: {
            g.setColor(this.table.getGridColor());
            Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
            Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
            Rectangle damagedArea = minCell.union(maxCell);
            JTableHeader header = this.table.getTableHeader();
            int draggedIndex = -1;
            if (header != null) {
                draggedIndex = this.viewIndexForColumn(header.getDraggedColumn());
            }
            if (this.table.getShowHorizontalLines()) {
                int tableWidth = damagedArea.x + damagedArea.width;
                if (this.table.getComponentOrientation().isLeftToRight()) {
                    if (draggedIndex >= 0 && draggedIndex == cMax) {
                        --tableWidth;
                    }
                } else if (draggedIndex >= 0 && draggedIndex == cMin) {
                    --tableWidth;
                }
                int y = damagedArea.y;
                for (int row = rMin; row <= rMax; ++row) {
                    SwingUtilities2.drawHLine(g, damagedArea.x, tableWidth - 1, (y += this.table.getRowHeight(row)) - 1);
                }
            }
            boolean scrollPaneRtl = this.isScrollPaneRtl();
            boolean scrollVisible = this.scrollBarVisible();
            if (!this.table.getShowVerticalLines()) break block12;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = this.getPreferredSize((JComponent)this.table).height;
            boolean ltr = this.table.getComponentOrientation().isLeftToRight();
            int x = damagedArea.x;
            if (scrollPaneRtl && this.scrollBarVisible()) {
                SwingUtilities2.drawVLine(g, x, 0, tableHeight - 1);
            }
            if (ltr) {
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    x += w;
                    if (!this.showVerticalLine(true, scrollVisible, !scrollPaneRtl, column, draggedIndex, cMin, cMax)) continue;
                    SwingUtilities2.drawVLine(g, x - 1, 0, tableHeight - 1);
                }
            } else {
                for (int column = cMax; column >= cMin; --column) {
                    int w = cm.getColumn(column).getWidth();
                    x += w;
                    if (!this.showVerticalLine(false, scrollVisible, !scrollPaneRtl, column, draggedIndex, cMin, cMax)) continue;
                    SwingUtilities2.drawVLine(g, x - 1, 0, tableHeight - 1);
                }
            }
        }
    }

    protected boolean isScrollPaneRtl() {
        if (!this.isInScrollPane()) {
            return false;
        }
        Container comp = DarkUIUtil.getUnwrappedParent(this.table).getParent();
        return !comp.getComponentOrientation().isLeftToRight();
    }

    protected boolean scrollBarVisible() {
        JScrollPane comp = DarkUIUtil.getParentOfType(JScrollPane.class, this.table);
        return comp != null && comp.getVerticalScrollBar().isVisible() && DarkUIUtil.getParentOfType(OverlayScrollPane.class, this.table) == null;
    }

    protected boolean showVerticalLine(boolean ltr, boolean scrollVisible, boolean scrollLtR, int column, int draggedIndex, int cMin, int cMax) {
        boolean isDragged;
        JTableHeader header = this.table.getTableHeader();
        int dist = header != null ? DarkTableUI.adjustDistance(header.getDraggedDistance(), this.table.getCellRect(0, draggedIndex, true), this.table) : 0;
        boolean bl = isDragged = column == draggedIndex && dist != 0;
        if (!scrollVisible) {
            if (ltr) {
                return column != cMax;
            }
            return column != cMin;
        }
        if (ltr) {
            if (scrollLtR) {
                return column != cMax || !isDragged;
            }
            return column != cMax;
        }
        if (scrollLtR) {
            return column != cMin || !isDragged;
        }
        return column != cMin;
    }

    protected boolean isInScrollPane() {
        Container comp = DarkUIUtil.getUnwrappedParent(this.table);
        if (comp != null) {
            comp = comp.getParent();
        }
        return comp instanceof JScrollPane;
    }

    @Override
    protected void paintDraggedArea(Graphics g, int rMin, int rMax, int cMin, int cMax, TableColumn draggedColumn, int distance) {
        JScrollPane par;
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        int dist = DarkTableUI.adjustDistance(distance, vacatedColumnRect, this.table);
        Container parent = this.table.getParent();
        if (this.isInScrollPane() && (par = DarkUIUtil.getParentOfType(JScrollPane.class, this.table)) != null && par.getParent() != null) {
            parent = par.getParent();
        }
        int tableHeight = this.getPreferredSize((JComponent)this.table).height;
        g.setColor(parent.getBackground());
        g.fillRect(vacatedColumnRect.x, 0, vacatedColumnRect.width - 1, tableHeight);
        vacatedColumnRect.x += dist;
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, 0, vacatedColumnRect.width, tableHeight);
        if (this.table.getShowVerticalLines()) {
            boolean onRightEdge;
            boolean onLeftEdge;
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = 0;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + tableHeight;
            boolean bl = ltr ? draggedColumnIndex == cMin : (onLeftEdge = draggedColumnIndex == cMax);
            boolean bl2 = ltr ? draggedColumnIndex == cMax : (onRightEdge = draggedColumnIndex == cMin);
            if (this.scrollBarVisible()) {
                if (this.isScrollPaneRtl()) {
                    onLeftEdge = false;
                } else {
                    onRightEdge = false;
                }
            }
            if (dist != 0 || !onLeftEdge) {
                if (draggedColumnIndex == cMin && this.scrollBarVisible() && this.isScrollPaneRtl()) {
                    ++x1;
                }
                g.fillRect(x1 - 1, y1, 1, y2 - y1);
            }
            if (dist != 0 || !onRightEdge) {
                g.fillRect(x2, y1, 1, y2 - y1);
            }
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += dist;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width;
            int y2 = y1 + rcr.height - 1;
            g.fillRect(x1, y2, x2 - x1, 1);
        }
    }

    public static boolean ignoreKeyCodeOnEdit(KeyEvent event, JTable table) {
        if (event != null) {
            int keyCode = event.getKeyCode();
            switch (keyCode) {
                case 12: 
                case 20: 
                case 27: 
                case 36: 
                case 144: 
                case 145: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 524: 
                case 525: 
                case 65406: {
                    return true;
                }
            }
            if (table == null) {
                return false;
            }
            KeyStroke stroke = KeyStroke.getKeyStroke(event.getExtendedKeyCode(), event.getModifiersEx());
            String actionName = String.valueOf(table.getInputMap(1).get(stroke));
            if ("null".equals(actionName)) {
                actionName = null;
            }
            String cutActionName = String.valueOf(TransferHandler.getCutAction().getValue("Name"));
            String copyActionName = String.valueOf(TransferHandler.getCopyAction().getValue("Name"));
            return Objects.equals(actionName, copyActionName) || Objects.equals(actionName, cutActionName);
        }
        return false;
    }

    @Override
    protected void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        Rectangle bounds = this.table.getVisibleRect();
        Point upperLeft = bounds.getLocation();
        Point lowerRight = new Point(upperLeft.x + bounds.width - 1, upperLeft.y + bounds.height - 1);
        int cMin = this.table.columnAtPoint(upperLeft);
        int cMax = this.table.columnAtPoint(lowerRight);
        boolean scrollLtR = !this.isScrollPaneRtl();
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        boolean isEditorCell = this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column;
        JTableHeader header = this.table.getTableHeader();
        int draggedIndex = header != null ? this.viewIndexForColumn(header.getDraggedColumn()) : -1;
        int dist = header != null ? DarkTableUI.adjustDistance(header.getDraggedDistance(), this.table.getCellRect(row, draggedIndex, true), this.table) : 0;
        boolean isDragged = column == draggedIndex && dist != 0;
        Rectangle rectWithSpacing = this.table.getCellRect(row, cMin, true);
        Rectangle r = new Rectangle(cellRect);
        r.y = rectWithSpacing.y;
        r.height = rectWithSpacing.height;
        if (this.table.getShowHorizontalLines()) {
            --r.height;
        }
        if (!this.scrollBarVisible()) {
            if (ltr) {
                if (column == cMax && !isDragged) {
                    ++r.width;
                }
            } else if (column == cMin && !isDragged) {
                ++r.width;
            }
        } else if (!scrollLtR) {
            if (ltr) {
                if (column == cMax && !isDragged) {
                    ++r.width;
                }
                if (column == cMin && !isDragged) {
                    --r.width;
                    ++r.x;
                }
            } else {
                if (column == cMin && !isDragged) {
                    ++r.width;
                }
                if (column == cMax && !isDragged) {
                    --r.width;
                    ++r.x;
                }
            }
        }
        if (isEditorCell && !this.table.getShowVerticalLines()) {
            if (column > cMin) {
                --r.x;
            }
            if (column > cMin && column < cMax) {
                ++r.width;
            }
        }
        if (isEditorCell) {
            Component component = this.table.getEditorComponent();
            component.setBounds(r);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            CellUtil.setSelectedFlag(component, this.table.isCellSelected(row, column));
            this.rendererPane.paintComponent(g, component, this.table, r.x, r.y, r.width, r.height, true);
        }
    }

    protected static int adjustDistance(int distance, Rectangle rect, JTable comp) {
        int dist = distance;
        int min = 0;
        int max = comp.getX() + comp.getWidth();
        if (rect.x + dist <= min) {
            dist = min - rect.x;
        }
        if (rect.x + rect.width + dist >= max) {
            dist = max - rect.x - rect.width;
        }
        return dist;
    }

    protected class DarkHandler
    extends TableUIBridge.Handler {
        protected int lastIndex;

        protected DarkHandler() {
            super(DarkTableUI.this);
            this.lastIndex = -1;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (DarkTableUI.this.isFileList && SwingUtilities.isLeftMouseButton(e)) {
                boolean isSelected;
                int row = DarkTableUI.this.table.rowAtPoint(e.getPoint());
                JFileChooser fc = this.getFileChooser();
                if (row < 0 || fc == null) {
                    return;
                }
                int column = this.getFileNameColumnIndex();
                boolean bl = isSelected = DarkTableUI.this.table.getSelectionModel().getLeadSelectionIndex() == row && DarkTableUI.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == column;
                if ((!fc.isMultiSelectionEnabled() || fc.getSelectedFiles().length <= 1) && isSelected && this.lastIndex == row && DarkUIUtil.isOverText(e, row, column, DarkTableUI.this.table)) {
                    this.startEditing(row, column);
                } else {
                    this.lastIndex = row;
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (SwingUtilities.isLeftMouseButton(e)) {
                DarkTableUI.this.table.repaint();
            }
        }

        protected JFileChooser getFileChooser() {
            Object obj = ((Supplier)PropertyUtil.getObject((JComponent)DarkTableUI.this.table, (String)DarkTableUI.KEY_FILE_CHOOSER_PARENT, Supplier.class, Object::new)).get();
            return obj instanceof JFileChooser ? (JFileChooser)obj : null;
        }

        protected Integer getFileNameColumnIndex() {
            return PropertyUtil.getInteger((JComponent)DarkTableUI.this.table, (String)DarkTableUI.KEY_FILENAME_COLUMN_INDEX);
        }

        protected void startEditing(int row, int column) {
            DarkTableUI.this.table.editCellAt(row, column, null);
            Component editorComponent = DarkTableUI.this.table.getEditorComponent();
            if (editorComponent != null && !editorComponent.hasFocus()) {
                SwingUtilities2.compositeRequestFocus(editorComponent);
            }
        }

        @Override
        protected void maybeStartTimer() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (DarkTableUI.ignoreKeyCodeOnEdit(e, DarkTableUI.this.table)) {
                return;
            }
            super.keyTyped(e);
        }
    }
}

