/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabframe;

import com.github.weisj.darklaf.components.JXPopupMenu;
import com.github.weisj.darklaf.components.tabframe.TabFrameTab;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.util.Alignment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class DarkTabFrameComponentPopupMenu
extends JXPopupMenu
implements PropertyChangeListener,
UIResource {
    private final TabFrameTab tab;
    private final JMenuItem[] actions;
    private int disabled = -1;

    public DarkTabFrameComponentPopupMenu(TabFrameTab tab) {
        Alignment a;
        this.tab = tab;
        JMenu moveToMenu = new JMenu("Move to");
        Alignment[] aligns = Alignment.values();
        this.actions = new JMenuItem[aligns.length];
        for (a = Alignment.NORTH_WEST; a != Alignment.NORTH; a = a.anticlockwise()) {
            this.createAndAdd(a, moveToMenu);
        }
        this.createAndAdd(a, moveToMenu);
        this.add(moveToMenu);
        if (tab.getOrientation() != null) {
            this.disabled = tab.getOrientation().ordinal();
            this.actions[tab.getOrientation().ordinal()].setEnabled(false);
        }
        tab.getComponent().addPropertyChangeListener(this);
    }

    protected void createAndAdd(Alignment a, JMenu menu) {
        JMenuItem menuItem;
        this.actions[a.ordinal()] = menuItem = this.createMenuItem(a);
        menu.add(menuItem);
    }

    protected JMenuItem createMenuItem(Alignment a) {
        JMenuItem menuItem = new JMenuItem();
        menuItem.addActionListener(e -> this.moveTo(a));
        menuItem.setText(this.getDescription(a));
        menuItem.setIcon(this.createIcon(a, true));
        menuItem.setDisabledIcon(this.createIcon(a, false));
        return menuItem;
    }

    protected void moveTo(Alignment a) {
        if (this.disabled >= 0) {
            this.actions[this.disabled].setEnabled(true);
        }
        this.disabled = a.ordinal();
        this.actions[a.ordinal()].setEnabled(false);
        this.tab.getTabFrame().moveTab(this.tab, a);
    }

    protected String getDescription(Alignment a) {
        switch (a) {
            case NORTH: {
                return "Top Left";
            }
            case SOUTH: {
                return "Bottom Right";
            }
            case EAST: {
                return "Right Top";
            }
            case WEST: {
                return "Left Bottom";
            }
            case NORTH_EAST: {
                return "Top Right";
            }
            case NORTH_WEST: {
                return "Left Top";
            }
            case SOUTH_EAST: {
                return "Right Bottom";
            }
            case SOUTH_WEST: {
                return "Bottom Left";
            }
        }
        return "";
    }

    protected Icon createIcon(Alignment a, boolean enabled) {
        String suffix = enabled ? "" : "Disabled";
        switch (a) {
            case NORTH: {
                return UIManager.getIcon("TabFrame.moveToTopLeft" + suffix + ".icon");
            }
            case SOUTH: {
                return UIManager.getIcon("TabFrame.moveToBottomRight" + suffix + ".icon");
            }
            case EAST: {
                return UIManager.getIcon("TabFrame.moveToRightTop" + suffix + ".icon");
            }
            case WEST: {
                return UIManager.getIcon("TabFrame.moveToLeftBottom" + suffix + ".icon");
            }
            case NORTH_EAST: {
                return UIManager.getIcon("TabFrame.moveToTopRight" + suffix + ".icon");
            }
            case NORTH_WEST: {
                return UIManager.getIcon("TabFrame.moveToLeftTop" + suffix + ".icon");
            }
            case SOUTH_EAST: {
                return UIManager.getIcon("TabFrame.moveToRightBottom" + suffix + ".icon");
            }
            case SOUTH_WEST: {
                return UIManager.getIcon("TabFrame.moveToBottomLeft" + suffix + ".icon");
            }
        }
        return EmptyIcon.create((int)0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("orientation".equals(evt.getPropertyName())) {
            Object a = evt.getNewValue();
            if (a instanceof Alignment) {
                if (this.disabled >= 0) {
                    this.actions[this.disabled].setEnabled(true);
                }
                this.disabled = ((Alignment)a).ordinal();
                this.actions[this.disabled].setEnabled(false);
            }
        } else if ("componentPopupMenu".equals(evt.getPropertyName()) && evt.getNewValue() != this) {
            this.tab.getComponent().removePropertyChangeListener(this);
        }
    }
}

