/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.list;

import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class DarkListCellRenderer
extends DefaultListCellRenderer {
    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.getHorizontalAlignment() != 0) {
            if (list.getComponentOrientation().isLeftToRight()) {
                this.setHorizontalAlignment(2);
            } else {
                this.setHorizontalAlignment(4);
            }
        }
        Component comp = null;
        boolean isEditing = PropertyUtil.getBooleanProperty(list, (String)"JList.isEditing");
        if (isEditing && list.getSelectionModel().getLeadSelectionIndex() == index) {
            comp = super.getListCellRendererComponent(list, value, index, false, false);
        }
        if (comp == null) {
            comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        CellUtil.setupBackground(comp, list, isSelected, index, "JList.alternateRowColor", "List.alternateRowBackground", "List.selectionNoFocusBackground");
        if (!isSelected) {
            comp.setForeground(list.getForeground());
        } else if (DarkUIUtil.hasFocus(list) || DarkUIUtil.getParentOfType(JPopupMenu.class, list) != null) {
            comp.setForeground(list.getSelectionForeground());
            comp.setBackground(list.getSelectionBackground());
        } else {
            comp.setForeground(UIManager.getColor("List.selectionForegroundInactive"));
        }
        if (this.getText().isEmpty()) {
            this.setText(" ");
        }
        return comp;
    }
}

