/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.button;

import com.github.weisj.darklaf.delegate.AbstractButtonLayoutDelegate;
import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.GraphicsUtil;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.button.ButtonConstants;
import com.github.weisj.darklaf.ui.button.DarkButtonBorder;
import com.github.weisj.darklaf.ui.button.DarkButtonListener;
import com.github.weisj.darklaf.ui.togglebutton.DarkToggleButtonKeyHandler;
import com.github.weisj.darklaf.ui.togglebutton.ToggleButtonFocusNavigationActions;
import com.github.weisj.darklaf.util.AlignmentExt;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.swing.SwingUtilities2;

public class DarkButtonUI
extends BasicButtonUI
implements ButtonConstants {
    protected static final Rectangle viewRect = new Rectangle();
    protected static final Rectangle textRect = new Rectangle();
    protected static final Rectangle iconRect = new Rectangle();
    protected int borderSize;
    protected int shadowHeight;
    protected boolean drawOutline;
    protected Color inactiveForeground;
    protected Color defaultForeground;
    protected Color defaultBackground;
    protected Color defaultHoverBackground;
    protected Color defaultClickBackground;
    protected Color background;
    protected Color hoverBackground;
    protected Color clickBackground;
    protected Color inactiveBackground;
    protected Color borderlessHover;
    protected Color borderlessClick;
    protected Color borderlessOutlineHover;
    protected Color borderlessOutlineClick;
    protected AbstractButton button;
    protected int arc;
    protected int squareArc;
    protected KeyListener keyListener;
    protected final AbstractButtonLayoutDelegate layoutDelegate = new AbstractButtonLayoutDelegate(){

        @Override
        public Font getFont() {
            return this.delegate != null ? this.delegate.getFont().deriveFont(1) : null;
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarkButtonUI();
    }

    @Override
    public String getPropertyPrefix() {
        return super.getPropertyPrefix();
    }

    @Override
    public void installUI(JComponent c) {
        this.button = (AbstractButton)c;
        super.installUI(c);
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        LookAndFeel.installProperty(b, "opaque", false);
        this.borderSize = UIManager.getInt("Button.borderThickness");
        this.shadowHeight = UIManager.getInt("Button.shadowHeight");
        this.inactiveForeground = UIManager.getColor("Button.disabledText");
        this.defaultForeground = UIManager.getColor("Button.selectedButtonForeground");
        this.defaultBackground = UIManager.getColor("Button.defaultFillColor");
        this.defaultHoverBackground = UIManager.getColor("Button.defaultFillColorRollOver");
        this.defaultClickBackground = UIManager.getColor("Button.defaultFillColorClick");
        this.background = UIManager.getColor("Button.activeFillColor");
        this.hoverBackground = UIManager.getColor("Button.activeFillColorRollOver");
        this.clickBackground = UIManager.getColor("Button.activeFillColorClick");
        this.inactiveBackground = UIManager.getColor("Button.inactiveFillColor");
        this.borderlessHover = UIManager.getColor("Button.borderless.hover");
        this.borderlessClick = UIManager.getColor("Button.borderless.click");
        this.borderlessOutlineHover = UIManager.getColor("Button.borderless.outline.hover");
        this.borderlessOutlineClick = UIManager.getColor("Button.borderless.outline.click");
        this.arc = UIManager.getInt("Button.arc");
        this.squareArc = UIManager.getInt("Button.squareArc");
        this.drawOutline = UIManager.getBoolean("Button.borderless.drawOutline");
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.keyListener = this.createKeyListener(b);
        b.addKeyListener(this.keyListener);
        ToggleButtonFocusNavigationActions.installActions(b);
    }

    protected KeyListener createKeyListener(AbstractButton button) {
        return new DarkToggleButtonKeyHandler();
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new DarkButtonListener(b, this);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removeKeyListener(this.keyListener);
        this.keyListener = null;
        ToggleButtonFocusNavigationActions.uninstallActions(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        GraphicsContext config = new GraphicsContext(g);
        AbstractButton b = (AbstractButton)c;
        this.paintButtonBackground(g, c);
        if (ButtonConstants.isDefaultButton(b)) {
            g.setFont(g.getFont().deriveFont(1));
        } else if (g.getFont().isBold()) {
            g.setFont(g.getFont().deriveFont(0));
        }
        String text = this.layout(b, c, SwingUtilities2.getFontMetrics((JComponent)b, g), b.getWidth(), b.getHeight());
        this.paintIcon(g, b, c);
        config.restoreClip();
        this.paintText(g, b, text);
    }

    protected void paintButtonBackground(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.shouldDrawBackground(c)) {
            AbstractButton b = (AbstractButton)c;
            int arc = this.getArc(c);
            int width = c.getWidth();
            int height = c.getHeight();
            Insets margin = b.getMargin();
            if (margin instanceof UIResource) {
                margin = new Insets(0, 0, 0, 0);
            }
            if (ButtonConstants.isBorderlessVariant(c)) {
                this.paintBorderlessBackground(g, c, g2, b, arc, width, height, margin);
            } else {
                this.paintDefaultBackground((Graphics2D)g, b, g2, arc, width, height);
            }
        }
    }

    protected void paintDefaultBackground(Graphics2D g, AbstractButton c, Graphics2D g2, int arc, int width, int height) {
        int shadow = DarkButtonBorder.showDropShadow(c) ? this.shadowHeight : 0;
        int effectiveArc = ButtonConstants.isSquare(c) && !ButtonConstants.chooseAlternativeArc(c) ? 0 : arc;
        AlignmentExt corner = DarkButtonBorder.getCornerFlag(c);
        boolean focus = c.hasFocus() && c.isFocusPainted();
        Rectangle bgRect = this.getEffectiveRect(width, height, c, -(effectiveArc + 1), corner, focus);
        g2.setColor(this.getBackgroundColor(c));
        this.paintBackgroundRect(g, g2, shadow, effectiveArc, bgRect);
    }

    private void paintBackgroundRect(Graphics2D g, Graphics2D g2, int shadow, int effectiveArc, Rectangle bgRect) {
        if (effectiveArc == 0) {
            g2.fillRect(bgRect.x, bgRect.y, bgRect.width, bgRect.height);
        } else {
            PaintUtil.fillRoundRect(g, bgRect.x, bgRect.y, bgRect.width, bgRect.height, effectiveArc);
        }
    }

    protected Rectangle getEffectiveRect(int width, int height, AbstractButton c, int adjustment, AlignmentExt corner, boolean focus) {
        Insets insetMask = new Insets(this.borderSize, this.borderSize, Math.max(this.borderSize, this.shadowHeight), this.borderSize);
        if (corner != null) {
            insetMask = corner.maskInsets(insetMask, adjustment);
        }
        int bx = insetMask.left;
        int by = insetMask.top;
        int bw = width - insetMask.left - insetMask.right;
        int bh = height - insetMask.top - insetMask.bottom;
        return new Rectangle(bx, by, bw, bh);
    }

    protected void paintBorderlessBackground(Graphics g, JComponent c, Graphics2D g2, AbstractButton b, int arc, int width, int height, Insets margin) {
        if (b.isEnabled() && b.getModel().isRollover()) {
            GraphicsUtil.setupAAPainting(g2);
            g.setColor(this.getBorderlessBackground(b));
            if (ButtonConstants.isBorderlessRectangular(c)) {
                g.fillRect(margin.left, margin.top, width - margin.left - margin.right, height - margin.top - margin.bottom);
                PaintUtil.drawRect(g, margin.left, margin.top, width - margin.left - margin.right, height - margin.top - margin.bottom, 1);
            } else if (ButtonConstants.doConvertToBorderless(b)) {
                int size = Math.min(width - margin.left - margin.right, height - margin.left - margin.right);
                if (!this.drawOutline) {
                    g.fillRoundRect((width - size) / 2 + 2, (height - size) / 2 + 2, size - 4, size - 4, arc, arc);
                } else {
                    g.setColor(this.getBorderlessOutline(b));
                    g.drawRoundRect((width - size) / 2 + 2, (height - size) / 2 + 2, size - 4, size - 4, arc, arc);
                }
            } else if (!this.drawOutline) {
                g.fillRoundRect(margin.left + 2, margin.top + 2, width - margin.left - margin.right - 4, height - margin.top - margin.bottom - 4, arc, arc);
            } else {
                g.setColor(this.getBorderlessOutline(b));
                g.drawRoundRect(margin.left + 2, margin.top + 2, width - margin.left - margin.right - 4, height - margin.top - margin.bottom - 4, arc, arc);
            }
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        g.setColor(this.getForeground(button));
        int mnemonicIndex = button.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            mnemonicIndex = -1;
        }
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + this.getTextShiftOffset());
    }

    protected void paintText(Graphics g, AbstractButton b, String text) {
        PaintUtil.drawString(g, b, text, textRect, SwingUtilities2.getFontMetrics((JComponent)b, g), this::paintText);
    }

    protected void paintIcon(Graphics g, AbstractButton b, JComponent c) {
        if (b.getIcon() != null) {
            g.setClip(iconRect);
            this.paintIcon(g, c, iconRect);
        }
    }

    protected void repaintNeighbours() {
        DarkUIUtil.repaint(ButtonConstants.getNeighbour("JButton.leftNeighbour", this.button));
        DarkUIUtil.repaint(ButtonConstants.getNeighbour("JButton.topNeighbour", this.button));
        DarkUIUtil.repaint(ButtonConstants.getNeighbour("JButton.rightNeighbour", this.button));
        DarkUIUtil.repaint(ButtonConstants.getNeighbour("JButton.bottomNeighbour", this.button));
    }

    protected boolean shouldDrawBackground(JComponent c) {
        if (ButtonConstants.isLabelButton(c)) {
            return false;
        }
        AbstractButton button = (AbstractButton)c;
        Border border = c.getBorder();
        return c.isEnabled() && border != null && button.isContentAreaFilled();
    }

    protected int getArc(Component c) {
        if (ButtonConstants.isNoArc(c)) {
            return 0;
        }
        boolean square = ButtonConstants.isSquare(c);
        boolean alt = ButtonConstants.chooseAlternativeArc(c);
        return square ? (alt ? this.arc : this.squareArc) : (alt ? this.squareArc : this.arc);
    }

    protected Color getForeground(AbstractButton button) {
        Color fg = button.getForeground();
        if (fg instanceof UIResource && ButtonConstants.isDefaultButton(button) && !ButtonConstants.isBorderlessVariant(button)) {
            fg = this.defaultForeground;
        }
        if (fg instanceof UIResource && !button.getModel().isEnabled()) {
            fg = this.inactiveForeground;
        }
        return fg;
    }

    protected Color getBackgroundColor(JComponent c) {
        boolean defaultButton = ButtonConstants.isDefaultButton(c);
        AbstractButton b = (AbstractButton)c;
        boolean rollOver = b.isRolloverEnabled() && b.getModel().isRollover();
        boolean clicked = b.getModel().isArmed();
        if (c.isEnabled()) {
            if (defaultButton) {
                if (clicked) {
                    return this.defaultClickBackground;
                }
                if (rollOver) {
                    return this.defaultHoverBackground;
                }
                return this.defaultBackground;
            }
            if (clicked) {
                return this.clickBackground;
            }
            if (rollOver) {
                return this.hoverBackground;
            }
            return this.background;
        }
        return this.inactiveBackground;
    }

    protected Color getBorderlessBackground(AbstractButton c) {
        boolean armed = c.getModel().isArmed();
        return armed ? PropertyUtil.getColor((JComponent)c, (String)"JButton.borderless.click", (Color)this.borderlessClick) : PropertyUtil.getColor((JComponent)c, (String)"JButton.borderless.hover", (Color)this.borderlessHover);
    }

    protected Color getBorderlessOutline(AbstractButton c) {
        boolean armed = c.getModel().isArmed();
        return armed ? this.borderlessOutlineClick : this.borderlessOutlineHover;
    }

    protected String layout(AbstractButton b, JComponent c, FontMetrics fm, int width, int height) {
        AlignmentExt corner;
        Insets i = b.getInsets();
        if (!ButtonConstants.isBorderlessVariant(b)) {
            i = new Insets(i.top, this.borderSize, i.bottom, this.borderSize);
        }
        if ((corner = DarkButtonBorder.getCornerFlag(c)) != null) {
            Insets insetMask = new Insets(this.borderSize, this.borderSize, this.borderSize, this.borderSize);
            insetMask = corner.maskInsetsInverted(insetMask, 0);
            i.left -= insetMask.left;
            i.right -= insetMask.right;
            i.top -= insetMask.top;
            i.bottom -= insetMask.bottom;
        }
        DarkButtonUI.viewRect.x = i.left;
        DarkButtonUI.viewRect.y = i.top;
        DarkButtonUI.viewRect.width = width - (i.right + i.left);
        DarkButtonUI.viewRect.height = height - (i.bottom + i.top);
        DarkButtonUI.textRect.height = 0;
        DarkButtonUI.textRect.width = 0;
        DarkButtonUI.textRect.y = 0;
        DarkButtonUI.textRect.x = 0;
        DarkButtonUI.iconRect.height = 0;
        DarkButtonUI.iconRect.width = 0;
        DarkButtonUI.iconRect.y = 0;
        DarkButtonUI.iconRect.x = 0;
        return SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null || ButtonConstants.isIconOnly(b) ? 0 : b.getIconTextGap());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        this.layoutDelegate.setDelegate(b);
        return BasicGraphicsUtils.getPreferredButtonSize(this.layoutDelegate, b.getIconTextGap());
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (ButtonConstants.isLabelButton(c)) {
            return super.contains(c, x, y);
        }
        if (x < 0 || x > c.getWidth() || y < 0 || y > c.getHeight()) {
            return false;
        }
        int bs = this.borderSize;
        int arc = this.getArc(c);
        return new RoundRectangle2D.Float(bs, bs, c.getWidth() - 2 * bs, c.getWidth() - 2 * bs, arc, arc).contains(x, y);
    }
}

