/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui;

import com.github.weisj.darklaf.platform.DecorationsHandler;
import com.github.weisj.darklaf.uiresource.DarkColorUIResource;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.Pair;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DarkPopupFactory
extends PopupFactory {
    public static final String KEY_NO_DECORATION = "JPopupFactory.noDecorations";
    public static final String KEY_FOCUSABLE_POPUP = "JPopupFactory.focusablePopup";
    public static final String KEY_FORCE_HEAVYWEIGHT = "JPopupFactory.forceHeavyweight";
    public static final String KEY_START_HIDDEN = "JPopupFactory.startHidden";
    public static final String KEY_MAKE_VISIBLE = "JPopupFactory.makeVisible";
    public static final String KEY_OPAQUE = "JPopupFactory.opaque";
    private HeavyWeightParent heavyWeightParent;

    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        Pair<Popup, PopupType> result = this.getEffectivePopup(owner, contents, x, y);
        Popup popup = (Popup)result.getFirst();
        PopupType type = (PopupType)((Object)result.getSecond());
        this.setupPopup(popup, type, contents);
        return popup;
    }

    protected Pair<Popup, PopupType> getEffectivePopup(Component owner, Component contents, int x, int y) {
        boolean forceHeavy;
        Popup popup = super.getPopup(owner, contents, x, y);
        PopupType type = this.getPopupType(popup);
        boolean bl = forceHeavy = type != PopupType.HEAVY_WEIGHT && PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_FORCE_HEAVYWEIGHT);
        if (forceHeavy) {
            Popup p = super.getPopup(this.getHeavyWeightParent(), contents, x, y);
            return new Pair((Object)p, (Object)PopupType.HEAVY_WEIGHT);
        }
        return new Pair((Object)popup, (Object)type);
    }

    protected PopupType getPopupType(Popup popup) {
        String popupClassName = popup.getClass().getSimpleName();
        if (popupClassName.endsWith("LightWeightPopup")) {
            return PopupType.LIGHT_WEIGHT;
        }
        if (popupClassName.endsWith("MediumWeightPopup")) {
            return PopupType.MEDIUM_WEIGHT;
        }
        return PopupType.HEAVY_WEIGHT;
    }

    protected void setupPopup(Popup popup, PopupType type, Component contents) {
        Window window;
        if (type == PopupType.MEDIUM_WEIGHT) {
            JRootPane rootPane = SwingUtilities.getRootPane(contents);
            if (rootPane != null) {
                rootPane.putClientProperty("JRootPane.noDecorationsUpdate", true);
            }
        } else if (type == PopupType.HEAVY_WEIGHT && (window = SwingUtilities.getWindowAncestor(contents)) != null) {
            boolean isFocusable = PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_FOCUSABLE_POPUP);
            boolean startHidden = PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_START_HIDDEN);
            this.setupWindow(window, contents, isFocusable, startHidden);
        }
    }

    protected void setupWindow(Window window, Component contents, boolean isFocusable, boolean startHidden) {
        boolean noDecorations = PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_NO_DECORATION);
        boolean opaque = PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_OPAQUE);
        this.setupWindowBackground(window, opaque, !noDecorations);
        this.setupWindowFocusableState(isFocusable, window);
        this.setupWindowDecorations(window, noDecorations);
        this.setupWindowOpacity(contents, startHidden, window);
    }

    protected void setupWindowBackground(Window window, boolean opaque, boolean decorations) {
        if (window instanceof RootPaneContainer) {
            JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
            rootPane.setOpaque(opaque);
            if (opaque) {
                window.setBackground(rootPane.getBackground());
            } else {
                Color bg = this.getTranslucentPopupBackground(decorations);
                window.setBackground(bg);
            }
        }
    }

    protected void setupWindowFocusableState(boolean isFocusable, Window window) {
        if (isFocusable && !window.getFocusableWindowState()) {
            window.dispose();
            window.setFocusableWindowState(true);
        }
    }

    protected void setupWindowDecorations(Window window, boolean noDecorations) {
        if (DecorationsHandler.getSharedInstance().isCustomDecorationSupported()) {
            if (noDecorations) {
                DecorationsHandler.getSharedInstance().uninstallPopupWindow(window);
            } else {
                DecorationsHandler.getSharedInstance().installPopupWindow(window);
            }
        }
    }

    protected void setupWindowOpacity(Component contents, boolean startHidden, Window window) {
        if (startHidden) {
            try {
                if (contents instanceof JComponent) {
                    ((JComponent)contents).putClientProperty(KEY_MAKE_VISIBLE, true);
                }
                window.setOpacity(0.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected HeavyWeightParent getHeavyWeightParent() {
        if (this.heavyWeightParent == null) {
            Box box = Box.createHorizontalBox();
            super.getPopup(null, box, 0, 0);
            this.heavyWeightParent = new HeavyWeightParent(DarkUIUtil.getWindow(box));
        }
        return this.heavyWeightParent;
    }

    protected Color getTranslucentPopupBackground(boolean decorated) {
        Color c = UIManager.getColor("PopupMenu.translucentBackground");
        if (!decorated) {
            c = new DarkColorUIResource(ColorUtil.toAlpha((Color)c, (int)0));
        }
        return c;
    }

    protected static enum PopupType {
        LIGHT_WEIGHT,
        MEDIUM_WEIGHT,
        HEAVY_WEIGHT;

    }

    private static class HeavyWeightParent
    extends JComponent {
        private final Window window;

        private HeavyWeightParent(Window window) {
            this.window = window;
        }

        @Override
        public Container getParent() {
            return this.window;
        }

        public Window getWindow() {
            return this.window;
        }
    }
}

