/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.platform.DefaultDecorationsProvider;
import com.github.weisj.darklaf.platform.decorations.CustomTitlePane;
import com.github.weisj.darklaf.platform.decorations.DecorationsProvider;
import com.github.weisj.darklaf.platform.macos.MacOSDecorationsProvider;
import com.github.weisj.darklaf.platform.windows.WindowsDecorationsProvider;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Properties;
import javax.swing.JRootPane;
import javax.swing.UIDefaults;

public class DecorationsHandler {
    public static final String DECORATIONS_FLAG = "darklaf.decorations";
    private static DecorationsHandler sharedInstance;
    private DecorationsProvider decorationsProvider;
    private boolean decorationsEnabled = true;

    public static DecorationsHandler getSharedInstance() {
        if (sharedInstance == null) {
            DecorationsHandler.setSharedInstance(new DecorationsHandler());
        }
        return sharedInstance;
    }

    public static void setSharedInstance(DecorationsHandler handler) {
        sharedInstance = handler;
    }

    protected DecorationsHandler() {
        try {
            boolean enableDecorations = this.isNativeDecorationsEnabled();
            this.decorationsProvider = SystemInfo.isWindows10 && enableDecorations ? new WindowsDecorationsProvider() : (SystemInfo.isMacOSYosemite && enableDecorations ? new MacOSDecorationsProvider() : new DefaultDecorationsProvider());
        }
        catch (Throwable e) {
            this.decorationsProvider = new DefaultDecorationsProvider();
        }
    }

    public CustomTitlePane createTitlePane(JRootPane rootPane, int decorationStyle, Window window) {
        return this.decorationsProvider.createTitlePane(rootPane, decorationStyle, window);
    }

    public void installPopupWindow(Window window) {
        this.decorationsProvider.installPopupWindow(window);
    }

    public void uninstallPopupWindow(Window window) {
        this.decorationsProvider.uninstallPopupWindow(window);
    }

    public boolean isCustomDecorationSupported() {
        return this.decorationsProvider.isCustomDecorationSupported() && this.decorationsEnabled && LafManager.getTheme().useCustomDecorations();
    }

    private boolean isNativeDecorationsEnabled() {
        return !"false".equals(System.getProperty(DECORATIONS_FLAG)) && !"false".equals(System.getProperty("darklaf.allowNativeCode"));
    }

    public void initialize() {
        this.decorationsProvider.initialize();
    }

    public void loadDecorationProperties(Properties uiProps, UIDefaults defaults) {
        this.decorationsProvider.loadDecorationProperties(uiProps, defaults);
    }

    public void setDecorationsEnabled(boolean enabled) {
        this.decorationsEnabled = enabled;
    }

    public void adjustContentArea(JRootPane root, Rectangle rect) {
        this.decorationsProvider.adjustContentArea(root, rect);
    }

    public void adjustWindowInsets(Window window, Insets i) {
        this.decorationsProvider.adjustWindowInsets(window, i);
    }
}

