/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.platform.DecorationsHandler;
import com.github.weisj.darklaf.platform.ThemePreferencesHandler;
import com.github.weisj.darklaf.settings.ThemeSettings;
import com.github.weisj.darklaf.task.DefaultsAdjustmentTask;
import com.github.weisj.darklaf.task.DefaultsInitTask;
import com.github.weisj.darklaf.theme.DarculaTheme;
import com.github.weisj.darklaf.theme.HighContrastDarkTheme;
import com.github.weisj.darklaf.theme.HighContrastLightTheme;
import com.github.weisj.darklaf.theme.IntelliJTheme;
import com.github.weisj.darklaf.theme.OneDarkTheme;
import com.github.weisj.darklaf.theme.SolarizedDarkTheme;
import com.github.weisj.darklaf.theme.SolarizedLightTheme;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.event.ThemeChangeEvent;
import com.github.weisj.darklaf.theme.event.ThemeChangeListener;
import com.github.weisj.darklaf.theme.event.ThemeEvent;
import com.github.weisj.darklaf.theme.event.ThemeEventListener;
import com.github.weisj.darklaf.theme.event.ThemeEventSupport;
import com.github.weisj.darklaf.theme.event.ThemePreferenceChangeEvent;
import com.github.weisj.darklaf.theme.event.ThemePreferenceListener;
import com.github.weisj.darklaf.theme.info.DefaultThemeProvider;
import com.github.weisj.darklaf.theme.info.PreferredThemeStyle;
import com.github.weisj.darklaf.theme.info.ThemeProvider;
import com.github.weisj.darklaf.util.LogUtil;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class LafManager {
    private static ThemeProvider themeProvider;
    private static Theme theme;
    private static final List<Theme> registeredThemes;
    private static final Collection<DefaultsAdjustmentTask> uiDefaultsTasks;
    private static final Collection<DefaultsInitTask> uiInitTasks;
    private static final ThemeEventSupport<ThemeChangeEvent, ThemeChangeListener> eventSupport;

    public static void enableLogging(boolean logEnabled) {
        LafManager.setLogLevel(logEnabled ? Level.INFO : Level.SEVERE);
    }

    public static void setLogLevel(Level level) {
        LogUtil.setLevel((Level)level);
    }

    public static boolean isDecorationsEnabled() {
        return DecorationsHandler.getSharedInstance().isCustomDecorationSupported();
    }

    public static void setDecorationsEnabled(boolean enabled) {
        boolean isEnabled = LafManager.isDecorationsEnabled();
        DecorationsHandler.getSharedInstance().setDecorationsEnabled(enabled);
        if (isEnabled != enabled) {
            LafManager.updateLaf();
        }
    }

    public static void enabledPreferenceChangeReporting(boolean enabled) {
        ThemePreferencesHandler.getSharedInstance().enablePreferenceChangeReporting(enabled);
        if (ThemeSettings.isInitialized()) {
            ThemeSettings.getInstance().setEnabledSystemPreferences(enabled);
        }
    }

    public static boolean isPreferenceChangeReportingEnabled() {
        return ThemePreferencesHandler.getSharedInstance().isPreferenceChangeReportingEnabled();
    }

    public static void addThemePreferenceChangeListener(ThemePreferenceListener listener) {
        ThemePreferencesHandler.getSharedInstance().addThemePreferenceChangeListener(listener);
    }

    public static void removeThemePreferenceChangeListener(ThemePreferenceListener listener) {
        ThemePreferencesHandler.getSharedInstance().removeThemePreferenceChangeListener(listener);
    }

    public static void addThemeChangeListener(ThemeChangeListener listener) {
        eventSupport.addListener((ThemeEventListener)listener);
    }

    public static void removeThemeChangeListener(ThemeChangeListener listener) {
        eventSupport.removeListener((ThemeEventListener)listener);
    }

    public static PreferredThemeStyle getPreferredThemeStyle() {
        return ThemePreferencesHandler.getSharedInstance().getPreferredThemeStyle();
    }

    public static ThemeProvider getThemeProvider() {
        if (themeProvider == null) {
            themeProvider = LafManager.createDefaultThemeProvider();
        }
        return themeProvider;
    }

    public static void setThemeProvider(ThemeProvider themeProvider) {
        LafManager.themeProvider = themeProvider;
    }

    private static ThemeProvider createDefaultThemeProvider() {
        return new DefaultThemeProvider();
    }

    public static Theme themeForPreferredStyle(PreferredThemeStyle style) {
        return LafManager.getThemeProvider().getTheme(style);
    }

    public static void registerTheme(Theme ... themes) {
        if (themes == null) {
            return;
        }
        for (Theme theme : themes) {
            LafManager.registerTheme(theme);
        }
    }

    public static void registerTheme(Theme theme) {
        registeredThemes.add(theme);
    }

    public static void unregisterTheme(Theme theme) {
        registeredThemes.remove(theme);
    }

    public static Theme[] getRegisteredThemes() {
        Object[] themes = registeredThemes.toArray(new Theme[0]);
        Arrays.sort(themes);
        return themes;
    }

    public static ComboBoxModel<Theme> getThemeComboBoxModel() {
        return new DefaultComboBoxModel<Theme>(LafManager.getRegisteredThemes());
    }

    public static Theme getTheme() {
        if (theme == null) {
            LafManager.setTheme(LafManager.themeForPreferredStyle(null));
        }
        return theme;
    }

    public static void setTheme(Theme theme) {
        Theme old = LafManager.theme;
        LafManager.theme = theme;
        if (old != theme) {
            eventSupport.dispatchEvent((ThemeEvent)new ThemeChangeEvent(old, theme), ThemeChangeListener::themeChanged);
        }
        if (ThemeSettings.isInitialized()) {
            ThemeSettings.getInstance().refresh();
        }
    }

    public static void installTheme(ThemePreferenceChangeEvent changeEvent) {
        LafManager.setTheme(changeEvent.getPreferredThemeStyle());
        LafManager.install();
    }

    public static void installTheme(PreferredThemeStyle preferredThemeStyle) {
        LafManager.setTheme(preferredThemeStyle);
        LafManager.install();
    }

    public static void setTheme(PreferredThemeStyle preferredThemeStyle) {
        LafManager.setTheme(LafManager.themeForPreferredStyle(preferredThemeStyle));
    }

    public static void installTheme(Theme theme) {
        if (theme == LafManager.getTheme()) {
            return;
        }
        LafManager.setTheme(theme);
        LafManager.install();
    }

    public static void reloadTheme() {
        LafManager.setTheme(LafManager.getTheme().copy());
    }

    public static void install(Theme theme) {
        LafManager.installTheme(theme);
    }

    public static void install() {
        try {
            LafManager.getTheme();
            UIManager.setLookAndFeel(DarkLaf.class.getCanonicalName());
            LafManager.updateLaf();
            eventSupport.dispatchEvent((ThemeEvent)new ThemeChangeEvent(null, LafManager.getTheme()), ThemeChangeListener::themeInstalled);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public static void updateLaf() {
        for (Window w : Window.getWindows()) {
            LafManager.updateLafRecursively(w);
        }
    }

    private static void updateLafRecursively(Window window) {
        for (Window childWindow : window.getOwnedWindows()) {
            LafManager.updateLafRecursively(childWindow);
        }
        SwingUtilities.updateComponentTreeUI(window);
    }

    public static void registerDefaultsAdjustmentTask(DefaultsAdjustmentTask task) {
        uiDefaultsTasks.add(task);
    }

    public static void removeDefaultsAdjustmentTask(DefaultsAdjustmentTask task) {
        uiDefaultsTasks.remove(task);
    }

    public static Collection<DefaultsAdjustmentTask> getUserDefaultsAdjustmentTasks() {
        return uiDefaultsTasks;
    }

    public static void registerInitTask(DefaultsInitTask task) {
        uiInitTasks.add(task);
    }

    public static void removeInitTask(DefaultsInitTask task) {
        uiInitTasks.remove(task);
    }

    public static Collection<DefaultsInitTask> getUserInitTasks() {
        return uiInitTasks;
    }

    public static Theme getClosestMatchForTheme(Theme theme) {
        if (theme == null) {
            return LafManager.themeForPreferredStyle(null);
        }
        for (Theme registered : LafManager.getRegisteredThemes()) {
            if (!registered.equals(theme)) continue;
            return registered;
        }
        for (Theme registered : LafManager.getRegisteredThemes()) {
            if (!registered.getThemeClass().equals(theme.getThemeClass())) continue;
            return registered;
        }
        return LafManager.themeForPreferredStyle(null);
    }

    static {
        registeredThemes = new ArrayList<Theme>();
        uiDefaultsTasks = new ArrayList<DefaultsAdjustmentTask>();
        uiInitTasks = new ArrayList<DefaultsInitTask>();
        eventSupport = new ThemeEventSupport();
        LafManager.setLogLevel(Level.INFO);
        LafManager.registerTheme(new Theme[]{new IntelliJTheme(), new DarculaTheme(), new SolarizedLightTheme(), new SolarizedDarkTheme(), new OneDarkTheme(), new HighContrastLightTheme(), new HighContrastDarkTheme()});
    }
}

