/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows;

import com.github.weisj.darklaf.platform.NativeUtil;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WindowsLibrary {
    private static final Logger LOGGER = LogUtil.getLogger(WindowsLibrary.class);
    private static boolean loaded;
    private static boolean attemptedLoad;

    public static void updateLibrary() {
        if (!loaded && !attemptedLoad) {
            WindowsLibrary.loadLibrary();
        }
    }

    private static void loadLibrary() {
        attemptedLoad = true;
        if (!SystemInfo.isWindows || loaded) {
            return;
        }
        try {
            if (SystemInfo.isX86) {
                NativeUtil.loadLibraryFromJar((String)"/com/github/weisj/darklaf/platform/darklaf-windows/windows-x86/darklaf-windows.dll");
            } else if (SystemInfo.isX64) {
                NativeUtil.loadLibraryFromJar((String)"/com/github/weisj/darklaf/platform/darklaf-windows/windows-x86-64/darklaf-windows.dll");
            } else {
                LOGGER.warning("Could not determine jre model '" + SystemInfo.jreArchitecture + "'. Native features will be disabled");
                return;
            }
            loaded = true;
            LOGGER.info("Loaded darklaf-windows.dll. Native features are enabled.");
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Could not load decorations library darklaf-windows.dll. Native features will be disabled", e);
        }
    }

    public static boolean isLoaded() {
        return loaded;
    }
}

