/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.testelement.TestStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FunctionParser {
    private static final Logger log = LoggerFactory.getLogger(FunctionParser.class);

    FunctionParser() {
    }

    LinkedList<Object> compileString(String value) throws InvalidVariableException {
        StringReader reader = new StringReader(value);
        LinkedList<Object> result = new LinkedList<Object>();
        StringBuilder buffer = new StringBuilder();
        int previous = 32;
        char[] current = new char[1];
        try {
            while (reader.read(current) == 1) {
                if (current[0] == '\\') {
                    previous = current[0];
                    if (reader.read(current) == 0) break;
                    if (current[0] != '$' && current[0] != ',' && current[0] != '\\') {
                        buffer.append((char)previous);
                    }
                    previous = 32;
                    buffer.append(current[0]);
                    continue;
                }
                if (current[0] == '{' && previous == 36) {
                    buffer.deleteCharAt(buffer.length() - 1);
                    if (buffer.length() > 0) {
                        result.add(buffer.toString());
                        buffer.setLength(0);
                    }
                    result.add(this.makeFunction(reader));
                    previous = 32;
                    continue;
                }
                buffer.append(current[0]);
                previous = current[0];
            }
            if (buffer.length() > 0) {
                result.add(buffer.toString());
            }
        }
        catch (IOException e) {
            log.error("Error parsing function: {}", (Object)value, (Object)e);
            result.clear();
            result.add(value);
        }
        if (result.isEmpty()) {
            result.add("");
        }
        return result;
    }

    Object makeFunction(StringReader reader) throws InvalidVariableException {
        char[] current = new char[1];
        int previous = 32;
        StringBuilder buffer = new StringBuilder();
        try {
            while (reader.read(current) == 1) {
                Object function;
                if (current[0] == '\\') {
                    if (reader.read(current) != 0) {
                        previous = 32;
                        buffer.append(current[0]);
                        continue;
                    }
                    break;
                }
                if (current[0] == '(' && previous != 32) {
                    String funcName = buffer.toString();
                    function = CompoundVariable.getNamedFunction(funcName.trim());
                    if (function instanceof Function) {
                        ((Function)function).setParameters(this.parseParams(reader));
                        if (this.firstNonSpace(reader, '#') != '}') {
                            reader.reset();
                            char[] cb = new char[100];
                            int nbRead = reader.read(cb);
                            throw new InvalidVariableException("Expected } after " + funcName + " function call in " + new String(cb, 0, nbRead));
                        }
                        if (function instanceof TestStateListener) {
                            StandardJMeterEngine.register((TestStateListener)function);
                        }
                        return function;
                    }
                    buffer.append(current[0]);
                    continue;
                }
                if (current[0] == '}') {
                    function = CompoundVariable.getNamedFunction(buffer.toString());
                    if (function instanceof Function) {
                        ((Function)function).setParameters(new LinkedList<CompoundVariable>());
                    }
                    buffer.setLength(0);
                    return function;
                }
                buffer.append(current[0]);
                previous = current[0];
            }
        }
        catch (IOException e) {
            log.error("Error parsing function: {}", (Object)buffer, (Object)e);
            return null;
        }
        log.warn("Probably an invalid function string: {}", (Object)buffer);
        return buffer.toString();
    }

    private char firstNonSpace(StringReader reader, char defaultResult) throws IOException {
        char[] current = new char[1];
        while (reader.read(current) == 1) {
            if (Character.isSpaceChar(current[0])) continue;
            return current[0];
        }
        return defaultResult;
    }

    LinkedList<CompoundVariable> parseParams(StringReader reader) throws InvalidVariableException {
        LinkedList<CompoundVariable> result = new LinkedList<CompoundVariable>();
        StringBuilder buffer = new StringBuilder();
        char[] current = new char[1];
        int previous = 32;
        int functionRecursion = 0;
        int parenRecursion = 0;
        try {
            while (reader.read(current) == 1) {
                CompoundVariable param;
                if (current[0] == '\\') {
                    buffer.append(current[0]);
                    if (reader.read(current) != 0) {
                        previous = 32;
                        buffer.append(current[0]);
                        continue;
                    }
                    break;
                }
                if (current[0] == ',' && functionRecursion == 0) {
                    param = new CompoundVariable();
                    param.setParameters(buffer.toString());
                    buffer.setLength(0);
                    result.add(param);
                    continue;
                }
                if (current[0] == ')' && functionRecursion == 0 && parenRecursion == 0) {
                    if (buffer.length() == 0 && result.isEmpty()) {
                        return result;
                    }
                    param = new CompoundVariable();
                    param.setParameters(buffer.toString());
                    buffer.setLength(0);
                    result.add(param);
                    return result;
                }
                if (current[0] == '{' && previous == 36) {
                    buffer.append(current[0]);
                    previous = current[0];
                    ++functionRecursion;
                    continue;
                }
                if (current[0] == '}' && functionRecursion > 0) {
                    buffer.append(current[0]);
                    previous = current[0];
                    --functionRecursion;
                    continue;
                }
                if (current[0] == ')' && functionRecursion == 0 && parenRecursion > 0) {
                    buffer.append(current[0]);
                    previous = current[0];
                    --parenRecursion;
                    continue;
                }
                if (current[0] == '(' && functionRecursion == 0) {
                    buffer.append(current[0]);
                    previous = current[0];
                    ++parenRecursion;
                    continue;
                }
                buffer.append(current[0]);
                previous = current[0];
            }
        }
        catch (IOException e) {
            log.error("Error parsing function: {}", (Object)buffer, (Object)e);
        }
        log.warn("Probably an invalid function string: {}", (Object)buffer);
        CompoundVariable var = new CompoundVariable();
        var.setParameters(buffer.toString());
        result.add(var);
        return result;
    }
}

