/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ctakes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.tika.parser.ctakes.CTAKESAnnotationProperty;
import org.apache.tika.parser.ctakes.CTAKESSerializer;

public class CTAKESConfig
implements Serializable {
    private static final long serialVersionUID = -1599741171775528923L;
    private String aeDescriptorPath = "/ctakes-core/desc/analysis_engine/SentencesAndTokensAggregate.xml";
    private String UMLSUser = "";
    private String UMLSPass = "";
    private boolean prettyPrint = true;
    private CTAKESSerializer serializerType = CTAKESSerializer.XMI;
    private OutputStream stream = NullOutputStream.NULL_OUTPUT_STREAM;
    private boolean serialize = false;
    private boolean text = true;
    private String[] metadata = null;
    private CTAKESAnnotationProperty[] annotationProps = null;
    private char separatorChar = (char)58;

    public CTAKESConfig() {
        this.init(this.getClass().getResourceAsStream("CTAKESConfig.properties"));
    }

    public CTAKESConfig(InputStream stream) {
        this.init(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream stream) {
        if (stream == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(stream);
        }
        catch (IOException iOException) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.setAeDescriptorPath(props.getProperty("aeDescriptorPath", this.getAeDescriptorPath()));
        this.setUMLSUser(props.getProperty("UMLSUser", this.getUMLSUser()));
        this.setUMLSPass(props.getProperty("UMLSPass", this.getUMLSPass()));
        this.setText(Boolean.valueOf(props.getProperty("text", Boolean.toString(this.isText()))));
        this.setMetadata(props.getProperty("metadata", this.getMetadataAsString()).split(","));
        this.setAnnotationProps(props.getProperty("annotationProps", this.getAnnotationPropsAsString()).split(","));
        this.setSeparatorChar(props.getProperty("separatorChar", Character.toString(this.getSeparatorChar())).charAt(0));
    }

    public String getAeDescriptorPath() {
        return this.aeDescriptorPath;
    }

    public String getUMLSUser() {
        return this.UMLSUser;
    }

    public String getUMLSPass() {
        return this.UMLSPass;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public CTAKESSerializer getSerializerType() {
        return this.serializerType;
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    public boolean isSerialize() {
        return this.serialize;
    }

    public boolean isText() {
        return this.text;
    }

    public String[] getMetadata() {
        return this.metadata;
    }

    public String getMetadataAsString() {
        if (this.metadata == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.metadata.length; ++i) {
            sb.append(this.metadata[i]);
            if (i >= this.metadata.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public CTAKESAnnotationProperty[] getAnnotationProps() {
        return this.annotationProps;
    }

    public String getAnnotationPropsAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("coveredText");
        if (this.annotationProps != null) {
            for (CTAKESAnnotationProperty property : this.annotationProps) {
                sb.append(this.separatorChar);
                sb.append(property.getName());
            }
        }
        return sb.toString();
    }

    public char getSeparatorChar() {
        return this.separatorChar;
    }

    public void setAeDescriptorPath(String aeDescriptorPath) {
        this.aeDescriptorPath = aeDescriptorPath;
    }

    public void setUMLSUser(String uMLSUser) {
        this.UMLSUser = uMLSUser;
    }

    public void setUMLSPass(String uMLSPass) {
        this.UMLSPass = uMLSPass;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setSerializerType(CTAKESSerializer serializerType) {
        this.serializerType = serializerType;
    }

    public void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    public void setSerialize(boolean serialize) {
        this.serialize = serialize;
    }

    public void setText(boolean text) {
        this.text = text;
    }

    public void setMetadata(String[] metadata) {
        this.metadata = metadata;
    }

    public void setAnnotationProps(CTAKESAnnotationProperty[] annotationProps) {
        this.annotationProps = annotationProps;
    }

    public void setAnnotationProps(String[] annotationProps) {
        CTAKESAnnotationProperty[] properties = new CTAKESAnnotationProperty[annotationProps.length];
        for (int i = 0; i < annotationProps.length; ++i) {
            properties[i] = CTAKESAnnotationProperty.valueOf(annotationProps[i]);
        }
        this.setAnnotationProps(properties);
    }

    public void setSeparatorChar(char separatorChar) {
        this.separatorChar = separatorChar;
    }
}

