/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.util.JMeterStopTestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=1)
public class ThreadGroup
extends AbstractThreadGroup {
    private static final long serialVersionUID = 282L;
    private static final Logger log = LoggerFactory.getLogger(ThreadGroup.class);
    private static final long WAIT_TO_DIE = JMeterUtils.getPropDefault("jmeterengine.threadstop.wait", 5000);
    private static final int RAMPUP_GRANULARITY = JMeterUtils.getPropDefault("jmeterthread.rampup.granularity", 1000);
    public static final String RAMP_TIME = "ThreadGroup.ramp_time";
    public static final String DELAYED_START = "ThreadGroup.delayedStart";
    public static final String SCHEDULER = "ThreadGroup.scheduler";
    public static final String DURATION = "ThreadGroup.duration";
    public static final String DELAY = "ThreadGroup.delay";
    private transient Thread threadStarter;
    private final ConcurrentHashMap<JMeterThread, Thread> allThreads = new ConcurrentHashMap();
    private transient Object addThreadLock = new Object();
    private volatile boolean running = false;
    private int groupNumber;
    private boolean delayedStartup;
    private ListenerNotifier notifier;
    private ListedHashTree threadGroupTree;

    public void setScheduler(boolean scheduler) {
        this.setProperty(new BooleanProperty(SCHEDULER, scheduler));
    }

    public boolean getScheduler() {
        return this.getPropertyAsBoolean(SCHEDULER);
    }

    public long getDuration() {
        return this.getPropertyAsLong(DURATION);
    }

    public void setDuration(long duration) {
        this.setProperty(new LongProperty(DURATION, duration));
    }

    public long getDelay() {
        return this.getPropertyAsLong(DELAY);
    }

    public void setDelay(long delay) {
        this.setProperty(new LongProperty(DELAY, delay));
    }

    public void setRampUp(int rampUp) {
        this.setProperty(new IntegerProperty(RAMP_TIME, rampUp));
    }

    public int getRampUp() {
        return this.getPropertyAsInt(RAMP_TIME);
    }

    private boolean isDelayedStartup() {
        return this.getPropertyAsBoolean(DELAYED_START);
    }

    private void scheduleThread(JMeterThread thread, long now) {
        if (!this.getScheduler()) {
            return;
        }
        if (this.getDelay() < 0L) {
            throw new JMeterStopTestException("Invalid delay " + this.getDelay() + " set in Thread Group:" + this.getName());
        }
        thread.setStartTime(this.getDelay() * 1000L + now);
        if (this.getDuration() <= 0L) {
            throw new JMeterStopTestException("Invalid duration " + this.getDuration() + " set in Thread Group:" + this.getName());
        }
        thread.setEndTime(this.getDuration() * 1000L + thread.getStartTime());
        thread.setScheduled(true);
    }

    @Override
    public void start(int groupNum, ListenerNotifier notifier, ListedHashTree threadGroupTree, StandardJMeterEngine engine) {
        this.running = true;
        this.groupNumber = groupNum;
        this.notifier = notifier;
        this.threadGroupTree = threadGroupTree;
        int numThreads = this.getNumThreads();
        int rampUpPeriodInSeconds = this.getRampUp();
        boolean isSameUserOnNextIteration = this.isSameUserOnNextIteration();
        this.delayedStartup = this.isDelayedStartup();
        log.info("Starting thread group... number={} threads={} ramp-up={} delayedStart={}", new Object[]{this.groupNumber, numThreads, rampUpPeriodInSeconds, this.delayedStartup});
        if (this.delayedStartup) {
            this.threadStarter = new Thread((Runnable)new ThreadStarter(notifier, threadGroupTree, engine), this.getName() + "-ThreadStarter");
            this.threadStarter.setDaemon(true);
            this.threadStarter.start();
        } else {
            JMeterContext context = JMeterContextService.getContext();
            long lastThreadStartInMillis = 0L;
            int delayForNextThreadInMillis = 0;
            int perThreadDelayInMillis = Math.round((float)rampUpPeriodInSeconds * 1000.0f / (float)numThreads);
            for (int threadNum = 0; this.running && threadNum < numThreads; ++threadNum) {
                long nowInMillis = System.currentTimeMillis();
                if (threadNum > 0) {
                    long timeElapsedToStartLastThread = nowInMillis - lastThreadStartInMillis;
                    delayForNextThreadInMillis = (int)((long)delayForNextThreadInMillis + ((long)perThreadDelayInMillis - timeElapsedToStartLastThread));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Computed delayForNextThreadInMillis:{} for thread:{}", (Object)delayForNextThreadInMillis, (Object)Thread.currentThread().getId());
                }
                lastThreadStartInMillis = nowInMillis;
                this.startNewThread(notifier, threadGroupTree, engine, threadNum, context, nowInMillis, Math.max(0, delayForNextThreadInMillis), isSameUserOnNextIteration);
            }
        }
        log.info("Started thread group number {}", (Object)this.groupNumber);
    }

    private JMeterThread startNewThread(ListenerNotifier notifier, ListedHashTree threadGroupTree, StandardJMeterEngine engine, int threadNum, JMeterContext context, long now, int delay, Boolean isSameUserOnNextIteration) {
        JMeterThread jmThread = this.makeThread(notifier, threadGroupTree, engine, threadNum, context, isSameUserOnNextIteration);
        this.scheduleThread(jmThread, now);
        jmThread.setInitialDelay(delay);
        Thread newThread = new Thread((Runnable)jmThread, jmThread.getThreadName());
        this.registerStartedThread(jmThread, newThread);
        newThread.start();
        return jmThread;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.addThreadLock = new Object();
    }

    private void registerStartedThread(JMeterThread jMeterThread, Thread newThread) {
        this.allThreads.put(jMeterThread, newThread);
    }

    private JMeterThread makeThread(ListenerNotifier notifier, ListedHashTree threadGroupTree, StandardJMeterEngine engine, int threadNumber, JMeterContext context, Boolean isSameUserOnNextIteration) {
        boolean onErrorStopTest = this.getOnErrorStopTest();
        boolean onErrorStopTestNow = this.getOnErrorStopTestNow();
        boolean onErrorStopThread = this.getOnErrorStopThread();
        boolean onErrorStartNextLoop = this.getOnErrorStartNextLoop();
        String groupName = this.getName();
        JMeterThread jmeterThread = new JMeterThread((HashTree)this.cloneTree(threadGroupTree), this, notifier, isSameUserOnNextIteration);
        jmeterThread.setThreadNum(threadNumber);
        jmeterThread.setThreadGroup(this);
        jmeterThread.setInitialContext(context);
        String distributedPrefix = JMeterUtils.getPropDefault("__jm.D_TG", "");
        String threadName = distributedPrefix + (distributedPrefix.isEmpty() ? "" : "-") + groupName + " " + this.groupNumber + "-" + (threadNumber + 1);
        jmeterThread.setThreadName(threadName);
        jmeterThread.setEngine(engine);
        jmeterThread.setOnErrorStopTest(onErrorStopTest);
        jmeterThread.setOnErrorStopTestNow(onErrorStopTestNow);
        jmeterThread.setOnErrorStopThread(onErrorStopThread);
        jmeterThread.setOnErrorStartNextLoop(onErrorStartNextLoop);
        return jmeterThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMeterThread addNewThread(int delay, StandardJMeterEngine engine) {
        int numThreads;
        long now = System.currentTimeMillis();
        JMeterContext context = JMeterContextService.getContext();
        Object object = this.addThreadLock;
        synchronized (object) {
            numThreads = this.getNumThreads();
            this.setNumThreads(numThreads + 1);
        }
        JMeterThread newJmThread = this.startNewThread(this.notifier, this.threadGroupTree, engine, numThreads, context, now, delay, this.isSameUserOnNextIteration());
        JMeterContextService.addTotalThreads(1);
        log.info("Started new thread in group {}", (Object)this.groupNumber);
        return newJmThread;
    }

    @Override
    public boolean stopThread(String threadName, boolean now) {
        for (Map.Entry<JMeterThread, Thread> threadEntry : this.allThreads.entrySet()) {
            JMeterThread jMeterThread = threadEntry.getKey();
            if (!jMeterThread.getThreadName().equals(threadName)) continue;
            this.stopThread(jMeterThread, threadEntry.getValue(), now);
            return true;
        }
        return false;
    }

    private void stopThread(JMeterThread jmeterThread, Thread jvmThread, boolean interrupt) {
        jmeterThread.stop();
        jmeterThread.interrupt();
        if (interrupt && jvmThread != null) {
            jvmThread.interrupt();
        }
    }

    @Override
    public void threadFinished(JMeterThread thread) {
        if (log.isDebugEnabled()) {
            log.debug("Ending thread {}", (Object)thread.getThreadName());
        }
        this.allThreads.remove(thread);
    }

    public void tellThreadsToStop(boolean now) {
        this.running = false;
        if (this.delayedStartup) {
            try {
                this.threadStarter.interrupt();
            }
            catch (Exception e) {
                log.warn("Exception occurred interrupting ThreadStarter", (Throwable)e);
            }
        }
        this.allThreads.forEach((key, value) -> this.stopThread((JMeterThread)key, (Thread)value, now));
    }

    @Override
    public void tellThreadsToStop() {
        this.tellThreadsToStop(true);
    }

    @Override
    public void stop() {
        this.running = false;
        if (this.delayedStartup) {
            try {
                this.threadStarter.interrupt();
            }
            catch (Exception e) {
                log.warn("Exception occurred interrupting ThreadStarter", (Throwable)e);
            }
        }
        ((ConcurrentHashMap.KeySetView)this.allThreads.keySet()).forEach(JMeterThread::stop);
    }

    @Override
    public int numberOfActiveThreads() {
        return this.allThreads.size();
    }

    @Override
    public boolean verifyThreadsStopped() {
        boolean stoppedAll = true;
        if (this.delayedStartup) {
            stoppedAll = this.verifyThreadStopped(this.threadStarter);
        }
        for (Thread t : this.allThreads.values()) {
            stoppedAll = stoppedAll && this.verifyThreadStopped(t);
        }
        return stoppedAll;
    }

    private boolean verifyThreadStopped(Thread thread) {
        boolean stopped = true;
        if (thread != null && thread.isAlive()) {
            try {
                thread.join(WAIT_TO_DIE);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (thread.isAlive()) {
                stopped = false;
                if (log.isWarnEnabled()) {
                    log.warn("Thread won't exit: {}", (Object)thread.getName());
                }
            }
        }
        return stopped;
    }

    @Override
    public void waitThreadsStopped() {
        if (this.delayedStartup) {
            this.waitThreadStopped(this.threadStarter);
        }
        while (!this.allThreads.isEmpty()) {
            this.allThreads.values().forEach(this::waitThreadStopped);
        }
    }

    private void waitThreadStopped(Thread thread) {
        if (thread == null) {
            return;
        }
        while (thread.isAlive()) {
            try {
                thread.join(WAIT_TO_DIE);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private ListedHashTree cloneTree(ListedHashTree tree) {
        TreeCloner cloner = new TreeCloner(true);
        tree.traverse((HashTreeTraverser)cloner);
        return cloner.getClonedTree();
    }

    class ThreadStarter
    implements Runnable {
        private final ListenerNotifier notifier;
        private final ListedHashTree threadGroupTree;
        private final StandardJMeterEngine engine;
        private final JMeterContext context;

        public ThreadStarter(ListenerNotifier notifier, ListedHashTree threadGroupTree, StandardJMeterEngine engine) {
            this.notifier = notifier;
            this.threadGroupTree = threadGroupTree;
            this.engine = engine;
            this.context = JMeterContextService.getContext();
        }

        private void pause(long ms) {
            try {
                TimeUnit.MILLISECONDS.sleep(ms);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private void delayBy(long delay) {
            if (delay > 0L) {
                long now;
                long start = System.currentTimeMillis();
                long end = start + delay;
                long pause = RAMPUP_GRANULARITY;
                while (ThreadGroup.this.running && (now = System.currentTimeMillis()) < end) {
                    long togo = end - now;
                    if (togo < pause) {
                        pause = togo;
                    }
                    this.pause(pause);
                }
            }
        }

        @Override
        public void run() {
            try {
                JMeterContextService.getContext().setVariables(this.context.getVariables());
                long endtime = 0L;
                boolean usingScheduler = ThreadGroup.this.getScheduler();
                if (usingScheduler) {
                    if (ThreadGroup.this.getDelay() > 0L) {
                        this.delayBy(ThreadGroup.this.getDelay() * 1000L);
                    }
                    if ((endtime = ThreadGroup.this.getDuration()) > 0L) {
                        endtime = endtime * 1000L + System.currentTimeMillis();
                    }
                }
                int numThreads = ThreadGroup.this.getNumThreads();
                float rampUpOriginInMillis = (float)ThreadGroup.this.getRampUp() * 1000.0f;
                long startTimeInMillis = System.currentTimeMillis();
                boolean isSameUserOnNextIteration = ThreadGroup.this.isSameUserOnNextIteration();
                for (int threadNumber = 0; ThreadGroup.this.running && threadNumber < numThreads; ++threadNumber) {
                    if (threadNumber > 0) {
                        long elapsedInMillis = System.currentTimeMillis() - startTimeInMillis;
                        int perThreadDelayInMillis = Math.round((rampUpOriginInMillis - (float)elapsedInMillis) / (float)(numThreads - threadNumber));
                        this.pause(Math.max(0, perThreadDelayInMillis));
                    }
                    if (!usingScheduler || System.currentTimeMillis() <= endtime) {
                        JMeterThread jmThread = ThreadGroup.this.makeThread(this.notifier, this.threadGroupTree, this.engine, threadNumber, this.context, isSameUserOnNextIteration);
                        jmThread.setInitialDelay(0);
                        if (usingScheduler) {
                            jmThread.setScheduled(true);
                            jmThread.setEndTime(endtime);
                        }
                        Thread newThread = new Thread((Runnable)jmThread, jmThread.getThreadName());
                        newThread.setDaemon(false);
                        ThreadGroup.this.registerStartedThread(jmThread, newThread);
                        newThread.start();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                log.error("An error occurred scheduling delay start of threads for Thread Group: {}", (Object)ThreadGroup.this.getName(), (Object)ex);
            }
        }
    }
}

