/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Help;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionHelper
extends JDialog
implements ActionListener,
ChangeListener,
LocaleChangeListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggerFactory.getLogger(FunctionHelper.class);
    private static final String GENERATE = "GENERATE";
    private static final String RESET_VARS = "RESET_VARS";
    private JLabeledChoice functionList;
    private ArgumentsPanel parameterPanel;
    private JLabeledTextField cutPasteFunction;
    private JSyntaxTextArea resultTextArea;
    private JSyntaxTextArea variablesTextArea;
    private JMeterVariables jMeterVariables = new JMeterVariables();
    private static final char ANY_NORMAL_CHAR = ' ';

    public FunctionHelper() {
    }

    public FunctionHelper(JFrame parent) {
        super(parent, JMeterUtils.getResString("function_helper_title"), false);
        this.init();
        JMeterUtils.addLocaleChangeListener(this);
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        AbstractAction escapeAction = new AbstractAction("ESCAPE"){
            private static final long serialVersionUID = -4036804004190858925L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FunctionHelper.this.setVisible(false);
            }
        };
        rootPane.getActionMap().put(escapeAction.getValue("Name"), escapeAction);
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStrokes.ESC, escapeAction.getValue("Name"));
        return rootPane;
    }

    private void init() {
        this.parameterPanel = new ArgumentsPanel(true, JMeterUtils.getResString("function_params"));
        this.initializeFunctionList();
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel comboPanel = new JPanel(new FlowLayout(1));
        comboPanel.add((Component)this.functionList);
        JButton helpButton = new JButton(JMeterUtils.getResString("help"));
        helpButton.addActionListener(new HelpListener());
        comboPanel.add(helpButton);
        this.getContentPane().add((Component)comboPanel, "North");
        this.getContentPane().add((Component)this.parameterPanel, "Center");
        VerticalPanel resultsPanel = new VerticalPanel();
        JPanel generatePanel = new JPanel(new FlowLayout(1));
        JPanel displayPanel = new JPanel(new FlowLayout(0));
        JPanel variablesPanel = new JPanel(new FlowLayout(0));
        this.cutPasteFunction = new JLabeledTextField(JMeterUtils.getResString("cut_paste_function"), 35, null, false);
        generatePanel.add((Component)this.cutPasteFunction);
        JButton generateButton = new JButton(JMeterUtils.getResString("generate"));
        generateButton.setActionCommand(GENERATE);
        generateButton.addActionListener(this);
        generatePanel.add(generateButton);
        JButton resetVarsButton = new JButton(JMeterUtils.getResString("function_helper_reset_vars"));
        resetVarsButton.setActionCommand(RESET_VARS);
        resetVarsButton.addActionListener(this);
        generatePanel.add(resetVarsButton);
        this.resultTextArea = JSyntaxTextArea.getInstance(5, 60);
        this.resultTextArea.setToolTipText(JMeterUtils.getResString("function_helper_dialog_result_warn"));
        displayPanel.add(new JLabel(JMeterUtils.getResString("result_function")));
        displayPanel.add((Component)((Object)JTextScrollPane.getInstance(this.resultTextArea)));
        this.variablesTextArea = JSyntaxTextArea.getInstance(10, 60);
        variablesPanel.add(new JLabel(JMeterUtils.getResString("function_helper_dialog_variables")));
        variablesPanel.add((Component)((Object)JTextScrollPane.getInstance(this.variablesTextArea)));
        ((Container)resultsPanel).add(generatePanel);
        ((Container)resultsPanel).add(displayPanel);
        ((Container)resultsPanel).add(variablesPanel);
        this.getContentPane().add((Component)resultsPanel, "South");
        this.pack();
        ComponentUtil.centerComponentInWindow((Component)this);
    }

    private void initializeFunctionList() {
        String[] functionNames = CompoundVariable.getFunctionNames();
        Arrays.sort(functionNames, String::compareToIgnoreCase);
        this.functionList = new JLabeledChoice(JMeterUtils.getResString("choose_function"), functionNames);
        this.functionList.addChangeListener((ChangeListener)this);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        try {
            this.initParameterPanel();
            this.getContentPane().remove(this.parameterPanel);
            this.pack();
            this.getContentPane().add((Component)this.parameterPanel, "Center");
            this.pack();
            this.validate();
            this.resultTextArea.setText("");
            this.repaint();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            log.info("Exception during stateChanged", (Throwable)ex);
        }
    }

    protected void initParameterPanel() throws InstantiationException, IllegalAccessException {
        Arguments args = new Arguments();
        Function function = CompoundVariable.getFunctionClass(this.functionList.getText()).newInstance();
        List<String> argumentDesc = function.getArgumentDesc();
        for (String help : argumentDesc) {
            args.addArgument(help, "");
        }
        this.parameterPanel.configure(args);
        this.parameterPanel.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (GENERATE.equals(actionCommand)) {
            String functionName = this.functionList.getText();
            Arguments args = (Arguments)this.parameterPanel.createTestElement();
            String functionCall = this.buildFunctionCallString(functionName, args);
            this.cutPasteFunction.setText(functionCall);
            GuiUtils.copyTextToClipboard((String)this.cutPasteFunction.getText());
            CompoundVariable function = new CompoundVariable(functionCall);
            JMeterContext threadContext = JMeterContextService.getContext();
            threadContext.setVariables(this.jMeterVariables);
            threadContext.setThreadNum(1);
            threadContext.getVariables().put("JMeterThread.last_sample_ok", "true");
            ThreadGroup threadGroup = new ThreadGroup();
            threadGroup.setName("FunctionHelper-Dialog-ThreadGroup");
            threadContext.setThreadGroup(threadGroup);
            try {
                this.resultTextArea.setText(function.execute().trim());
            }
            catch (Exception ex) {
                log.error("Error calling function {}", (Object)functionCall, (Object)ex);
                this.resultTextArea.setText(ex.getMessage() + ", \nstacktrace:\n " + ExceptionUtils.getStackTrace((Throwable)ex));
                this.resultTextArea.setCaretPosition(0);
            }
            this.variablesTextArea.setText(this.variablesToString(this.jMeterVariables));
        } else {
            this.jMeterVariables = new JMeterVariables();
            this.variablesTextArea.setText(this.variablesToString(this.jMeterVariables));
        }
    }

    private String variablesToString(JMeterVariables jMeterVariables) {
        StringBuilder sb = new StringBuilder();
        jMeterVariables.entrySet().forEach(e -> sb.append((String)e.getKey()).append("=").append(e.getValue()).append("\r\n"));
        return sb.toString();
    }

    private String buildFunctionCallString(String functionName, Arguments args) {
        StringBuilder functionCall = new StringBuilder("${");
        functionCall.append(functionName);
        if (args.getArguments().size() > 0) {
            functionCall.append("(");
            PropertyIterator iter = args.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                Argument arg = (Argument)iter.next().getObjectValue();
                if (!first) {
                    functionCall.append(",");
                }
                functionCall.append(this.escapeCommata(arg.getValue()));
                first = false;
            }
            functionCall.append(")");
        }
        functionCall.append("}");
        return functionCall.toString();
    }

    private String escapeCommata(String arg) {
        int level = 0;
        StringBuilder result = new StringBuilder(arg.length());
        try (StringReader r = new StringReader(arg);){
            int c;
            int lastChar = 32;
            while ((c = ((Reader)r).read()) != -1) {
                char nextChar = (char)c;
                if (lastChar == 92) {
                    lastChar = 32;
                } else if (lastChar == 36 && nextChar == '{') {
                    ++level;
                    lastChar = 32;
                } else if (nextChar == '}') {
                    --level;
                    lastChar = 32;
                } else if (nextChar == ',' && level == 0) {
                    result.append('\\');
                    lastChar = 32;
                } else {
                    lastChar = nextChar;
                }
                result.append(nextChar);
            }
        }
        catch (IOException e) {
            log.warn("Can't escape commata in input string: {}", (Object)arg, (Object)e);
            return arg;
        }
        return result.toString();
    }

    @Override
    public void localeChanged(LocaleChangeEvent event) {
        this.setTitle(JMeterUtils.getResString("function_helper_title"));
        this.getContentPane().removeAll();
        this.init();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.initParameterPanel();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                log.error("Error initializing parameter panel", (Throwable)ex);
            }
        }
    }

    private class HelpListener
    implements ActionListener {
        private HelpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] source = new String[]{Help.HELP_FUNCTIONS, FunctionHelper.this.functionList.getText()};
            ActionRouter.getInstance().doActionNow(new ActionEvent(source, e.getID(), "help"));
        }
    }
}

