/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.temporal.ChronoField;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsSecond<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final int expected;
    private final TemporalAdapter<T> accessor;

    public IsSecond(int expected, TemporalAdapter<T> accessor) {
        this.expected = expected;
        this.accessor = accessor;
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        int actualSecond = this.accessor.asTemporal(actual).get(ChronoField.SECOND_OF_MINUTE);
        if (this.expected != actualSecond) {
            mismatchDescription.appendText("the date has the second " + actualSecond);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date has the second " + this.expected);
    }
}

