/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSampleListenerWrapper
extends AbstractTestElement
implements SampleListener,
Serializable,
NoThreadClone {
    private static final Logger log = LoggerFactory.getLogger(RemoteSampleListenerWrapper.class);
    private static final long serialVersionUID = 241L;
    private RemoteSampleListener listener;

    public RemoteSampleListenerWrapper(RemoteSampleListener l) {
        this.listener = l;
    }

    public RemoteSampleListenerWrapper() {
    }

    @Override
    public void sampleOccurred(SampleEvent e) {
        try {
            this.listener.sampleOccurred(e);
        }
        catch (RemoteException err) {
            log.error("RemoteException while handling sample occurred event.", (Throwable)err);
        }
    }

    @Override
    public void sampleStarted(SampleEvent e) {
        try {
            this.listener.sampleStarted(e);
        }
        catch (RemoteException err) {
            log.error("RemoteException while handling sample started event.", (Throwable)err);
        }
    }

    @Override
    public void sampleStopped(SampleEvent e) {
        try {
            this.listener.sampleStopped(e);
        }
        catch (RemoteException err) {
            log.error("RemoteException while handling sample stopped event.", (Throwable)err);
        }
    }
}

