/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=2)
public class HeaderPanel
extends AbstractConfigGui
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(HeaderPanel.class);
    private static final long serialVersionUID = 241L;
    private static final String CLIPBOARD_LINE_DELIMITER = "\n";
    private static final String CLIPBOARD_COLON_DELIMITER = ":";
    private static final String CLIPBOARD_TAB_DELIMITER = "\t";
    private static final String ADD_COMMAND = "Add";
    private static final String DELETE_COMMAND = "Delete";
    private static final String LOAD_COMMAND = "Load";
    private static final String SAVE_COMMAND = "Save";
    private static final String ADD_FROM_CLIPBOARD = "addFromClipboard";
    private final InnerTableModel tableModel;
    private final HeaderManager headerManager = new HeaderManager();
    private JTable headerTable;
    private JButton deleteButton;
    private JButton saveButton;

    public HeaderPanel() {
        this.tableModel = new InnerTableModel(this.headerManager);
        this.init();
    }

    public TestElement createTestElement() {
        this.configureTestElement((TestElement)this.headerManager);
        return (TestElement)this.headerManager.clone();
    }

    public void modifyTestElement(TestElement el) {
        GuiUtils.stopTableEditing((JTable)this.headerTable);
        el.clear();
        el.addTestElement((TestElement)this.headerManager);
        this.configureTestElement(el);
    }

    public void clearGui() {
        super.clearGui();
        this.tableModel.clearData();
        this.deleteButton.setEnabled(false);
        this.saveButton.setEnabled(false);
    }

    public void configure(TestElement el) {
        this.headerManager.clear();
        super.configure(el);
        this.headerManager.addTestElement(el);
        this.checkButtonsStatus();
    }

    public String getLabelResource() {
        return "header_manager_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.add(this.createHeaderTablePanel(), "Center");
    }

    private void checkButtonsStatus() {
        if (this.tableModel.getRowCount() == 0) {
            this.deleteButton.setEnabled(false);
            this.saveButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
            this.saveButton.setEnabled(true);
        }
    }

    protected void deleteRows() {
        GuiUtils.cancelEditing((JTable)this.headerTable);
        int[] rowsSelected = this.headerTable.getSelectedRows();
        int anchorSelection = this.headerTable.getSelectionModel().getAnchorSelectionIndex();
        this.headerTable.clearSelection();
        if (rowsSelected.length > 0) {
            for (int i = rowsSelected.length - 1; i >= 0; --i) {
                this.tableModel.removeRow(rowsSelected[i]);
            }
            this.tableModel.fireTableDataChanged();
            if (this.tableModel.getRowCount() > 0) {
                if (anchorSelection >= this.tableModel.getRowCount()) {
                    anchorSelection = this.tableModel.getRowCount() - 1;
                }
                this.headerTable.setRowSelectionInterval(anchorSelection, anchorSelection);
            }
            this.checkButtonsStatus();
        } else if (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
            this.tableModel.fireTableDataChanged();
            this.headerTable.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(DELETE_COMMAND)) {
            this.deleteRows();
        } else if (action.equals(ADD_COMMAND)) {
            GuiUtils.stopTableEditing((JTable)this.headerTable);
            this.tableModel.addNewRow();
            this.tableModel.fireTableDataChanged();
            this.checkButtonsStatus();
            int rowToSelect = this.tableModel.getRowCount() - 1;
            this.headerTable.setRowSelectionInterval(rowToSelect, rowToSelect);
        } else if (action.equals(LOAD_COMMAND)) {
            try {
                JFileChooser chooser = FileDialoger.promptToOpenFile();
                if (chooser != null) {
                    this.headerManager.addFile(chooser.getSelectedFile().getAbsolutePath());
                    this.tableModel.fireTableDataChanged();
                    this.checkButtonsStatus();
                }
            }
            catch (IOException ex) {
                log.error("Could not load headers", (Throwable)ex);
            }
        } else if (action.equals(SAVE_COMMAND)) {
            try {
                JFileChooser chooser = FileDialoger.promptToSaveFile(null);
                if (chooser != null) {
                    this.headerManager.save(chooser.getSelectedFile().getAbsolutePath());
                }
            }
            catch (IOException ex) {
                JMeterUtils.reportErrorToUser((String)ex.getMessage(), (String)"Error saving headers");
            }
        } else if (action.equals(ADD_FROM_CLIPBOARD)) {
            this.addFromClipboard();
        }
    }

    protected void addFromClipboard() {
        GuiUtils.stopTableEditing((JTable)this.headerTable);
        int rowCount = this.headerTable.getRowCount();
        try {
            String[] clipboardLines;
            String clipboardContent = GuiUtils.getPastedText();
            if (clipboardContent == null) {
                return;
            }
            for (String clipboardLine : clipboardLines = clipboardContent.split(CLIPBOARD_LINE_DELIMITER)) {
                int index = clipboardLine.indexOf(CLIPBOARD_COLON_DELIMITER);
                if (index < 0) {
                    index = clipboardLine.indexOf(CLIPBOARD_TAB_DELIMITER);
                }
                if (index <= 0) continue;
                Header header = new Header(clipboardLine.substring(0, index).trim(), clipboardLine.substring(index + 1).trim());
                this.headerManager.add(header);
            }
            this.tableModel.fireTableDataChanged();
            if (this.headerTable.getRowCount() > rowCount) {
                int rowToSelect = this.tableModel.getRowCount() - 1;
                this.headerTable.setRowSelectionInterval(rowCount, rowToSelect);
            }
            this.checkButtonsStatus();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Could not add read headers from clipboard:\n" + ioe.getLocalizedMessage(), "Error", 0);
        }
        catch (UnsupportedFlavorException ufe) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Could not add retrieved " + DataFlavor.stringFlavor.getHumanPresentableName() + " from clipboard" + ufe.getLocalizedMessage(), "Error", 0);
        }
    }

    public JPanel createHeaderTablePanel() {
        this.headerTable = new JTable(this.tableModel);
        JMeterUtils.applyHiDPI((JTable)this.headerTable);
        this.headerTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.headerTable.setSelectionMode(2);
        this.headerTable.setPreferredScrollableViewportSize(new Dimension(100, 70));
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"headers_stored")));
        panel.add((Component)GuiUtils.emptyBorder((JComponent)new JScrollPane(this.headerTable)), "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        return panel;
    }

    private JButton createButton(String resName, char mnemonic, String command, boolean enabled) {
        JButton button = new JButton(JMeterUtils.getResString((String)resName));
        button.setMnemonic(mnemonic);
        button.setActionCommand(command);
        button.setEnabled(enabled);
        button.addActionListener(this);
        return button;
    }

    private JPanel createButtonPanel() {
        boolean tableEmpty = this.tableModel.getRowCount() == 0;
        JButton addButton = this.createButton("add", 'A', ADD_COMMAND, true);
        this.deleteButton = this.createButton("delete", 'D', DELETE_COMMAND, !tableEmpty);
        JButton loadButton = this.createButton("load", 'L', LOAD_COMMAND, true);
        this.saveButton = this.createButton("save", 'S', SAVE_COMMAND, !tableEmpty);
        JButton addFromClipboard = this.createButton("add_from_clipboard", 'C', ADD_FROM_CLIPBOARD, true);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(addButton);
        buttonPanel.add(addFromClipboard);
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(loadButton);
        buttonPanel.add(this.saveButton);
        return buttonPanel;
    }

    private static class InnerTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 240L;
        private HeaderManager manager;

        public InnerTableModel(HeaderManager man) {
            this.manager = man;
        }

        public void clearData() {
            this.manager.clear();
            this.fireTableDataChanged();
        }

        public void removeRow(int row) {
            this.manager.remove(row);
        }

        public void addNewRow() {
            this.manager.add();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        @Override
        public int getRowCount() {
            return this.manager.getHeaders().size();
        }

        @Override
        public int getColumnCount() {
            return this.manager.getColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            return this.manager.getColumnName(column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            Header head = this.manager.getHeader(row);
            if (column == 0) {
                return head.getName();
            }
            if (column == 1) {
                return head.getValue();
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Header header = this.manager.getHeader(row);
            if (column == 0) {
                header.setName((String)value);
            } else if (column == 1) {
                header.setValue((String)value);
            }
        }
    }
}

