/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.SumAggregatorFactory;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.report.processor.graph.AbstractGraphConsumer;
import org.apache.jmeter.report.processor.graph.AbstractSeriesSelector;
import org.apache.jmeter.report.processor.graph.CountValueSelector;
import org.apache.jmeter.report.processor.graph.GraphKeysSelector;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.SeriesData;
import org.apache.jmeter.util.JMeterUtils;

public class SyntheticResponseTimeDistributionGraphConsumer
extends AbstractGraphConsumer {
    private static final String FAILED_LABEL = JMeterUtils.getResString("response_time_distribution_failed_label");
    private static final MessageFormat SATISFIED_LABEL = new MessageFormat(JMeterUtils.getResString("response_time_distribution_satisfied_label"));
    private static final MessageFormat TOLERATED_LABEL = new MessageFormat(JMeterUtils.getResString("response_time_distribution_tolerated_label"));
    private static final MessageFormat UNTOLERATED_LABEL = new MessageFormat(JMeterUtils.getResString("response_time_distribution_untolerated_label"));
    private static final String SERIE_COLOR_PROPERTY = "color";
    private static final String SATISFIED_COLOR = "#9ACD32";
    private static final String TOLERATED_COLOR = "yellow";
    private static final String UNTOLERATED_COLOR = "orange";
    private static final String FAILED_COLOR = "#FF6347";
    private long satisfiedThreshold;
    private long toleratedThreshold;
    List<String> satisfiedLabels = Collections.emptyList();
    List<String> toleratedLabels = Collections.emptyList();
    List<String> untoleratedLabels = Collections.emptyList();

    @Override
    protected final GraphKeysSelector createKeysSelector() {
        return new GraphKeysSelector(){

            @Override
            public Double select(Sample sample) {
                if (sample.getSuccess()) {
                    long elapsedTime = sample.getElapsedTime();
                    if (elapsedTime <= SyntheticResponseTimeDistributionGraphConsumer.this.satisfiedThreshold) {
                        return 0.0;
                    }
                    if (elapsedTime <= SyntheticResponseTimeDistributionGraphConsumer.this.toleratedThreshold) {
                        return 1.0;
                    }
                    return 2.0;
                }
                return 3.0;
            }
        };
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        HashMap<String, GroupInfo> groupInfos = new HashMap<String, GroupInfo>(1);
        SyntheticSeriesSelector syntheticSeriesSelector = new SyntheticSeriesSelector();
        groupInfos.put("Generic group", new GroupInfo(new SumAggregatorFactory(), syntheticSeriesSelector, new CountValueSelector(true), false, false));
        return groupInfos;
    }

    @Override
    protected void initializeExtraResults(MapResultData parentResult) {
        ListResultData listResultData = new ListResultData();
        String[] seriesLabels = new String[]{SATISFIED_LABEL.format(new Object[]{this.getSatisfiedThreshold()}), TOLERATED_LABEL.format(new Object[]{this.getSatisfiedThreshold(), this.getToleratedThreshold()}), UNTOLERATED_LABEL.format(new Object[]{this.getToleratedThreshold()}), FAILED_LABEL};
        String[] colors = new String[]{SATISFIED_COLOR, TOLERATED_COLOR, UNTOLERATED_COLOR, FAILED_COLOR};
        for (int i = 0; i < seriesLabels.length; ++i) {
            ListResultData array = new ListResultData();
            array.addResult(new ValueResultData(i));
            array.addResult(new ValueResultData(seriesLabels[i]));
            listResultData.addResult(array);
        }
        parentResult.setResult("ticks", listResultData);
        this.initializeSeries(parentResult, seriesLabels, colors);
    }

    private void initializeSeries(MapResultData parentResult, String[] series, String[] colors) {
        ListResultData listResultData = (ListResultData)parentResult.getResult("series");
        for (int i = 0; i < series.length; ++i) {
            listResultData.addResult(this.create(series[i], colors[i]));
        }
    }

    private MapResultData create(String serie, String color) {
        GroupInfo groupInfo = this.getGroupInfos().get("Generic group");
        SeriesData seriesData = new SeriesData(groupInfo.getAggregatorFactory(), groupInfo.enablesAggregatedKeysSeries(), false, groupInfo.enablesOverallSeries());
        MapResultData seriesResult = this.createSerieResult(serie, seriesData);
        seriesResult.setResult(SERIE_COLOR_PROPERTY, new ValueResultData(color));
        return seriesResult;
    }

    public long getSatisfiedThreshold() {
        return this.satisfiedThreshold;
    }

    public void setSatisfiedThreshold(long satisfiedThreshold) {
        this.satisfiedThreshold = satisfiedThreshold;
        this.formatLabels();
    }

    public long getToleratedThreshold() {
        return this.toleratedThreshold;
    }

    public void setToleratedThreshold(long toleratedThreshold) {
        this.toleratedThreshold = toleratedThreshold;
        this.formatLabels();
    }

    private void formatLabels() {
        this.satisfiedLabels = Collections.singletonList(SATISFIED_LABEL.format(new Object[]{this.satisfiedThreshold}));
        this.toleratedLabels = Collections.singletonList(TOLERATED_LABEL.format(new Object[]{this.satisfiedThreshold, this.toleratedThreshold}));
        this.untoleratedLabels = Collections.singletonList(UNTOLERATED_LABEL.format(new Object[]{this.toleratedThreshold}));
    }

    private class SyntheticSeriesSelector
    extends AbstractSeriesSelector {
        private SyntheticSeriesSelector() {
        }

        @Override
        public Iterable<String> select(Sample sample) {
            if (!sample.getSuccess()) {
                return Arrays.asList(FAILED_LABEL);
            }
            long elapsedTime = sample.getElapsedTime();
            if (elapsedTime <= SyntheticResponseTimeDistributionGraphConsumer.this.getSatisfiedThreshold()) {
                return SyntheticResponseTimeDistributionGraphConsumer.this.satisfiedLabels;
            }
            if (elapsedTime <= SyntheticResponseTimeDistributionGraphConsumer.this.getToleratedThreshold()) {
                return SyntheticResponseTimeDistributionGraphConsumer.this.toleratedLabels;
            }
            return SyntheticResponseTimeDistributionGraphConsumer.this.untoleratedLabels;
        }
    }
}

