/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.dashboard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.jmeter.report.config.ConfigurationException;
import org.apache.jmeter.report.config.ExporterConfiguration;
import org.apache.jmeter.report.config.GraphConfiguration;
import org.apache.jmeter.report.config.ReportGeneratorConfiguration;
import org.apache.jmeter.report.core.ControllerSamplePredicate;
import org.apache.jmeter.report.core.ConvertException;
import org.apache.jmeter.report.core.Converters;
import org.apache.jmeter.report.core.SampleException;
import org.apache.jmeter.report.core.StringConverter;
import org.apache.jmeter.report.dashboard.DataExporter;
import org.apache.jmeter.report.dashboard.ExportException;
import org.apache.jmeter.report.dashboard.GenerationException;
import org.apache.jmeter.report.processor.AggregateConsumer;
import org.apache.jmeter.report.processor.ApdexSummaryConsumer;
import org.apache.jmeter.report.processor.ApdexThresholdsInfo;
import org.apache.jmeter.report.processor.CsvFileSampleSource;
import org.apache.jmeter.report.processor.ErrorsSummaryConsumer;
import org.apache.jmeter.report.processor.FilterConsumer;
import org.apache.jmeter.report.processor.MaxAggregator;
import org.apache.jmeter.report.processor.MinAggregator;
import org.apache.jmeter.report.processor.NormalizerSampleConsumer;
import org.apache.jmeter.report.processor.RequestsSummaryConsumer;
import org.apache.jmeter.report.processor.SampleConsumer;
import org.apache.jmeter.report.processor.SampleContext;
import org.apache.jmeter.report.processor.StatisticsSummaryConsumer;
import org.apache.jmeter.report.processor.Top5ErrorsBySamplerConsumer;
import org.apache.jmeter.report.processor.graph.AbstractGraphConsumer;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGenerator {
    private static final String REPORTGENERATOR_PROPERTIES = "reportgenerator.properties";
    private static final Logger log = LoggerFactory.getLogger(ReportGenerator.class);
    private static final boolean CSV_OUTPUT_FORMAT = "csv".equalsIgnoreCase(JMeterUtils.getPropDefault("jmeter.save.saveservice.output_format", "csv"));
    private static final char CSV_DEFAULT_SEPARATOR = JMeterUtils.getDelimiter(JMeterUtils.getJMeterProperties().getProperty("jmeter.save.saveservice.default_delimiter", ",")).charAt(0);
    private static final String INVALID_CLASS_FMT = "Class name \"%s\" is not valid.";
    private static final String INVALID_EXPORT_FMT = "Data exporter \"%s\" is unable to export data.";
    private static final String NOT_SUPPORTED_CONVERSION_FMT = "Not supported conversion to \"%s\"";
    public static final String NORMALIZER_CONSUMER_NAME = "normalizer";
    public static final String BEGIN_DATE_CONSUMER_NAME = "beginDate";
    public static final String END_DATE_CONSUMER_NAME = "endDate";
    public static final String NAME_FILTER_CONSUMER_NAME = "nameFilter";
    public static final String DATE_RANGE_FILTER_CONSUMER_NAME = "dateRangeFilter";
    public static final String APDEX_SUMMARY_CONSUMER_NAME = "apdexSummary";
    public static final String ERRORS_SUMMARY_CONSUMER_NAME = "errorsSummary";
    public static final String REQUESTS_SUMMARY_CONSUMER_NAME = "requestsSummary";
    public static final String STATISTICS_SUMMARY_CONSUMER_NAME = "statisticsSummary";
    public static final String TOP5_ERRORS_BY_SAMPLER_CONSUMER_NAME = "top5ErrorsBySampler";
    public static final String START_INTERVAL_CONTROLLER_FILTER_CONSUMER_NAME = "startIntervalControlerFilter";
    private static final java.util.regex.Pattern POTENTIAL_CAMEL_CASE_PATTERN = java.util.regex.Pattern.compile("_(.)");
    private final File testFile;
    private final ReportGeneratorConfiguration configuration;
    private final ResultCollector resultCollector;

    public ReportGenerator(String resultsFile, ResultCollector resultCollector) throws ConfigurationException {
        if (!CSV_OUTPUT_FORMAT) {
            throw new IllegalArgumentException("Report generation requires csv output format, check 'jmeter.save.saveservice.output_format' property");
        }
        log.info("ReportGenerator will use for Parsing the separator: '{}'", (Object)Character.valueOf(CSV_DEFAULT_SEPARATOR));
        File file = new File(resultsFile);
        if (resultCollector == null) {
            if (!file.isFile() || !file.canRead()) {
                throw new IllegalArgumentException(String.format("Cannot read test results file : %s", file));
            }
            log.info("Will only generate report from results file: {}", (Object)resultsFile);
        } else {
            if (file.exists() && file.length() > 0L) {
                throw new IllegalArgumentException("Results file:" + resultsFile + " is not empty");
            }
            log.info("Will generate report at end of test from  results file: {}", (Object)resultsFile);
        }
        this.resultCollector = resultCollector;
        this.testFile = file;
        Properties merged = new Properties();
        File rgp = new File(JMeterUtils.getJMeterBinDir(), REPORTGENERATOR_PROPERTIES);
        if (log.isInfoEnabled()) {
            log.info("Reading report generator properties from: {}", (Object)rgp.getAbsolutePath());
        }
        merged.putAll((Map<?, ?>)ReportGenerator.loadProps(rgp));
        log.info("Merging with JMeter properties");
        merged.putAll((Map<?, ?>)JMeterUtils.getJMeterProperties());
        this.configuration = ReportGeneratorConfiguration.loadFromProperties(merged);
    }

    private static Properties loadProps(File file) {
        Properties props = new Properties();
        try (FileInputStream inStream = new FileInputStream(file);){
            props.load(inStream);
        }
        catch (IOException e) {
            log.error("Problem loading properties from file.", (Throwable)e);
            System.err.println("Problem loading properties. " + e);
        }
        return props;
    }

    private static String getSetterName(String propertyKey) {
        Matcher matcher = POTENTIAL_CAMEL_CASE_PATTERN.matcher(propertyKey);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public void generate() throws GenerationException {
        if (this.resultCollector != null) {
            log.info("Flushing result collector before report Generation");
            this.resultCollector.flushFile();
        }
        log.debug("Start report generation");
        File tmpDir = this.configuration.getTempDirectory();
        boolean tmpDirCreated = this.createTempDir(tmpDir);
        SampleContext sampleContext = new SampleContext();
        sampleContext.setWorkingDirectory(tmpDir);
        CsvFileSampleSource source = new CsvFileSampleSource(this.testFile, CSV_DEFAULT_SEPARATOR);
        source.setSampleContext(sampleContext);
        NormalizerSampleConsumer normalizer = new NormalizerSampleConsumer();
        normalizer.setName(NORMALIZER_CONSUMER_NAME);
        FilterConsumer dateRangeConsumer = this.createFilterByDateRange();
        dateRangeConsumer.addSampleConsumer(this.createBeginDateConsumer());
        dateRangeConsumer.addSampleConsumer(this.createEndDateConsumer());
        FilterConsumer nameFilter = this.createNameFilter();
        FilterConsumer excludeControllerFilter = this.createExcludeControllerFilter();
        nameFilter.addSampleConsumer(excludeControllerFilter);
        dateRangeConsumer.addSampleConsumer(nameFilter);
        normalizer.addSampleConsumer(dateRangeConsumer);
        source.addSampleConsumer(normalizer);
        Map<String, GraphConfiguration> graphConfigurations = this.configuration.getGraphConfigurations();
        for (Map.Entry<String, GraphConfiguration> entryGraphCfg : graphConfigurations.entrySet()) {
            this.addGraphConsumer(nameFilter, excludeControllerFilter, entryGraphCfg);
        }
        log.debug("Start samples processing");
        try {
            source.run();
        }
        catch (SampleException ex) {
            throw new GenerationException("Error while processing samples:" + ex.getMessage(), ex);
        }
        log.debug("End of samples processing");
        log.debug("Start data exporting");
        for (Map.Entry<String, ExporterConfiguration> entry : this.configuration.getExportConfigurations().entrySet()) {
            String key = entry.getKey();
            ExporterConfiguration value = entry.getValue();
            if (log.isInfoEnabled()) {
                log.info("Exporting data using exporter:'{}' of className:'{}'", (Object)key, (Object)value.getClassName());
            }
            this.exportData(sampleContext, key, value);
        }
        log.debug("End of data exporting");
        this.removeTempDir(tmpDir, tmpDirCreated);
        log.debug("End of report generation");
    }

    private FilterConsumer createFilterByDateRange() {
        FilterConsumer dateRangeFilter = new FilterConsumer();
        dateRangeFilter.setName(DATE_RANGE_FILTER_CONSUMER_NAME);
        dateRangeFilter.setSamplePredicate(sample -> {
            long sampleStartTime = sample.getStartTime();
            if (this.configuration.getStartDate() != null) {
                if (sampleStartTime >= this.configuration.getStartDate().getTime()) {
                    if (this.configuration.getEndDate() != null) {
                        return sampleStartTime <= this.configuration.getEndDate().getTime();
                    }
                    return true;
                }
                return false;
            }
            if (this.configuration.getEndDate() != null) {
                return sampleStartTime <= this.configuration.getEndDate().getTime();
            }
            return true;
        });
        return dateRangeFilter;
    }

    private void removeTempDir(File tmpDir, boolean tmpDirCreated) {
        if (tmpDirCreated) {
            try {
                FileUtils.deleteDirectory((File)tmpDir);
            }
            catch (IOException ex) {
                log.warn("Cannot delete created temporary directory, '{}'.", (Object)tmpDir, (Object)ex);
            }
        }
    }

    private boolean createTempDir(File tmpDir) throws GenerationException {
        boolean tmpDirCreated = false;
        if (!tmpDir.exists() && !(tmpDirCreated = tmpDir.mkdir())) {
            String message = String.format("Cannot create temporary directory \"%s\", check property \"%s\"", tmpDir.getAbsolutePath(), "jmeter.reportgenerator.temp_dir");
            log.error(message);
            throw new GenerationException(message);
        }
        return tmpDirCreated;
    }

    private void addGraphConsumer(FilterConsumer nameFilter, FilterConsumer excludeControllerFilter, Map.Entry<String, GraphConfiguration> entryGraphCfg) throws GenerationException {
        String graphName = entryGraphCfg.getKey();
        GraphConfiguration graphConfiguration = entryGraphCfg.getValue();
        String className = graphConfiguration.getClassName();
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            AbstractGraphConsumer graph = (AbstractGraphConsumer)obj;
            graph.setName(graphName);
            graph.setTitle(graphConfiguration.getTitle());
            Method[] methods = clazz.getMethods();
            for (Map.Entry<String, String> entryProperty : graphConfiguration.getProperties().entrySet()) {
                String propertyName = entryProperty.getKey();
                String propertyValue = entryProperty.getValue();
                String setterName = ReportGenerator.getSetterName(propertyName);
                this.setProperty(className, obj, methods, propertyName, propertyValue, setterName);
            }
            graph.initialize();
            FilterConsumer entryPoint = graphConfiguration.excludesControllers() ? excludeControllerFilter : nameFilter;
            entryPoint.addSampleConsumer(graph);
        }
        catch (ClassCastException | IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
            String error = String.format(INVALID_CLASS_FMT, className);
            log.error(error, (Throwable)ex);
            throw new GenerationException(error, ex);
        }
    }

    private void exportData(SampleContext sampleContext, String exporterName, ExporterConfiguration exporterConfiguration) throws GenerationException {
        String className = exporterConfiguration.getClassName();
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DataExporter exporter = (DataExporter)obj;
            exporter.setName(exporterName);
            exporter.export(sampleContext, this.testFile, this.configuration);
        }
        catch (ClassCastException | ReflectiveOperationException ex) {
            String error = String.format(INVALID_CLASS_FMT, className);
            throw new GenerationException(error, ex);
        }
        catch (ExportException ex) {
            String error = String.format(INVALID_EXPORT_FMT, exporterName);
            throw new GenerationException(error, ex);
        }
    }

    private ErrorsSummaryConsumer createErrorsSummaryConsumer() {
        ErrorsSummaryConsumer errorsSummaryConsumer = new ErrorsSummaryConsumer();
        errorsSummaryConsumer.setName(ERRORS_SUMMARY_CONSUMER_NAME);
        return errorsSummaryConsumer;
    }

    private FilterConsumer createExcludeControllerFilter() {
        FilterConsumer excludeControllerFilter = new FilterConsumer();
        excludeControllerFilter.setName(START_INTERVAL_CONTROLLER_FILTER_CONSUMER_NAME);
        excludeControllerFilter.setSamplePredicate(new ControllerSamplePredicate());
        excludeControllerFilter.setReverseFilter(true);
        excludeControllerFilter.addSampleConsumer(this.createErrorsSummaryConsumer());
        return excludeControllerFilter;
    }

    private SampleConsumer createTop5ErrorsConsumer(ReportGeneratorConfiguration configuration) {
        Top5ErrorsBySamplerConsumer top5ErrorsBySamplerConsumer = new Top5ErrorsBySamplerConsumer();
        top5ErrorsBySamplerConsumer.setName(TOP5_ERRORS_BY_SAMPLER_CONSUMER_NAME);
        top5ErrorsBySamplerConsumer.setHasOverallResult(true);
        top5ErrorsBySamplerConsumer.setIgnoreTransactionController(configuration.isIgnoreTCFromTop5ErrorsBySampler());
        return top5ErrorsBySamplerConsumer;
    }

    private StatisticsSummaryConsumer createStatisticsSummaryConsumer() {
        StatisticsSummaryConsumer statisticsSummaryConsumer = new StatisticsSummaryConsumer();
        statisticsSummaryConsumer.setName(STATISTICS_SUMMARY_CONSUMER_NAME);
        statisticsSummaryConsumer.setHasOverallResult(true);
        return statisticsSummaryConsumer;
    }

    private RequestsSummaryConsumer createRequestsSummaryConsumer() {
        RequestsSummaryConsumer requestsSummaryConsumer = new RequestsSummaryConsumer();
        requestsSummaryConsumer.setName(REQUESTS_SUMMARY_CONSUMER_NAME);
        return requestsSummaryConsumer;
    }

    private ApdexSummaryConsumer createApdexSummaryConsumer() {
        ApdexSummaryConsumer apdexSummaryConsumer = new ApdexSummaryConsumer();
        apdexSummaryConsumer.setName(APDEX_SUMMARY_CONSUMER_NAME);
        apdexSummaryConsumer.setHasOverallResult(true);
        apdexSummaryConsumer.setThresholdSelector(sampleName -> {
            ApdexThresholdsInfo info = new ApdexThresholdsInfo();
            info.setSatisfiedThreshold(this.configuration.getApdexSatisfiedThreshold());
            info.setToleratedThreshold(this.configuration.getApdexToleratedThreshold());
            for (Map.Entry<String, Long[]> entry : this.configuration.getApdexPerTransaction().entrySet()) {
                Pattern regex = JMeterUtils.getPatternCache().getPattern(entry.getKey());
                Perl5Matcher matcher = JMeterUtils.getMatcher();
                if (sampleName == null || !matcher.matches(sampleName, regex)) continue;
                Long satisfied = entry.getValue()[0];
                Long tolerated = entry.getValue()[1];
                if (log.isDebugEnabled()) {
                    log.debug("Found match for sampleName:{}, Regex:{}, satisfied value:{}, tolerated value:{}", new Object[]{sampleName, entry.getKey(), satisfied, tolerated});
                }
                info.setSatisfiedThreshold(satisfied);
                info.setToleratedThreshold(tolerated);
                break;
            }
            return info;
        });
        return apdexSummaryConsumer;
    }

    private FilterConsumer createNameFilter() {
        FilterConsumer nameFilter = new FilterConsumer();
        nameFilter.setName(NAME_FILTER_CONSUMER_NAME);
        nameFilter.setSamplePredicate(sample -> {
            java.util.regex.Pattern filteredSamplesPattern = this.configuration.getFilteredSamplesPattern();
            return filteredSamplesPattern == null || filteredSamplesPattern.matcher(sample.getName()).matches();
        });
        nameFilter.addSampleConsumer(this.createApdexSummaryConsumer());
        nameFilter.addSampleConsumer(this.createRequestsSummaryConsumer());
        nameFilter.addSampleConsumer(this.createStatisticsSummaryConsumer());
        nameFilter.addSampleConsumer(this.createTop5ErrorsConsumer(this.configuration));
        return nameFilter;
    }

    private AggregateConsumer createEndDateConsumer() {
        AggregateConsumer endDateConsumer = new AggregateConsumer(new MaxAggregator(), sample -> sample.getEndTime());
        endDateConsumer.setName(END_DATE_CONSUMER_NAME);
        return endDateConsumer;
    }

    private AggregateConsumer createBeginDateConsumer() {
        AggregateConsumer beginDateConsumer = new AggregateConsumer(new MinAggregator(), sample -> sample.getStartTime());
        beginDateConsumer.setName(BEGIN_DATE_CONSUMER_NAME);
        return beginDateConsumer;
    }

    private void setProperty(String className, Object obj, Method[] methods, String propertyName, String propertyValue, String setterName) throws IllegalAccessException, GenerationException {
        try {
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] parameterTypes;
                Method method = methods[i];
                if (!method.getName().equals(setterName) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
                Class<String> parameterType = parameterTypes[0];
                if (parameterType.isAssignableFrom(String.class)) {
                    method.invoke(obj, propertyValue);
                } else {
                    StringConverter<?> converter = Converters.getConverter(parameterType);
                    if (converter == null) {
                        throw new GenerationException(String.format(NOT_SUPPORTED_CONVERSION_FMT, parameterType.getName()));
                    }
                    method.invoke(obj, converter.convert(propertyValue));
                }
                return;
            }
            log.warn("'{}' is not a valid property for class '{}', skip it", (Object)propertyName, (Object)className);
        }
        catch (InvocationTargetException | ConvertException ex) {
            String message = String.format("Cannot assign \"%s\" to property \"%s\" (mapped as \"%s\"), skip it", propertyValue, propertyName, setterName);
            log.error(message, (Throwable)ex);
            throw new GenerationException(message, ex);
        }
    }
}

