/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.config;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import jodd.props.Props;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.report.config.ConfigurationException;
import org.apache.jmeter.report.config.ConfigurationUtils;
import org.apache.jmeter.report.config.ExporterConfiguration;
import org.apache.jmeter.report.config.GraphConfiguration;
import org.apache.jmeter.report.config.SubConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGeneratorConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ReportGeneratorConfiguration.class);
    private static final String RANGE_DATE_FORMAT_DEFAULT = "yyyyMMddHHmmss";
    public static final char KEY_DELIMITER = '.';
    public static final String REPORT_GENERATOR_KEY_PREFIX = "jmeter.reportgenerator";
    public static final String REPORT_GENERATOR_KEY_RANGE_DATE_FORMAT = "jmeter.reportgenerator.date_format";
    public static final String REPORT_GENERATOR_GRAPH_KEY_PREFIX = "jmeter.reportgenerator.graph";
    public static final String REPORT_GENERATOR_EXPORTER_KEY_PREFIX = "jmeter.reportgenerator.exporter";
    public static final String REPORT_GENERATOR_KEY_TEMP_DIR = "jmeter.reportgenerator.temp_dir";
    private static final File REPORT_GENERATOR_KEY_TEMP_DIR_DEFAULT = new File("temp");
    private static final String REPORT_GENERATOR_KEY_APDEX_SATISFIED_THRESHOLD = "jmeter.reportgenerator.apdex_satisfied_threshold";
    private static final Long REPORT_GENERATOR_KEY_APDEX_SATISFIED_THRESHOLD_DEFAULT = 500L;
    private static final String REPORT_GENERATOR_KEY_APDEX_TOLERATED_THRESHOLD = "jmeter.reportgenerator.apdex_tolerated_threshold";
    private static final Long REPORT_GENERATOR_KEY_APDEX_TOLERATED_THRESHOLD_DEFAULT = 1500L;
    private static final String REPORT_GENERATOR_KEY_APDEX_PER_TRANSACTION = "jmeter.reportgenerator.apdex_per_transaction";
    private static final String REPORT_GENERATOR_KEY_EXCLUDE_TC_FROM_TOP5_ERRORS_BY_SAMPLER = "jmeter.reportgenerator.exclude_tc_from_top5_errors_by_sampler";
    private static final String REPORT_GENERATOR_KEY_SAMPLE_FILTER = "jmeter.reportgenerator.sample_filter";
    private static final String REPORT_GENERATOR_KEY_REPORT_TITLE = "jmeter.reportgenerator.report_title";
    private static final String REPORT_GENERATOR_KEY_START_DATE = "jmeter.reportgenerator.start_date";
    private static final String REPORT_GENERATOR_KEY_END_DATE = "jmeter.reportgenerator.end_date";
    public static final String GRAPH_KEY_EXCLUDE_CONTROLLERS = "exclude_controllers";
    public static final Boolean GRAPH_KEY_EXCLUDE_CONTROLLERS_DEFAULT = Boolean.FALSE;
    public static final String GRAPH_KEY_TITLE = "title";
    public static final String GRAPH_KEY_TITLE_DEFAULT = "";
    public static final String EXPORTER_KEY_FILTERS_ONLY_SAMPLE_SERIES = "filters_only_sample_series";
    public static final Boolean EXPORTER_KEY_FILTERS_ONLY_SAMPLE_SERIES_DEFAULT = Boolean.TRUE;
    public static final String EXPORTER_KEY_SERIES_FILTER = "series_filter";
    public static final String EXPORTER_KEY_SERIES_FILTER_DEFAULT = "";
    public static final String EXPORTER_KEY_SHOW_CONTROLLERS_ONLY = "show_controllers_only";
    public static final Boolean EXPORTER_KEY_SHOW_CONTROLLERS_ONLY_DEFAULT = Boolean.FALSE;
    public static final String EXPORTER_KEY_GRAPH_EXTRA_OPTIONS = "graph_options";
    public static final String SUBCONF_KEY_CLASSNAME = "classname";
    public static final String SUBCONF_KEY_PROPERTY = "property";
    private String reportTitle;
    private Date startDate;
    private Date endDate;
    private String sampleFilter;
    private File tempDirectory;
    private long apdexSatisfiedThreshold;
    private long apdexToleratedThreshold;
    private Map<String, Long[]> apdexPerTransaction = new HashMap<String, Long[]>();
    private Pattern filteredSamplesPattern;
    private boolean ignoreTCFromTop5ErrorsBySampler;
    private Map<String, ExporterConfiguration> exportConfigurations = new HashMap<String, ExporterConfiguration>();
    private Map<String, GraphConfiguration> graphConfigurations = new HashMap<String, GraphConfiguration>();

    public final String getSampleFilter() {
        return this.sampleFilter;
    }

    public final void setSampleFilter(String sampleFilter) {
        this.sampleFilter = sampleFilter;
    }

    public final File getTempDirectory() {
        return this.tempDirectory;
    }

    public final void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public final long getApdexSatisfiedThreshold() {
        return this.apdexSatisfiedThreshold;
    }

    public final void setApdexSatisfiedThreshold(long apdexSatisfiedThreshold) {
        this.apdexSatisfiedThreshold = apdexSatisfiedThreshold;
    }

    public final long getApdexToleratedThreshold() {
        return this.apdexToleratedThreshold;
    }

    public final void setApdexToleratedThreshold(long apdexToleratedThreshold) {
        this.apdexToleratedThreshold = apdexToleratedThreshold;
    }

    public Map<String, Long[]> getApdexPerTransaction() {
        return this.apdexPerTransaction;
    }

    public void setApdexPerTransaction(Map<String, Long[]> apdexPerTransaction) {
        this.apdexPerTransaction = apdexPerTransaction;
    }

    public final Map<String, ExporterConfiguration> getExportConfigurations() {
        return this.exportConfigurations;
    }

    public final Map<String, GraphConfiguration> getGraphConfigurations() {
        return this.graphConfigurations;
    }

    public static String getSubConfigurationPropertyPrefix(String keyPrefix, String subConfId) {
        return keyPrefix + '.' + subConfId;
    }

    public static String getSubConfigurationPropertyKey(String keyPrefix, String subConfId, String propertyName) {
        return ReportGeneratorConfiguration.getSubConfigurationPropertyPrefix(keyPrefix, subConfId) + '.' + propertyName;
    }

    public static String getExporterPropertyKey(String exporterId, String propertyName) {
        return ReportGeneratorConfiguration.getSubConfigurationPropertyPrefix(REPORT_GENERATOR_EXPORTER_KEY_PREFIX, exporterId) + '.' + propertyName;
    }

    public static String getGraphPropertyKey(String graphId, String propertyName) {
        return ReportGeneratorConfiguration.getSubConfigurationPropertyPrefix(REPORT_GENERATOR_GRAPH_KEY_PREFIX, graphId) + '.' + propertyName;
    }

    private static <TProperty> TProperty getProperty(Props props, String key, TProperty defaultValue, Class<TProperty> clazz) throws ConfigurationException {
        String value = props.getValue(key);
        if (value == null) {
            log.info("Property '{}' not found, using default value '{}' instead.", (Object)key, defaultValue);
            return defaultValue;
        }
        return ConfigurationUtils.convert(value, clazz);
    }

    private static <TProperty> TProperty getOptionalProperty(Props props, String key, Class<TProperty> clazz) throws ConfigurationException {
        TProperty property = ReportGeneratorConfiguration.getProperty(props, key, null, clazz);
        if (property != null) {
            log.debug("Use '{}' value for optional property '{}'", property, (Object)key);
        }
        return property;
    }

    private static <TProperty> TProperty getRequiredProperty(Props props, String key, TProperty defaultValue, Class<TProperty> clazz) throws ConfigurationException {
        TProperty property = ReportGeneratorConfiguration.getProperty(props, key, defaultValue, clazz);
        log.debug("Use '{}' value for required property '{}'", property, (Object)key);
        return property;
    }

    private static <TSubConf extends SubConfiguration> void loadSubConfiguration(Map<String, TSubConf> subConfigurations, Props props, String propertyPrefix, boolean noPropertyKey, SubConfigurationFactory<TSubConf> factory) throws ConfigurationException {
        for (Map.Entry entry : props.innerMap(propertyPrefix).entrySet()) {
            String key = (String)entry.getKey();
            int index = key.indexOf(46);
            if (index > 0) {
                String name = key.substring(0, index);
                SubConfiguration subConfiguration = (SubConfiguration)subConfigurations.get(name);
                if (subConfiguration != null) continue;
                subConfiguration = factory.createSubConfiguration();
                subConfigurations.put(name, subConfiguration);
                continue;
            }
            log.warn("Invalid property '{}', skip it.", (Object)key);
        }
        for (Map.Entry<Object, Object> entry : subConfigurations.entrySet()) {
            String subConfId = (String)entry.getKey();
            SubConfiguration subConfiguration = (SubConfiguration)entry.getValue();
            factory.initialize(subConfId, subConfiguration);
            Map extraKeys = props.innerMap(noPropertyKey ? ReportGeneratorConfiguration.getSubConfigurationPropertyPrefix(propertyPrefix, subConfId) : ReportGeneratorConfiguration.getSubConfigurationPropertyKey(propertyPrefix, subConfId, SUBCONF_KEY_PROPERTY));
            Map<String, String> extraProperties = subConfiguration.getProperties();
            for (Map.Entry entryProperty : extraKeys.entrySet()) {
                extraProperties.put((String)entryProperty.getKey(), (String)entryProperty.getValue());
            }
        }
    }

    public static ReportGeneratorConfiguration loadFromProperties(Properties properties) throws ConfigurationException {
        log.debug("Report generator properties loading");
        ReportGeneratorConfiguration configuration = new ReportGeneratorConfiguration();
        Props props = new Props();
        log.debug("Loading properties:\r\n{}", (Object)properties);
        props.load((Map)properties);
        File tempDirectory = ReportGeneratorConfiguration.getRequiredProperty(props, REPORT_GENERATOR_KEY_TEMP_DIR, REPORT_GENERATOR_KEY_TEMP_DIR_DEFAULT, File.class);
        configuration.setTempDirectory(tempDirectory);
        long apdexSatisfiedThreshold = ReportGeneratorConfiguration.getRequiredProperty(props, REPORT_GENERATOR_KEY_APDEX_SATISFIED_THRESHOLD, REPORT_GENERATOR_KEY_APDEX_SATISFIED_THRESHOLD_DEFAULT, Long.TYPE);
        configuration.setApdexSatisfiedThreshold(apdexSatisfiedThreshold);
        long apdexToleratedThreshold = ReportGeneratorConfiguration.getRequiredProperty(props, REPORT_GENERATOR_KEY_APDEX_TOLERATED_THRESHOLD, REPORT_GENERATOR_KEY_APDEX_TOLERATED_THRESHOLD_DEFAULT, Long.TYPE);
        configuration.setApdexToleratedThreshold(apdexToleratedThreshold);
        String apdexPerTransaction = ReportGeneratorConfiguration.getOptionalProperty(props, REPORT_GENERATOR_KEY_APDEX_PER_TRANSACTION, String.class);
        configuration.setApdexPerTransaction(ReportGeneratorConfiguration.getApdexPerTransactionParts(apdexPerTransaction));
        boolean ignoreTCFromTop5ErrorsBySampler = ReportGeneratorConfiguration.getRequiredProperty(props, REPORT_GENERATOR_KEY_EXCLUDE_TC_FROM_TOP5_ERRORS_BY_SAMPLER, Boolean.TRUE, Boolean.class);
        configuration.setIgnoreTCFromTop5ErrorsBySampler(ignoreTCFromTop5ErrorsBySampler);
        String sampleFilter = ReportGeneratorConfiguration.getOptionalProperty(props, REPORT_GENERATOR_KEY_SAMPLE_FILTER, String.class);
        configuration.setSampleFilter(sampleFilter);
        String reportTitle = ReportGeneratorConfiguration.getOptionalProperty(props, REPORT_GENERATOR_KEY_REPORT_TITLE, String.class);
        configuration.setReportTitle(reportTitle);
        Date reportStartDate = null;
        Date reportEndDate = null;
        String startDateValue = ReportGeneratorConfiguration.getOptionalProperty(props, REPORT_GENERATOR_KEY_START_DATE, String.class);
        String endDateValue = ReportGeneratorConfiguration.getOptionalProperty(props, REPORT_GENERATOR_KEY_END_DATE, String.class);
        String rangeDateFormat = ReportGeneratorConfiguration.getOptionalProperty(props, REPORT_GENERATOR_KEY_RANGE_DATE_FORMAT, String.class);
        if (StringUtils.isEmpty((CharSequence)rangeDateFormat)) {
            rangeDateFormat = RANGE_DATE_FORMAT_DEFAULT;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(rangeDateFormat, Locale.ENGLISH);
        try {
            if (!StringUtils.isEmpty((CharSequence)startDateValue)) {
                reportStartDate = dateFormat.parse(startDateValue);
                configuration.setStartDate(reportStartDate);
            }
        }
        catch (ParseException e) {
            log.error("Error parsing property {} with value: {} using format: {}", new Object[]{REPORT_GENERATOR_KEY_START_DATE, startDateValue, rangeDateFormat, e});
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)endDateValue)) {
                reportEndDate = dateFormat.parse(endDateValue);
                configuration.setEndDate(reportEndDate);
            }
        }
        catch (ParseException e) {
            log.error("Error parsing property {} with value: {} using format: {}", new Object[]{REPORT_GENERATOR_KEY_END_DATE, endDateValue, rangeDateFormat, e});
        }
        log.info("Will use date range start date: {}, end date: {}", (Object)startDateValue, (Object)endDateValue);
        Map<String, GraphConfiguration> graphConfigurations = configuration.getGraphConfigurations();
        ReportGeneratorConfiguration.loadSubConfiguration(graphConfigurations, props, REPORT_GENERATOR_GRAPH_KEY_PREFIX, false, new GraphConfigurationFactory(props));
        if (graphConfigurations.isEmpty()) {
            log.info("No graph configuration found.");
        }
        Map<String, ExporterConfiguration> exportConfigurations = configuration.getExportConfigurations();
        ReportGeneratorConfiguration.loadSubConfiguration(exportConfigurations, props, REPORT_GENERATOR_EXPORTER_KEY_PREFIX, false, new ExporterConfigurationFactory(props));
        if (exportConfigurations.isEmpty()) {
            log.warn("No export configuration found. No report will be generated.");
        }
        log.debug("End of report generator properties loading");
        return configuration;
    }

    public static Map<String, Long[]> getApdexPerTransactionParts(String apdexPerTransaction) {
        HashMap<String, Long[]> specificApdexes = new HashMap<String, Long[]>();
        if (StringUtils.isEmpty((CharSequence)apdexPerTransaction) || apdexPerTransaction.trim().length() == 0) {
            log.info("apdex_per_transaction : {} is empty, not APDEX per transaction customization");
        } else {
            String[] parts;
            for (String chunk : parts = apdexPerTransaction.split("[;]")) {
                int colonSeparator = chunk.lastIndexOf(58);
                int pipeSeparator = chunk.lastIndexOf(124);
                if (colonSeparator == -1 || pipeSeparator == -1 || pipeSeparator <= colonSeparator) {
                    log.error("error parsing property apdex_per_transaction around chunk {}. Wrong format, should have been: 'sample:satisfiedMs|toleratedMS', ignoring", (Object)chunk);
                    continue;
                }
                String key = chunk.substring(0, colonSeparator).trim();
                Long satisfied = Long.valueOf(chunk.substring(colonSeparator + 1, pipeSeparator).trim());
                Long tolerated = Long.valueOf(chunk.substring(pipeSeparator + 1).trim());
                specificApdexes.put(key, new Long[]{satisfied, tolerated});
            }
        }
        return specificApdexes;
    }

    public String getReportTitle() {
        return this.reportTitle;
    }

    public void setReportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
    }

    public Pattern getFilteredSamplesPattern() {
        if (StringUtils.isEmpty((CharSequence)this.sampleFilter)) {
            return null;
        }
        if (this.filteredSamplesPattern == null) {
            this.filteredSamplesPattern = Pattern.compile(this.sampleFilter);
        }
        return this.filteredSamplesPattern;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isIgnoreTCFromTop5ErrorsBySampler() {
        return this.ignoreTCFromTop5ErrorsBySampler;
    }

    public void setIgnoreTCFromTop5ErrorsBySampler(boolean ignoreTCFromTop5ErrorsBySampler) {
        this.ignoreTCFromTop5ErrorsBySampler = ignoreTCFromTop5ErrorsBySampler;
    }

    private static interface SubConfigurationFactory<T extends SubConfiguration> {
        public T createSubConfiguration();

        public void initialize(String var1, T var2) throws ConfigurationException;
    }

    private static final class GraphConfigurationFactory
    implements SubConfigurationFactory<GraphConfiguration> {
        private final Props props;

        private GraphConfigurationFactory(Props props) {
            this.props = props;
        }

        @Override
        public GraphConfiguration createSubConfiguration() {
            return new GraphConfiguration();
        }

        @Override
        public void initialize(String graphId, GraphConfiguration graphConfiguration) throws ConfigurationException {
            log.debug("Load configuration for graph '{}'", (Object)graphId);
            boolean excludeControllers = (Boolean)ReportGeneratorConfiguration.getRequiredProperty(this.props, ReportGeneratorConfiguration.getGraphPropertyKey(graphId, ReportGeneratorConfiguration.GRAPH_KEY_EXCLUDE_CONTROLLERS), GRAPH_KEY_EXCLUDE_CONTROLLERS_DEFAULT, Boolean.class);
            graphConfiguration.setExcludeControllers(excludeControllers);
            String title = (String)ReportGeneratorConfiguration.getRequiredProperty(this.props, ReportGeneratorConfiguration.getGraphPropertyKey(graphId, ReportGeneratorConfiguration.GRAPH_KEY_TITLE), "", String.class);
            graphConfiguration.setTitle(title);
            String className = (String)ReportGeneratorConfiguration.getRequiredProperty(this.props, ReportGeneratorConfiguration.getGraphPropertyKey(graphId, ReportGeneratorConfiguration.SUBCONF_KEY_CLASSNAME), "", String.class);
            log.debug("Using class:'{}' for graph:'{}' with id:'{}'", new Object[]{className, title, graphId});
            graphConfiguration.setClassName(className);
        }
    }

    private static final class ExporterConfigurationFactory
    implements SubConfigurationFactory<ExporterConfiguration> {
        private final Props props;

        private ExporterConfigurationFactory(Props props) {
            this.props = props;
        }

        @Override
        public ExporterConfiguration createSubConfiguration() {
            return new ExporterConfiguration();
        }

        @Override
        public void initialize(String exportId, ExporterConfiguration exportConfiguration) throws ConfigurationException {
            log.debug("Load configuration for exporter '{}'", (Object)exportId);
            String className = (String)ReportGeneratorConfiguration.getRequiredProperty(this.props, ReportGeneratorConfiguration.getExporterPropertyKey(exportId, ReportGeneratorConfiguration.SUBCONF_KEY_CLASSNAME), "", String.class);
            log.debug("Using class:'{}' for exporter:'{}'", (Object)className, (Object)exportId);
            exportConfiguration.setClassName(className);
            boolean filtersOnlySampleSeries = (Boolean)ReportGeneratorConfiguration.getRequiredProperty(this.props, ReportGeneratorConfiguration.getExporterPropertyKey(exportId, ReportGeneratorConfiguration.EXPORTER_KEY_FILTERS_ONLY_SAMPLE_SERIES), EXPORTER_KEY_FILTERS_ONLY_SAMPLE_SERIES_DEFAULT, Boolean.class);
            exportConfiguration.filtersOnlySampleSeries(filtersOnlySampleSeries);
            String seriesFilter = (String)ReportGeneratorConfiguration.getRequiredProperty(this.props, ReportGeneratorConfiguration.getExporterPropertyKey(exportId, ReportGeneratorConfiguration.EXPORTER_KEY_SERIES_FILTER), "", String.class);
            exportConfiguration.setSeriesFilter(seriesFilter);
            boolean showControllerSeriesOnly = (Boolean)ReportGeneratorConfiguration.getRequiredProperty(this.props, ReportGeneratorConfiguration.getExporterPropertyKey(exportId, ReportGeneratorConfiguration.EXPORTER_KEY_SHOW_CONTROLLERS_ONLY), EXPORTER_KEY_SHOW_CONTROLLERS_ONLY_DEFAULT, Boolean.class);
            exportConfiguration.showControllerSeriesOnly(showControllerSeriesOnly);
            Map<String, SubConfiguration> graphExtraConfigurations = exportConfiguration.getGraphExtraConfigurations();
            ReportGeneratorConfiguration.loadSubConfiguration(graphExtraConfigurations, this.props, ReportGeneratorConfiguration.getSubConfigurationPropertyKey(ReportGeneratorConfiguration.REPORT_GENERATOR_EXPORTER_KEY_PREFIX, exportId, ReportGeneratorConfiguration.EXPORTER_KEY_GRAPH_EXTRA_OPTIONS), true, new SubConfigurationFactory<SubConfiguration>(){

                @Override
                public SubConfiguration createSubConfiguration() {
                    return new SubConfiguration();
                }

                @Override
                public void initialize(String subConfId, SubConfiguration subConfiguration) {
                }
            });
        }
    }
}

