/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.jmeter.extractor.BoundaryExtractor;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

@GUIMenuSortOrder(value=4)
public class BoundaryExtractorGui
extends AbstractPostProcessorGui {
    private static final long serialVersionUID = 240L;
    private JLabeledTextField leftBoundaryField;
    private JLabeledTextField rightBoundaryField;
    private JLabeledTextField defaultField;
    private JLabeledTextField matchNumberField;
    private JLabeledTextField refNameField;
    private JCheckBox emptyDefaultValue;
    private JRadioButton useBody;
    private JRadioButton useUnescapedBody;
    private JRadioButton useBodyAsDocument;
    private JRadioButton useHeaders;
    private JRadioButton useRequestHeaders;
    private JRadioButton useURL;
    private JRadioButton useCode;
    private JRadioButton useMessage;
    private ButtonGroup group;

    public BoundaryExtractorGui() {
        this.init();
    }

    public String getLabelResource() {
        return "boundaryextractor_title";
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof BoundaryExtractor) {
            BoundaryExtractor boundary = (BoundaryExtractor)el;
            this.showScopeSettings(boundary, true);
            this.useHeaders.setSelected(boundary.useHeaders());
            this.useRequestHeaders.setSelected(boundary.useRequestHeaders());
            this.useBody.setSelected(boundary.useBody());
            this.useUnescapedBody.setSelected(boundary.useUnescapedBody());
            this.useBodyAsDocument.setSelected(boundary.useBodyAsDocument());
            this.useURL.setSelected(boundary.useUrl());
            this.useCode.setSelected(boundary.useCode());
            this.useMessage.setSelected(boundary.useMessage());
            this.leftBoundaryField.setText(boundary.getLeftBoundary());
            this.rightBoundaryField.setText(boundary.getRightBoundary());
            this.defaultField.setText(boundary.getDefaultValue());
            this.emptyDefaultValue.setSelected(boundary.isEmptyDefaultValue());
            this.matchNumberField.setText(boundary.getMatchNumberAsString());
            this.refNameField.setText(boundary.getRefName());
        }
    }

    public TestElement createTestElement() {
        BoundaryExtractor extractor = new BoundaryExtractor();
        this.modifyTestElement((TestElement)extractor);
        return extractor;
    }

    public void modifyTestElement(TestElement extractor) {
        super.configureTestElement(extractor);
        if (extractor instanceof BoundaryExtractor) {
            BoundaryExtractor boundary = (BoundaryExtractor)extractor;
            this.saveScopeSettings(boundary);
            boundary.setUseField(this.group.getSelection().getActionCommand());
            boundary.setRefName(this.refNameField.getText());
            boundary.setLeftBoundary(this.leftBoundaryField.getText());
            boundary.setRightBoundary(this.rightBoundaryField.getText());
            boundary.setDefaultValue(this.defaultField.getText());
            boundary.setDefaultEmptyValue(this.emptyDefaultValue.isSelected());
            boundary.setMatchNumber(this.matchNumberField.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.useBody.setSelected(true);
        this.leftBoundaryField.setText("");
        this.rightBoundaryField.setText("");
        this.defaultField.setText("");
        this.refNameField.setText("");
        this.emptyDefaultValue.setSelected(false);
        this.matchNumberField.setText("");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createScopePanel(true));
        box.add(this.makeSourcePanel());
        this.add(box, "North");
        this.add(this.makeParameterPanel(), "Center");
    }

    private JPanel makeSourcePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"regex_source")));
        this.useBody = new JRadioButton(JMeterUtils.getResString((String)"regex_src_body"));
        this.useUnescapedBody = new JRadioButton(JMeterUtils.getResString((String)"regex_src_body_unescaped"));
        this.useBodyAsDocument = new JRadioButton(JMeterUtils.getResString((String)"regex_src_body_as_document"));
        this.useHeaders = new JRadioButton(JMeterUtils.getResString((String)"regex_src_hdrs"));
        this.useRequestHeaders = new JRadioButton(JMeterUtils.getResString((String)"regex_src_hdrs_req"));
        this.useURL = new JRadioButton(JMeterUtils.getResString((String)"regex_src_url"));
        this.useCode = new JRadioButton(JMeterUtils.getResString((String)"assertion_code_resp"));
        this.useMessage = new JRadioButton(JMeterUtils.getResString((String)"assertion_message_resp"));
        this.group = new ButtonGroup();
        this.group.add(this.useBody);
        this.group.add(this.useUnescapedBody);
        this.group.add(this.useBodyAsDocument);
        this.group.add(this.useHeaders);
        this.group.add(this.useRequestHeaders);
        this.group.add(this.useURL);
        this.group.add(this.useCode);
        this.group.add(this.useMessage);
        panel.add(this.useBody);
        panel.add(this.useUnescapedBody);
        panel.add(this.useBodyAsDocument);
        panel.add(this.useHeaders);
        panel.add(this.useRequestHeaders);
        panel.add(this.useURL);
        panel.add(this.useCode);
        panel.add(this.useMessage);
        this.useBody.setSelected(true);
        this.useBody.setActionCommand("false");
        this.useUnescapedBody.setActionCommand("unescaped");
        this.useBodyAsDocument.setActionCommand("as_document");
        this.useHeaders.setActionCommand("true");
        this.useRequestHeaders.setActionCommand("request_headers");
        this.useURL.setActionCommand("URL");
        this.useCode.setActionCommand("code");
        this.useMessage.setActionCommand("message");
        return panel;
    }

    private JPanel makeParameterPanel() {
        this.leftBoundaryField = new JLabeledTextField(JMeterUtils.getResString((String)"boundaryextractor_leftboundary_field"));
        this.rightBoundaryField = new JLabeledTextField(JMeterUtils.getResString((String)"boundaryextractor_rightboundary_field"));
        this.refNameField = new JLabeledTextField(JMeterUtils.getResString((String)"ref_name_field"));
        this.matchNumberField = new JLabeledTextField(JMeterUtils.getResString((String)"match_num_field"));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.initConstraints(gbc);
        this.addField(panel, this.refNameField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.leftBoundaryField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.rightBoundaryField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.matchNumberField, gbc);
        this.resetContraints(gbc);
        gbc.weighty = 1.0;
        this.defaultField = new JLabeledTextField(JMeterUtils.getResString((String)"default_value_field"));
        List item = this.defaultField.getComponentList();
        panel.add((Component)item.get(0), gbc.clone());
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)item.get(1), "West");
        this.emptyDefaultValue = new JCheckBox(JMeterUtils.getResString((String)"boundaryextractor_empty_default_value"));
        this.emptyDefaultValue.addItemListener(evt -> {
            if (this.emptyDefaultValue.isSelected()) {
                this.defaultField.setText("");
            }
            this.defaultField.setEnabled(!this.emptyDefaultValue.isSelected());
        });
        p.add((Component)this.emptyDefaultValue, "Center");
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)p, gbc.clone());
        return panel;
    }

    private void addField(JPanel panel, JLabeledTextField field, GridBagConstraints gbc) {
        List item = field.getComponentList();
        panel.add((Component)item.get(0), gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)item.get(1), gbc.clone());
    }

    private void resetContraints(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
    }

    private void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }
}

